/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImagingException;

public class FormatCompliance {
    private static final Logger LOGGER = Logger.getLogger(FormatCompliance.class.getName());
    private final boolean failOnError;
    private final String description;
    private final List<String> comments = new ArrayList<String>();

    public static FormatCompliance getDefault() {
        return new FormatCompliance("ignore", false);
    }

    /*
     * WARNING - void declaration
     */
    private FormatCompliance(String description, boolean failOnError) {
        void var1_1;
        this.description = var1_1;
        this.failOnError = false;
    }

    /*
     * WARNING - void declaration
     */
    private void addComment(String comment) throws ImagingException {
        this.comments.add(comment);
        if (this.failOnError) {
            void var1_1;
            throw new ImagingException((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addComment(String comment, int value) throws ImagingException {
        void var2_2;
        void var1_1;
        this.addComment((String)var1_1 + ": " + FormatCompliance.getValueDescription((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkBounds(String name, int min, int max, int actual) throws ImagingException {
        if (actual < min || actual > max) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.addComment((String)var1_1 + ": bounds check: " + (int)var2_2 + " <= " + actual + " <= " + (int)var3_3 + ": false");
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean compare(String name, int valid, int actual) throws ImagingException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.compare((String)var1_1, new int[]{var2_2}, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean compare(String name, int[] valid, int actual) throws ImagingException {
        void var3_3;
        void var2_2;
        void var1_1;
        int[] nArray = valid;
        int n = valid.length;
        for (int i = 0; i < n; ++i) {
            int element = nArray[i];
            if (actual != element) continue;
            return true;
        }
        StringBuilder result = new StringBuilder(43);
        result.append((String)var1_1);
        result.append(": Unexpected value: (valid: ");
        if (valid.length > 1) {
            result.append('{');
        }
        for (int i = 0; i < valid.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(FormatCompliance.getValueDescription(valid[i]));
        }
        if (((void)var2_2).length > 1) {
            result.append('}');
        }
        result.append(", actual: ").append(FormatCompliance.getValueDescription((int)var3_3)).append(")");
        this.addComment(result.toString());
        return false;
    }

    public final boolean compareBytes(String name, byte[] expected, byte[] actual) throws ImagingException {
        if (expected.length != actual.length) {
            this.addComment(name + ": Unexpected length: (expected: " + expected.length + ", actual: " + actual.length + ")");
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            this.addComment(name + ": Unexpected value: (expected: " + FormatCompliance.getValueDescription(expected[i]) + ", actual: " + FormatCompliance.getValueDescription(actual[i]) + ")");
            return false;
        }
        return true;
    }

    private static String getValueDescription(int value) {
        int n;
        return value + " (" + Integer.toHexString(n) + ")";
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        FormatCompliance formatCompliance;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        void var3_3 = formatCompliance;
        formatCompliance = this;
        var3_3.println("Format Compliance: " + formatCompliance.description);
        if (formatCompliance.comments.isEmpty()) {
            var3_3.println("\tNo comments.");
        } else {
            for (int i = 0; i < formatCompliance.comments.size(); ++i) {
                var3_3.println("\t" + (i + 1) + ": " + formatCompliance.comments.get(i));
            }
        }
        var3_3.println("");
        var3_3.flush();
        return var1_1.getBuffer().toString();
    }
}

