/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BufferedImageFactory;
import org.apache.commons.imaging.common.SimpleBufferedImageFactory;
import org.apache.commons.imaging.formats.bmp.BmpImageParser;
import org.apache.commons.imaging.formats.dcx.DcxImageParser;
import org.apache.commons.imaging.formats.gif.GifImageParser;
import org.apache.commons.imaging.formats.icns.IcnsImageParser;
import org.apache.commons.imaging.formats.ico.IcoImageParser;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.pcx.PcxImageParser;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.pnm.PnmImageParser;
import org.apache.commons.imaging.formats.psd.PsdImageParser;
import org.apache.commons.imaging.formats.rgbe.RgbeImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.wbmp.WbmpImageParser;
import org.apache.commons.imaging.formats.webp.WebPImageParser;
import org.apache.commons.imaging.formats.xbm.XbmImageParser;
import org.apache.commons.imaging.formats.xpm.XpmImageParser;

public abstract class AbstractImageParser<T extends ImagingParameters<T>>
extends BinaryFileParser {
    private static final Logger LOGGER = Logger.getLogger(AbstractImageParser.class.getName());

    public static List<AbstractImageParser<?>> getAllImageParsers() {
        return Arrays.asList(new BmpImageParser(), new DcxImageParser(), new GifImageParser(), new IcnsImageParser(), new IcoImageParser(), new JpegImageParser(), new PcxImageParser(), new PngImageParser(), new PnmImageParser(), new PsdImageParser(), new RgbeImageParser(), new TiffImageParser(), new WebPImageParser(), new WbmpImageParser(), new XbmImageParser(), new XpmImageParser());
    }

    public AbstractImageParser() {
    }

    /*
     * WARNING - void declaration
     */
    public AbstractImageParser(ByteOrder byteOrder) {
        super((ByteOrder)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean canAcceptExtension(String fileName) {
        String[] extensions = this.getAcceptedExtensions();
        if (extensions == null) {
            return true;
        }
        int index = fileName.lastIndexOf(46);
        if (index >= 0) {
            void var2_2;
            int n;
            String fileNameExtension = fileName.substring((int)(n + true)).toLowerCase(Locale.ENGLISH);
            for (void var5_5 : var2_2) {
                if (!var5_5.equals(fileNameExtension)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean canAcceptType(ImageFormat type) {
        ImageFormat[] imageFormatArray = this.getAcceptedTypes();
        ImageFormat[] imageFormatArray2 = imageFormatArray;
        imageFormatArray2 = imageFormatArray;
        int n = imageFormatArray.length;
        for (int i = 0; i < n; ++i) {
            ImageFormat imageFormat = imageFormatArray2[i];
            if (!imageFormat.equals(type)) continue;
            return true;
        }
        return false;
    }

    protected abstract String[] getAcceptedExtensions();

    protected abstract ImageFormat[] getAcceptedTypes();

    /*
     * WARNING - void declaration
     */
    public List<BufferedImage> getAllBufferedImages(ByteSource byteSource) throws ImagingException, IOException {
        void var2_2;
        void var1_1;
        BufferedImage bi = this.getBufferedImage(byteSource, null);
        ArrayList<void> result = new ArrayList<void>();
        result.add(var1_1);
        return var2_2;
    }

    public abstract BufferedImage getBufferedImage(ByteSource var1, T var2) throws ImagingException, IOException;

    protected static BufferedImageFactory getBufferedImageFactory(T params) {
        if (params == null) {
            return new SimpleBufferedImageFactory();
        }
        Object result = ((ImagingParameters)params).getBufferedImageFactory();
        if (result != null) {
            Object object;
            return object;
        }
        return new SimpleBufferedImageFactory();
    }
}

