/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ConfiguratorRank;
import ch.qos.logback.classic.util.ClassicEnvUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareImpl;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "logback.xml";
    public static final String TEST_AUTOCONFIG_FILE = "logback-test.xml";
    public static final String CONFIG_FILE_PROPERTY = "logback.configurationFile";
    String[] INTERNAL_CONFIGURATOR_CLASSNAME_LIST = new String[]{"ch.qos.logback.classic.joran.SerializedModelConfigurator", "ch.qos.logback.classic.util.DefaultJoranConfigurator", "ch.qos.logback.classic.BasicConfigurator"};
    final LoggerContext loggerContext;
    final ContextAware contextAware;
    Comparator<Configurator> rankComparator = new Comparator<Configurator>(this){
        final /* synthetic */ ContextInitializer this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(Configurator c1, Configurator c2) {
            void var2_4;
            int n;
            ConfiguratorRank r1 = c1.getClass().getAnnotation(ConfiguratorRank.class);
            ConfiguratorRank r2 = c2.getClass().getAnnotation(ConfiguratorRank.class);
            int value1 = r1 == null ? 20 : r1.value();
            int value2 = r2 == null ? 20 : r2.value();
            n = this.this$0.compareRankValue(n, (int)var2_4);
            return -n;
        }
    };

    /*
     * WARNING - void declaration
     */
    public ContextInitializer(LoggerContext loggerContext) {
        void var1_1;
        this.loggerContext = loggerContext;
        this.contextAware = new ContextAwareImpl((Context)var1_1, (Object)this);
    }

    public void autoConfig() throws JoranException {
        this.autoConfig(Configurator.class.getClassLoader());
    }

    public void autoConfig(ClassLoader classLoader) throws JoranException {
        String[] stringArray;
        classLoader = Loader.systemClassloaderIfNull((ClassLoader)classLoader);
        String versionStr = EnvUtil.logbackVersion();
        if (versionStr == null) {
            versionStr = "?";
        }
        this.loggerContext.getStatusManager().add((Status)new InfoStatus("This is logback-classic version " + versionStr, (Object)this.loggerContext));
        StatusListenerConfigHelper.installIfAsked((Context)this.loggerContext);
        List<Configurator> configuratorList = ClassicEnvUtil.loadFromServiceLoader(Configurator.class, classLoader);
        configuratorList.sort(this.rankComparator);
        if (configuratorList.isEmpty()) {
            this.contextAware.addInfo("No custom configurators were discovered as a service.");
        } else {
            this.printConfiguratorOrder(configuratorList);
        }
        for (Configurator configurator : stringArray) {
            if (this.invokeConfigure(configurator) != Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY) continue;
            return;
        }
        stringArray = this.INTERNAL_CONFIGURATOR_CLASSNAME_LIST;
        int n = this.INTERNAL_CONFIGURATOR_CLASSNAME_LIST.length;
        for (int i = 0; i < n; ++i) {
            String configuratorClassName = stringArray[i];
            this.contextAware.addInfo("Trying to configure with " + configuratorClassName);
            Configurator c = this.instantiateConfiguratorByClassName(configuratorClassName, classLoader);
            if (c == null || this.invokeConfigure(c) != Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY) continue;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Configurator instantiateConfiguratorByClassName(String configuratorClassName, ClassLoader classLoader) {
        try {
            configuratorClassName = classLoader.loadClass((String)configuratorClassName);
            return (Configurator)((Class)configuratorClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            void var1_2;
            this.contextAware.addInfo("Instantiation failure: " + var1_2.toString());
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Configurator.ExecutionStatus invokeConfigure(Configurator configurator) {
        try {
            long start = System.currentTimeMillis();
            this.contextAware.addInfo("Constructed configurator of type " + String.valueOf(configurator.getClass()));
            configurator.setContext((Context)this.loggerContext);
            Configurator.ExecutionStatus status = configurator.configure(this.loggerContext);
            this.printDuration(start, configurator, status);
            return status;
        }
        catch (Exception e) {
            void var2_3;
            void var1_1;
            throw new LogbackException(String.format("Failed to initialize or to run Configurator: %s", configurator != null ? var1_1.getClass().getCanonicalName() : "null"), (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printConfiguratorOrder(List<Configurator> configuratorList) {
        Iterator iterator;
        this.contextAware.addInfo("Here is a list of configurators discovered as a service, by rank: ");
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Configurator c = (Configurator)iterator.next();
            this.contextAware.addInfo("  " + var2_2.getClass().getName());
        }
        this.contextAware.addInfo("They will be invoked in order until ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY is returned.");
    }

    /*
     * WARNING - void declaration
     */
    private void printDuration(long start, Configurator configurator, Configurator.ExecutionStatus executionStatus) {
        void var3_2;
        void var1_1;
        long l = System.currentTimeMillis();
        long diff = l - var1_1;
        this.contextAware.addInfo(var3_2.getClass().getName() + ".configure() call lasted " + diff + " milliseconds. ExecutionStatus=" + String.valueOf((Object)executionStatus));
    }

    /*
     * WARNING - void declaration
     */
    private Configurator.ExecutionStatus attemptConfigurationUsingJoranUsingReflexion(ClassLoader classLoader) {
        try {
            classLoader = ((ClassLoader)classLoader).loadClass("ch.qos.logback.classic.util.DefaultJoranConfigurator");
            Configurator c = (Configurator)((Class)classLoader).newInstance();
            c.setContext((Context)this.loggerContext);
            return c.configure(this.loggerContext);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            void var1_2;
            this.contextAware.addError("unexpected exception while instantiating DefaultJoranConfigurator", (Throwable)var1_2);
            return Configurator.ExecutionStatus.INVOKE_NEXT_IF_ANY;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int compareRankValue(int value1, int value2) {
        void var2_2;
        void var1_1;
        if (value1 > value2) {
            return 1;
        }
        if (var1_1 == var2_2) {
            return 0;
        }
        return -1;
    }
}

