/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.CoreConstants;

public class ThrowableProxyUtil {
    public static final int REGULAR_EXCEPTION_INDENT = 1;
    public static final int SUPPRESSED_EXCEPTION_INDENT = 1;
    private static final int BUILDER_CAPACITY = 2048;

    /*
     * WARNING - void declaration
     */
    public static void build(ThrowableProxy nestedTP, Throwable nestedThrowable, ThrowableProxy parentTP) {
        void var1_1;
        void var3_3;
        StackTraceElement[] nestedSTE = nestedThrowable.getStackTrace();
        int commonFramesCount = -1;
        if (parentTP != null) {
            void var2_2;
            commonFramesCount = ThrowableProxyUtil.findNumberOfCommonFrames(nestedSTE, var2_2.getStackTraceElementProxyArray());
        }
        nestedTP.commonFrames = var3_3;
        var0.stackTraceElementProxyArray = ThrowableProxyUtil.steArrayToStepArray((StackTraceElement[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static StackTraceElementProxy[] steArrayToStepArray(StackTraceElement[] stea) {
        void var1_1;
        if (stea == null) {
            return new StackTraceElementProxy[0];
        }
        StackTraceElementProxy[] stepa = new StackTraceElementProxy[stea.length];
        for (int i = 0; i < stepa.length; ++i) {
            stepa[i] = new StackTraceElementProxy(stea[i]);
        }
        return var1_1;
    }

    static int findNumberOfCommonFrames(StackTraceElement[] steArray, StackTraceElementProxy[] parentSTEPArray) {
        StackTraceElement otherSte;
        StackTraceElement ste;
        if (parentSTEPArray == null || steArray == null) {
            return 0;
        }
        int steIndex = steArray.length - 1;
        int count = 0;
        for (int parentIndex = parentSTEPArray.length - 1; steIndex >= 0 && parentIndex >= 0 && (ste = steArray[steIndex]).equals(otherSte = parentSTEPArray[parentIndex].ste); --steIndex, --parentIndex) {
            ++count;
        }
        return count;
    }

    /*
     * WARNING - void declaration
     */
    public static String asString(IThrowableProxy tp) {
        void var1_1;
        IThrowableProxy iThrowableProxy;
        StringBuilder sb = new StringBuilder(2048);
        ThrowableProxyUtil.recursiveAppend(sb, null, 1, iThrowableProxy);
        return var1_1.toString();
    }

    private static void recursiveAppend(StringBuilder sb, String prefix, int indent, IThrowableProxy tp) {
        while (tp != null) {
            String string;
            ThrowableProxyUtil.subjoinFirstLine(sb, prefix, indent, tp);
            sb.append(CoreConstants.LINE_SEPARATOR);
            ThrowableProxyUtil.subjoinSTEPArray(sb, indent, tp);
            IThrowableProxy[] suppressed = tp.getSuppressed();
            if (suppressed != null) {
                for (String current : string) {
                    ThrowableProxyUtil.recursiveAppend(sb, "Suppressed: ", indent + 1, (IThrowableProxy)((Object)current));
                }
            }
            tp = tp.getCause();
            string = "Caused by: ";
        }
        return;
    }

    public static void indent(StringBuilder buf, int indent) {
        for (int j = 0; j < indent; ++j) {
            buf.append('\t');
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void subjoinFirstLine(StringBuilder buf, String prefix, int indent, IThrowableProxy tp) {
        void var3_3;
        StringBuilder stringBuilder;
        void var2_2;
        ThrowableProxyUtil.indent(buf, (int)(var2_2 - true));
        if (prefix != null) {
            void var1_1;
            buf.append((String)var1_1);
        }
        ThrowableProxyUtil.subjoinExceptionMessage(stringBuilder, (IThrowableProxy)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void subjoinPackagingData(StringBuilder builder, StackTraceElementProxy step) {
        ClassPackagingData cpd;
        if (step != null && (cpd = step.getClassPackagingData()) != null) {
            void var1_1;
            StringBuilder stringBuilder;
            if (!cpd.isExact()) {
                builder.append(" ~[");
            } else {
                builder.append(" [");
            }
            stringBuilder.append(cpd.getCodeLocation()).append(':').append(var1_1.getVersion()).append(']');
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void subjoinSTEP(StringBuilder sb, StackTraceElementProxy step) {
        void var1_1;
        StringBuilder stringBuilder;
        sb.append(step.toString());
        ThrowableProxyUtil.subjoinPackagingData(stringBuilder, (StackTraceElementProxy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void subjoinSTEPArray(StringBuilder sb, IThrowableProxy tp) {
        void var1_1;
        ThrowableProxyUtil.subjoinSTEPArray(sb, 1, (IThrowableProxy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void subjoinSTEPArray(StringBuilder sb, int indentLevel, IThrowableProxy tp) {
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        int commonFrames = tp.getCommonFrames();
        for (int i = 0; i < stepArray.length - commonFrames; ++i) {
            StackTraceElementProxy step = stepArray[i];
            ThrowableProxyUtil.indent(sb, indentLevel);
            ThrowableProxyUtil.subjoinSTEP(sb, step);
            sb.append(CoreConstants.LINE_SEPARATOR);
        }
        if (commonFrames > 0) {
            void var2_3;
            StringBuilder stringBuilder;
            void var1_1;
            ThrowableProxyUtil.indent(sb, (int)var1_1);
            stringBuilder.append("... ").append((int)var2_3).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void subjoinFirstLine(StringBuilder buf, IThrowableProxy tp) {
        void var1_1;
        StringBuilder stringBuilder;
        int n = tp.getCommonFrames();
        if (n > 0) {
            buf.append("Caused by: ");
        }
        ThrowableProxyUtil.subjoinExceptionMessage(stringBuilder, (IThrowableProxy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void subjoinFirstLineRootCauseFirst(StringBuilder buf, IThrowableProxy tp) {
        void var1_1;
        StringBuilder stringBuilder;
        if (tp.getCause() != null) {
            buf.append("Wrapped by: ");
        }
        ThrowableProxyUtil.subjoinExceptionMessage(stringBuilder, (IThrowableProxy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void subjoinExceptionMessage(StringBuilder buf, IThrowableProxy tp) {
        void var1_1;
        StringBuilder stringBuilder;
        if (tp.isCyclic()) {
            buf.append("[CIRCULAR REFERENCE: ").append(tp.getClassName()).append(": ").append(tp.getMessage()).append(']');
            return;
        }
        stringBuilder.append(tp.getClassName()).append(": ").append(var1_1.getMessage());
    }
}

