/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector.servlet;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import ch.qos.logback.core.util.JNDIUtil;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import javax.naming.Context;
import javax.naming.NamingException;

public class ContextDetachingSCL
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent arg0) {
    }

    /*
     * WARNING - void declaration
     */
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        Context context;
        String loggerContextName = null;
        try {
            context = JNDIUtil.getInitialContext();
            loggerContextName = JNDIUtil.lookupString((Context)context, (String)"java:comp/env/logback/context-name");
        }
        catch (NamingException namingException) {}
        if (loggerContextName != null) {
            void var1_1;
            System.out.println("About to detach context named " + loggerContextName);
            ContextSelector selector = ContextSelectorStaticBinder.getSingleton().getContextSelector();
            if (selector == null) {
                System.out.println("Selector is null, cannot detach context. Skipping.");
                return;
            }
            LoggerContext context2 = selector.getLoggerContext(loggerContextName);
            if (context2 != null) {
                void var3_3;
                Logger logger = context2.getLogger("ROOT");
                logger.warn("Stopping logger context " + loggerContextName);
                context.detachLoggerContext(loggerContextName);
                var3_3.stop();
                return;
            }
            System.out.println("No context named " + (String)var1_1 + " was found.");
        }
    }
}

