/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.time.ZoneId;
import java.util.Locale;

public class DateConverter
extends ClassicConverter {
    CachingDateFormatter cachingDateFormatter = null;

    /*
     * WARNING - void declaration
     */
    public void start() {
        String datePattern = this.getFirstOption();
        if (datePattern == null) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        } else if (datePattern.equals("ISO8601")) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        } else if (datePattern.equals("STRICT")) {
            datePattern = "yyyy-MM-dd'T'HH:mm:ss,SSS";
        }
        Object optionList = this.getOptionList();
        ZoneId zoneId = null;
        if (optionList != null && optionList.size() > 1) {
            String string = (String)optionList.get(1);
            zoneId = ZoneId.of(string);
            this.addInfo("Setting zoneId to \"" + String.valueOf(zoneId) + "\"");
        }
        Locale locale = null;
        if (optionList != null && optionList.size() > 2) {
            optionList = (String)optionList.get(2);
            locale = Locale.forLanguageTag((String)optionList);
            this.addInfo("Setting locale to \"" + String.valueOf(locale) + "\"");
        }
        try {
            this.cachingDateFormatter = new CachingDateFormatter(datePattern, zoneId, locale);
        }
        catch (IllegalArgumentException e) {
            void var3_4;
            void var2_3;
            void var1_1;
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + (String)var1_1, (Throwable)var2_3);
            this.cachingDateFormatter = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss,SSS", (ZoneId)var3_4);
        }
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    public String convert(ILoggingEvent le) {
        void var2_2;
        long timestamp = le.getTimeStamp();
        return this.cachingDateFormatter.format((long)var2_2);
    }
}

