/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.joran.ReconfigureOnChangeTask;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.classic.model.processor.ConfigurationModelHandler;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.OptionHelper;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ConfigurationModelHandlerFull
extends ConfigurationModelHandler {
    public static String FAILED_WATCH_PREDICATE_MESSAGE_1 = "Missing watchable .xml or .properties files.";
    public static String FAILED_WATCH_PREDICATE_MESSAGE_2 = "Watching .xml files requires that the main configuration file is reachable as a URL";

    /*
     * WARNING - void declaration
     */
    public ConfigurationModelHandlerFull(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static ModelHandlerBase makeInstance2(Context context, ModelInterpretationContext mic) {
        Context context2;
        return new ConfigurationModelHandlerFull(context2);
    }

    @Override
    protected void processScanAttrib(ModelInterpretationContext mic, ConfigurationModel configurationModel) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postHandle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        void var2_2;
        void var1_1;
        ConfigurationModel configurationModel = (ConfigurationModel)model;
        this.postProcessScanAttrib((ModelInterpretationContext)var1_1, (ConfigurationModel)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void postProcessScanAttrib(ModelInterpretationContext mic, ConfigurationModel configurationModel) {
        void var1_1;
        void var3_3;
        void var2_2;
        String scanStr = mic.subst(configurationModel.getScanStr());
        String scanPeriodStr = mic.subst(var2_2.getScanPeriodStr());
        this.detachedPostProcess((String)var3_3, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void detachedPostProcess(String scanStr, String scanPeriodStr) {
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)scanStr) && !"false".equalsIgnoreCase(scanStr)) {
            void var1_1;
            void var3_4;
            void var2_2;
            ScheduledExecutorService scheduledExecutorService = this.context.getScheduledExecutorService();
            boolean bl = ConfigurationWatchListUtil.watchPredicateFulfilled((Context)this.context);
            if (!bl) {
                this.addWarn(FAILED_WATCH_PREDICATE_MESSAGE_1);
                this.addWarn(FAILED_WATCH_PREDICATE_MESSAGE_2);
                return;
            }
            ReconfigureOnChangeTask rocTask = new ReconfigureOnChangeTask();
            rocTask.setContext(this.context);
            this.addInfo("Registering a new ReconfigureOnChangeTask " + String.valueOf(rocTask));
            this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationChangeDetectorRegisteredEvent((Object)rocTask));
            Duration duration = this.getDurationOfScanPeriodAttribute(scanPeriodStr, SCAN_PERIOD_DEFAULT);
            ConfigurationModelHandlerFull configurationModelHandlerFull = this;
            configurationModelHandlerFull.addInfo("Will scan for changes in [" + String.valueOf(ConfigurationWatchListUtil.getConfigurationWatchList((Context)configurationModelHandlerFull.context)) + "] ");
            this.addInfo("Setting ReconfigureOnChangeTask scanning period to " + String.valueOf(duration));
            ScheduledFuture<?> scheduledFuture = scheduledExecutorService.scheduleAtFixedRate(rocTask, duration.getMilliseconds(), var2_2.getMilliseconds(), TimeUnit.MILLISECONDS);
            var3_4.setScheduredFuture(scheduledFuture);
            this.context.addScheduledFuture((ScheduledFuture)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Duration getDurationOfScanPeriodAttribute(String scanPeriodAttrib, Duration defaultDuration) {
        void var3_3;
        Duration duration = null;
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)scanPeriodAttrib)) {
            try {
                duration = Duration.valueOf((String)scanPeriodAttrib);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                void var1_1;
                this.addWarn("Failed to parse 'scanPeriod' attribute [" + (String)var1_1 + "]", e);
            }
        }
        if (duration == null) {
            void var2_2;
            this.addInfo("No 'scanPeriod' specified. Defaulting to " + defaultDuration.toString());
            duration = var2_2;
        }
        return var3_3;
    }
}

