/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.joran.PropertiesConfigurator;
import ch.qos.logback.classic.joran.ReconfigureOnChangeTaskListener;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.StatusUtil;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

public class ReconfigureOnChangeTask
extends ContextAwareBase
implements Runnable {
    public static final String DETECTED_CHANGE_IN_CONFIGURATION_FILES = "Detected change in configuration files.";
    public static final String RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION = "Re-registering previous fallback configuration once more as a fallback configuration point";
    public static final String FALLING_BACK_TO_SAFE_CONFIGURATION = "Given previous errors, falling back to previously registered safe configuration.";
    long birthdate = System.currentTimeMillis();
    List<ReconfigureOnChangeTaskListener> listeners = null;
    ScheduledFuture<?> scheduledFuture;

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationChangeDetectorRunningEvent((Object)this));
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)this.context);
        if (configurationWatchList == null) {
            this.addWarn("Empty ConfigurationWatchList in context");
            return;
        }
        if (configurationWatchList.emptyWatchLists()) {
            this.addInfo("Both watch lists are empty. Disabling ");
            return;
        }
        File changedFile = configurationWatchList.changeDetectedInFile();
        URL changedURL = configurationWatchList.changeDetectedInURL();
        if (changedFile == null && changedURL == null) {
            return;
        }
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationChangeDetectedEvent((Object)this));
        this.addInfo(DETECTED_CHANGE_IN_CONFIGURATION_FILES);
        if (changedFile != null) {
            void var1_1;
            void var2_2;
            this.changeInFile((File)var2_2, (ConfigurationWatchList)var1_1);
        }
        if (changedURL != null) {
            void var3_3;
            this.changeInURL((URL)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void changeInURL(URL url) {
        String string = url.getPath();
        if (string.endsWith(".properties")) {
            void var1_1;
            this.runPropertiesConfigurator(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void changeInFile(File changedFile, ConfigurationWatchList configurationWatchList) {
        void var1_1;
        if (changedFile.getName().endsWith(".properties")) {
            this.runPropertiesConfigurator(changedFile);
            return;
        }
        ReconfigureOnChangeTask reconfigureOnChangeTask = this;
        reconfigureOnChangeTask.addInfo("Will reset and reconfigure context named [" + reconfigureOnChangeTask.context.getName() + "]");
        this.cancelFutureInvocationsOfThisTaskInstance();
        URL mainConfigurationURL = configurationWatchList.getMainURL();
        LoggerContext lc = (LoggerContext)this.context;
        if (mainConfigurationURL.toString().endsWith("xml")) {
            void var2_2;
            this.performXMLConfiguration((LoggerContext)var2_2, mainConfigurationURL);
            return;
        }
        if (var1_1.toString().endsWith("groovy")) {
            this.addError("Groovy configuration disabled due to Java 9 compilation issues.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void runPropertiesConfigurator(Object changedObject) {
        this.addInfo("Will run PropertyConfigurator on " + String.valueOf(changedObject));
        PropertiesConfigurator propertiesConfigurator = new PropertiesConfigurator();
        propertiesConfigurator.setContext(this.context);
        try {
            if (changedObject instanceof File) {
                File changedFile = (File)changedObject;
                propertiesConfigurator.doConfigure(changedFile);
            } else if (changedObject instanceof URL) {
                void var3_4;
                void var2_2;
                URL changedURL = (URL)changedObject;
                var2_2.doConfigure((URL)var3_4);
            }
            this.context.fireConfigurationEvent(ConfigurationEvent.newPartialConfigurationEndedSuccessfullyEvent((Object)this));
            return;
        }
        catch (JoranException joranException) {
            void var1_1;
            this.addError("Failed to reload " + String.valueOf(var1_1));
            return;
        }
    }

    private void cancelFutureInvocationsOfThisTaskInstance() {
        boolean bl = this.scheduledFuture.cancel(false);
        if (!bl) {
            ReconfigureOnChangeTask reconfigureOnChangeTask = this;
            reconfigureOnChangeTask.addWarn("could not cancel " + reconfigureOnChangeTask.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void performXMLConfiguration(LoggerContext lc, URL mainConfigurationURL) {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext(this.context);
        StatusUtil statusUtil = new StatusUtil(this.context);
        Model failsafeTop = jc.recallSafeConfiguration();
        URL mainURL = ConfigurationWatchListUtil.getMainWatchURL((Context)this.context);
        this.addInfo("Resetting loggerContext [" + lc.getName() + "]");
        lc.reset();
        long threshold = System.currentTimeMillis();
        try {
            void var3_4;
            var3_4.doConfigure(mainConfigurationURL);
            if (statusUtil.hasXMLParsingErrors(threshold)) {
                this.fallbackConfiguration(lc, failsafeTop, mainURL);
            }
            return;
        }
        catch (JoranException e) {
            void var1_1;
            void var2_3;
            this.addWarn("Exception occurred during reconfiguration", (Throwable)var2_3);
            this.fallbackConfiguration((LoggerContext)var1_1, failsafeTop, mainURL);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fallbackConfiguration(LoggerContext lc, Model failsafeTop, URL mainURL) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.context);
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)this.context);
        ConfigurationWatchList newCWL = configurationWatchList.buildClone();
        if (failsafeTop == null) {
            this.addWarn("No previous configuration to fall back on.");
            return;
        }
        this.addWarn(FALLING_BACK_TO_SAFE_CONFIGURATION);
        this.addInfo("Safe model " + String.valueOf(failsafeTop));
        try {
            void var2_3;
            void var3_4;
            lc.reset();
            ConfigurationWatchListUtil.registerConfigurationWatchList((Context)this.context, (ConfigurationWatchList)newCWL);
            ModelUtil.resetForReuse((Model)failsafeTop);
            joranConfigurator.processModel(failsafeTop);
            this.addInfo(RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION);
            var3_4.registerSafeConfiguration((Model)var2_3);
            this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationEndedSuccessfullyEvent((Object)this));
            return;
        }
        catch (Exception e) {
            void var1_2;
            this.addError("Unexpected exception thrown by a configuration considered safe.", (Throwable)var1_2);
            return;
        }
    }

    public String toString() {
        return "ReconfigureOnChangeTask(born:" + this.birthdate + ")";
    }

    /*
     * WARNING - void declaration
     */
    public void setScheduredFuture(ScheduledFuture<?> aScheduledFuture) {
        void var1_1;
        this.scheduledFuture = var1_1;
    }
}

