/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;

public final class DirectJson {
    private static final int INITIAL_BUFFER_SIZE = 1024;
    private static final byte QUOTE = 34;
    private static final byte ENTRY_SEP = 58;
    private static final byte KV_SEP = 44;
    private static final byte DOT = 46;
    private static final byte OPEN_OBJ = 123;
    private static final byte CLOSE_OBJ = 125;
    private static final byte OPEN_ARR = 91;
    private static final byte CLOSE_ARR = 93;
    private static final byte[] NEWLINE = new byte[]{92, 110};
    private static final byte[] ESCAPE = new byte[]{92, 92};
    private static final byte[] LINEBREAK = new byte[]{92, 114};
    private static final byte[] TAB = new byte[]{92, 116};
    private static final byte[] TRUE = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE = new byte[]{102, 97, 108, 115, 101};
    private static final byte[] NULL = new byte[]{110, 117, 108, 108};
    private ByteBuffer buffer = ByteBuffer.allocateDirect(1024);

    public final void openObject() {
        this.buffer.put((byte)123);
    }

    public final void openArray() {
        this.buffer.put((byte)91);
    }

    /*
     * WARNING - void declaration
     */
    public final void openObject(String str) {
        void var1_1;
        this.writeString((String)var1_1);
        this.writeEntrySep();
        this.buffer.put((byte)123);
    }

    /*
     * WARNING - void declaration
     */
    public final void openArray(String str) {
        void var1_1;
        this.writeString((String)var1_1);
        this.writeEntrySep();
        this.buffer.put((byte)91);
    }

    /*
     * WARNING - void declaration
     */
    public final void closeObject() {
        int target = this.buffer.position() - 1;
        if (44 == this.buffer.get(target)) {
            void var1_1;
            this.buffer.put((int)var1_1, (byte)125);
            return;
        }
        this.buffer.put((byte)125);
    }

    /*
     * WARNING - void declaration
     */
    public final void closeArray() {
        int target = this.buffer.position() - 1;
        if (44 == this.buffer.get(target)) {
            void var1_1;
            this.buffer.put((int)var1_1, (byte)93);
            return;
        }
        this.buffer.put((byte)93);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRaw(String str) {
        block6: for (int i = 0; i < str.length(); ++i) {
            int chr = str.codePointAt(i);
            switch (chr) {
                case 92: {
                    this.buffer.put(ESCAPE);
                    continue block6;
                }
                case 10: {
                    this.buffer.put(NEWLINE);
                    continue block6;
                }
                case 13: {
                    this.buffer.put(LINEBREAK);
                    continue block6;
                }
                case 9: {
                    this.buffer.put(TAB);
                    continue block6;
                }
                default: {
                    void var3_3;
                    if (chr >= 128 && chr <= 0x10FFFF) {
                        this.buffer.put(String.valueOf(str.charAt(i)).getBytes());
                        continue block6;
                    }
                    if (chr <= 31) continue block6;
                    this.buffer.put((byte)var3_3);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRaw(char chr) {
        void var1_1;
        this.buffer.put((byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRaw(byte[] chr) {
        void var1_1;
        this.buffer.put((byte[])var1_1);
    }

    public final void writeQuote() {
        this.buffer.put((byte)34);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeString(String str) {
        void var1_1;
        this.checkSpace(str.length() + 3);
        this.buffer.put((byte)34);
        this.writeRaw((String)var1_1);
        this.buffer.put((byte)34);
        this.buffer.put((byte)44);
    }

    public final void writeSep() {
        this.buffer.put((byte)44);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeNumberRaw(long data) {
        void var3_3;
        int pos = this.buffer.position();
        int sz = (int)Math.log10(data) + 1;
        long dataPointer = data;
        for (int i = sz - 1; i >= 0; --i) {
            void var2_6;
            byte chr = (byte)(dataPointer % 10L);
            dataPointer /= 10L;
            chr = (byte)(chr + 48);
            this.buffer.put(pos + i, (byte)var2_6);
        }
        this.buffer.position((int)(var3_3 + sz));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeNumber(long data) {
        void var3_3;
        int pos = this.buffer.position();
        int sz = data == 0L ? 1 : (int)Math.log10(data) + 1;
        long dataPointer = data;
        for (int i = sz - 1; i >= 0; --i) {
            void var2_6;
            byte chr = (byte)(dataPointer % 10L);
            dataPointer /= 10L;
            chr = (byte)(chr + 48);
            this.buffer.put(pos + i, (byte)var2_6);
        }
        this.buffer.position((int)(var3_3 + sz));
        this.buffer.put((byte)44);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeNumber(double data) {
        void var3_3;
        int pos = this.buffer.position();
        long whole = (long)data;
        int sz = (int)Math.log10(whole) + 1;
        for (int i = sz - 1; i >= 0; --i) {
            byte chr = (byte)(whole % 10L);
            whole /= 10L;
            chr = (byte)(chr + 48);
            this.buffer.put(pos + i, chr);
        }
        this.buffer.position(pos + sz);
        this.buffer.put((byte)46);
        pos = this.buffer.position();
        BigDecimal fractional = BigDecimal.valueOf(data).remainder(BigDecimal.ONE);
        int decs = 0;
        while (!fractional.equals(BigDecimal.ZERO)) {
            void var1_2;
            fractional = fractional.movePointRight(1);
            byte chr = (byte)(fractional.intValue() + 48);
            fractional = fractional.remainder(BigDecimal.ONE);
            ++decs;
            this.buffer.put((byte)var1_2);
        }
        this.buffer.position((int)(var3_3 + decs));
        this.buffer.put((byte)44);
    }

    public final void writeEntrySep() {
        this.buffer.put(this.buffer.position() - 1, (byte)58);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeStringValue(String key, String value) {
        void var2_2;
        void var1_1;
        this.writeString((String)var1_1);
        this.writeEntrySep();
        this.writeString((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeNumberValue(String key, long value) {
        void var2_2;
        void var1_1;
        this.writeString((String)var1_1);
        this.writeEntrySep();
        this.writeNumber((long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeNumberValue(String key, double value) {
        void var2_2;
        void var1_1;
        this.writeString((String)var1_1);
        this.writeEntrySep();
        this.writeNumber((double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeBoolean(boolean value) {
        void var1_1;
        this.buffer.put(var1_1 != false ? TRUE : FALSE);
        this.buffer.put((byte)44);
    }

    public final void writeNull() {
        this.buffer.put(NULL);
        this.buffer.put((byte)44);
    }

    /*
     * WARNING - void declaration
     */
    public final void checkSpace(int size) {
        if (this.buffer.position() + size >= this.buffer.capacity()) {
            void var1_2;
            size = (this.buffer.capacity() + size) * 2;
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(size);
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] flush() {
        void var1_1;
        byte[] result = new byte[this.buffer.position()];
        this.buffer.flip();
        this.buffer.get(result);
        this.buffer.clear();
        return var1_1;
    }
}

