/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.testUtil;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class EnvUtilForTests {
    static String GITHUB_HOME = "/home/runner";
    static String LOCAL_REPOSITORY_PREFIX = "/home/runner";

    /*
     * WARNING - void declaration
     */
    public static boolean isGithubAction() {
        void var1_1;
        void var0;
        String userHome = System.getProperty("user.home");
        String localRepository = System.getProperty("localRepository");
        if (GITHUB_HOME.equals(var0)) {
            return true;
        }
        return localRepository != null && var1_1.startsWith(LOCAL_REPOSITORY_PREFIX);
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public static boolean isMac() {
        return System.getProperty("os.name").indexOf("Mac") != -1;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").indexOf("Linux") != -1;
    }

    public static boolean isRunningOnSlowJenkins() {
        return System.getProperty("slowJenkins") != null;
    }

    public static String getLocalHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static boolean isLocalHostNameInList(String[] hostList) {
        String[] stringArray;
        String localHostName = EnvUtilForTests.getLocalHostName();
        if (localHostName == null) {
            return false;
        }
        for (String string : stringArray) {
            if (!string.equalsIgnoreCase(localHostName)) continue;
            return true;
        }
        return false;
    }

    public static String getPathToBash() {
        if (EnvUtilForTests.isLinux()) {
            return "bash";
        }
        if (EnvUtilForTests.isLocalHostNameInList(new String[]{"hetz", "het"})) {
            return "c:/cygwin/bin/bash";
        }
        return null;
    }
}

