/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.LengthCounter;
import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.Compressor;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.time.Instant;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeBasedRollingPolicy<E>
extends RollingPolicyBase
implements TriggeringPolicy<E> {
    static final String FNP_NOT_SET = "The FileNamePattern option must be set before using TimeBasedRollingPolicy. ";
    FileNamePattern fileNamePatternWithoutCompSuffix;
    private Compressor compressor;
    private RenameUtil renameUtil = new RenameUtil();
    Future<?> compressionFuture;
    Future<?> cleanUpFuture;
    private int maxHistory = 0;
    protected FileSize totalSizeCap = new FileSize(0L);
    private ArchiveRemover archiveRemover;
    TimeBasedFileNamingAndTriggeringPolicy<E> timeBasedFileNamingAndTriggeringPolicy;
    boolean cleanHistoryOnStart = false;

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        this.renameUtil.setContext(this.context);
        if (this.fileNamePatternStr == null) {
            this.addWarn(FNP_NOT_SET);
            this.addWarn("See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
            throw new IllegalStateException("The FileNamePattern option must be set before using TimeBasedRollingPolicy. See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
        }
        this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr, this.context);
        this.determineCompressionMode();
        this.compressor = new Compressor(this.compressionMode);
        this.compressor.setContext(this.context);
        this.fileNamePatternWithoutCompSuffix = new FileNamePattern(Compressor.computeFileNameStrWithoutCompSuffix(this.fileNamePatternStr, this.compressionMode), this.context);
        TimeBasedRollingPolicy timeBasedRollingPolicy = this;
        timeBasedRollingPolicy.addInfo("Will use the pattern " + String.valueOf(timeBasedRollingPolicy.fileNamePatternWithoutCompSuffix) + " for the active file");
        if (this.compressionMode == CompressionMode.ZIP) {
            TimeBasedRollingPolicy timeBasedRollingPolicy2 = this;
            String zipEntryFileNamePatternStr = timeBasedRollingPolicy2.transformFileNamePattern2ZipEntry(timeBasedRollingPolicy2.fileNamePatternStr);
            this.zipEntryFileNamePattern = new FileNamePattern(zipEntryFileNamePatternStr, this.context);
        }
        if (this.timeBasedFileNamingAndTriggeringPolicy == null) {
            this.timeBasedFileNamingAndTriggeringPolicy = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
        }
        this.timeBasedFileNamingAndTriggeringPolicy.setContext(this.context);
        this.timeBasedFileNamingAndTriggeringPolicy.setTimeBasedRollingPolicy(this);
        this.timeBasedFileNamingAndTriggeringPolicy.start();
        if (!this.timeBasedFileNamingAndTriggeringPolicy.isStarted()) {
            this.addWarn("Subcomponent did not start. TimeBasedRollingPolicy will not start.");
            return;
        }
        if (this.maxHistory != 0) {
            this.archiveRemover = this.timeBasedFileNamingAndTriggeringPolicy.getArchiveRemover();
            this.archiveRemover.setMaxHistory(this.maxHistory);
            this.archiveRemover.setTotalSizeCap(this.totalSizeCap.getSize());
            if (this.cleanHistoryOnStart) {
                void var1_1;
                this.addInfo("Cleaning on start up");
                Instant now = Instant.ofEpochMilli(this.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime());
                this.cleanUpFuture = this.archiveRemover.cleanAsynchronously((Instant)var1_1);
            }
        } else if (!this.isUnboundedTotalSizeCap()) {
            TimeBasedRollingPolicy timeBasedRollingPolicy3 = this;
            timeBasedRollingPolicy3.addWarn("'maxHistory' is not set, ignoring 'totalSizeCap' option with value [" + String.valueOf(timeBasedRollingPolicy3.totalSizeCap) + "]");
        }
        super.start();
    }

    protected boolean isUnboundedTotalSizeCap() {
        return this.totalSizeCap.getSize() == 0L;
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        TimeBasedRollingPolicy timeBasedRollingPolicy = this;
        timeBasedRollingPolicy.waitForAsynchronousJobToStop(timeBasedRollingPolicy.compressionFuture, "compression");
        TimeBasedRollingPolicy timeBasedRollingPolicy2 = this;
        timeBasedRollingPolicy2.waitForAsynchronousJobToStop(timeBasedRollingPolicy2.cleanUpFuture, "clean-up");
        super.stop();
    }

    /*
     * WARNING - void declaration
     */
    private void waitForAsynchronousJobToStop(Future<?> aFuture, String jobDescription) {
        if (aFuture != null) {
            try {
                aFuture.get(30L, TimeUnit.SECONDS);
                return;
            }
            catch (TimeoutException e) {
                this.addError("Timeout while waiting for " + jobDescription + " job to finish", e);
                return;
            }
            catch (Exception e) {
                void var1_3;
                void var2_4;
                this.addError("Unexpected exception while waiting for " + (String)var2_4 + " job to finish", (Throwable)var1_3);
            }
        }
    }

    private String transformFileNamePattern2ZipEntry(String fileNamePatternStr) {
        String string = FileFilterUtil.slashify(fileNamePatternStr);
        return FileFilterUtil.afterLastSlash(string);
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeBasedFileNamingAndTriggeringPolicy(TimeBasedFileNamingAndTriggeringPolicy<E> timeBasedTriggering) {
        void var1_1;
        this.timeBasedFileNamingAndTriggeringPolicy = var1_1;
    }

    public TimeBasedFileNamingAndTriggeringPolicy<E> getTimeBasedFileNamingAndTriggeringPolicy() {
        return this.timeBasedFileNamingAndTriggeringPolicy;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void rollover() throws RolloverFailure {
        String elapsedPeriodsFileName = this.timeBasedFileNamingAndTriggeringPolicy.getElapsedPeriodsFileName();
        String elapsedPeriodStem = FileFilterUtil.afterLastSlash(elapsedPeriodsFileName);
        if (this.compressionMode == CompressionMode.NONE) {
            if (this.getParentsRawFileProperty() != null) {
                this.renameUtil.rename(this.getParentsRawFileProperty(), elapsedPeriodsFileName);
            }
        } else if (this.getParentsRawFileProperty() == null) {
            String string = elapsedPeriodsFileName;
            this.compressionFuture = this.compressor.asyncCompress(string, string, elapsedPeriodStem);
        } else {
            void var2_2;
            this.compressionFuture = this.renameRawAndAsyncCompress(elapsedPeriodsFileName, (String)var2_2);
        }
        if (this.archiveRemover != null) {
            void var1_1;
            Instant now = Instant.ofEpochMilli(this.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime());
            this.cleanUpFuture = this.archiveRemover.cleanAsynchronously((Instant)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    Future<?> renameRawAndAsyncCompress(String nameOfCompressedFile, String innerEntryName) throws RolloverFailure {
        void var2_2;
        void var1_1;
        void var3_3;
        String parentsRawFile = this.getParentsRawFileProperty();
        String tmpTarget = nameOfCompressedFile + System.nanoTime() + ".tmp";
        this.renameUtil.rename((String)var3_3, tmpTarget);
        return this.compressor.asyncCompress(tmpTarget, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getActiveFileName() {
        String parentsRawFileProperty = this.getParentsRawFileProperty();
        if (parentsRawFileProperty != null) {
            void var1_1;
            return var1_1;
        }
        return this.timeBasedFileNamingAndTriggeringPolicy.getCurrentPeriodsFileNameWithoutCompressionSuffix();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isTriggeringEvent(File activeFile, E event) {
        void var2_2;
        void var1_1;
        return this.timeBasedFileNamingAndTriggeringPolicy.isTriggeringEvent((File)var1_1, var2_2);
    }

    @Override
    public LengthCounter getLengthCounter() {
        return this.timeBasedFileNamingAndTriggeringPolicy.getLengthCounter();
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxHistory(int maxHistory) {
        void var1_1;
        this.maxHistory = var1_1;
    }

    public boolean isCleanHistoryOnStart() {
        return this.cleanHistoryOnStart;
    }

    /*
     * WARNING - void declaration
     */
    public void setCleanHistoryOnStart(boolean cleanHistoryOnStart) {
        void var1_1;
        this.cleanHistoryOnStart = var1_1;
    }

    public String toString() {
        return "c.q.l.core.rolling.TimeBasedRollingPolicy@" + this.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public void setTotalSizeCap(FileSize totalSizeCap) {
        void var1_1;
        this.addInfo("setting totalSizeCap to " + totalSizeCap.toString());
        this.totalSizeCap = var1_1;
    }
}

