/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.parser.TokenStream;
import ch.qos.logback.core.pattern.util.AsIsEscapeUtil;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.spi.ScanException;
import java.util.ArrayList;
import java.util.List;

public class OptionTokenizer {
    private static final int EXPECTING_STATE = 0;
    private static final int RAW_COLLECTING_STATE = 1;
    private static final int QUOTED_COLLECTING_STATE = 2;
    final IEscapeUtil escapeUtil;
    final TokenStream tokenStream;
    final String pattern;
    final int patternLength;
    char quoteChar;
    int state = 0;

    /*
     * WARNING - void declaration
     */
    OptionTokenizer(TokenStream tokenStream) {
        this((TokenStream)var1_1, new AsIsEscapeUtil());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    OptionTokenizer(TokenStream tokenStream, IEscapeUtil escapeUtil) {
        void var2_2;
        void var1_1;
        this.tokenStream = tokenStream;
        this.pattern = tokenStream.pattern;
        this.patternLength = var1_1.patternLength;
        this.escapeUtil = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    void tokenize(char firstChar, List<Token> tokenList) throws ScanException {
        void var1_1;
        StringBuffer buf = new StringBuffer();
        ArrayList<String> optionList = new ArrayList<String>();
        while (this.tokenStream.pointer < this.patternLength) {
            char c;
            block0 : switch (this.state) {
                case 0: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': 
                        case ',': {
                            break block0;
                        }
                        case '\"': 
                        case '\'': {
                            this.state = 2;
                            this.quoteChar = c;
                            break block0;
                        }
                        case '}': {
                            this.emitOptionToken(tokenList, optionList);
                            return;
                        }
                    }
                    buf.append(c);
                    this.state = 1;
                    break;
                }
                case 1: {
                    switch (c) {
                        case ',': {
                            optionList.add(buf.toString().trim());
                            buf.setLength(0);
                            this.state = 0;
                            break block0;
                        }
                        case '}': {
                            optionList.add(buf.toString().trim());
                            this.emitOptionToken(tokenList, optionList);
                            return;
                        }
                    }
                    buf.append(c);
                    break;
                }
                case 2: {
                    if (c == this.quoteChar) {
                        optionList.add(buf.toString());
                        buf.setLength(0);
                        this.state = 0;
                        break;
                    }
                    if (c == '\\') {
                        OptionTokenizer optionTokenizer = this;
                        optionTokenizer.escape(String.valueOf(optionTokenizer.quoteChar), buf);
                        break;
                    }
                    buf.append(c);
                }
            }
            c = this.pattern.charAt(this.tokenStream.pointer);
            ++this.tokenStream.pointer;
        }
        if (var1_1 == 125) {
            if (this.state == 0) {
                this.emitOptionToken(tokenList, optionList);
                return;
            }
            if (this.state == 1) {
                void var2_2;
                void var3_3;
                optionList.add(var3_3.toString().trim());
                this.emitOptionToken((List<Token>)var2_2, optionList);
                return;
            }
            throw new ScanException("Unexpected end of pattern string in OptionTokenizer");
        }
        throw new ScanException("Unexpected end of pattern string in OptionTokenizer");
    }

    /*
     * WARNING - void declaration
     */
    void emitOptionToken(List<Token> tokenList, List<String> optionList) {
        void var2_2;
        tokenList.add(new Token(1006, (List<String>)var2_2));
        this.tokenStream.state = TokenStream.TokenizerState.LITERAL_STATE;
    }

    /*
     * WARNING - void declaration
     */
    void escape(String escapeChars, StringBuffer buf) {
        if (this.tokenStream.pointer < this.patternLength) {
            void var3_3;
            void var2_2;
            void var1_1;
            char next = this.pattern.charAt(this.tokenStream.pointer++);
            this.escapeUtil.escape((String)var1_1, (StringBuffer)var2_2, (char)var3_3, this.tokenStream.pointer);
        }
    }
}

