/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.SimpleKeywordNode;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

class Compiler<E>
extends ContextAwareBase {
    Converter<E> head;
    Converter<E> tail;
    final Node top;
    final Map<String, String> converterMap;

    /*
     * WARNING - void declaration
     */
    Compiler(Node top, Map<String, String> converterMap) {
        void var2_2;
        void var1_1;
        this.top = var1_1;
        this.converterMap = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    Converter<E> compile() {
        Compiler compiler = this;
        compiler.tail = null;
        compiler.head = null;
        Node n = this.top;
        while (n != null) {
            switch (n.type) {
                case 0: {
                    this.addToList(new LiteralConverter((String)n.getValue()));
                    break;
                }
                case 2: {
                    CompositeNode cn = (CompositeNode)n;
                    CompositeConverter<E> compositeConverter = this.createCompositeConverter(cn);
                    if (compositeConverter == null) {
                        this.addError("Failed to create converter for [%" + String.valueOf(cn.getValue()) + "] keyword");
                        this.addToList(new LiteralConverter("%PARSER_ERROR[" + String.valueOf(cn.getValue()) + "]"));
                        break;
                    }
                    compositeConverter.setFormattingInfo(cn.getFormatInfo());
                    compositeConverter.setOptionList(cn.getOptions());
                    Compiler<E> childCompiler = new Compiler<E>(cn.getChildNode(), this.converterMap);
                    childCompiler.setContext(this.context);
                    Converter<E> childConverter = childCompiler.compile();
                    compositeConverter.setChildConverter(childConverter);
                    this.addToList(compositeConverter);
                    break;
                }
                case 1: {
                    void var3_3;
                    void var2_2;
                    SimpleKeywordNode kn = (SimpleKeywordNode)n;
                    DynamicConverter<E> dynaConverter = this.createConverter(kn);
                    if (dynaConverter != null) {
                        dynaConverter.setFormattingInfo(kn.getFormatInfo());
                        dynaConverter.setOptionList(kn.getOptions());
                        this.addToList(dynaConverter);
                        break;
                    }
                    LiteralConverter errConveter = new LiteralConverter("%PARSER_ERROR[" + String.valueOf(kn.getValue()) + "]");
                    this.addStatus(new ErrorStatus("[" + String.valueOf(var2_2.getValue()) + "] is not a valid conversion word", this));
                    this.addToList((Converter<E>)var3_3);
                }
            }
            n = n.next;
        }
        return this.head;
    }

    /*
     * WARNING - void declaration
     */
    private void addToList(Converter<E> c) {
        void var1_1;
        if (this.head == null) {
            this.tail = c;
            this.head = this.tail;
            return;
        }
        this.tail.setNext(c);
        this.tail = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    DynamicConverter<E> createConverter(SimpleKeywordNode kn) {
        void var1_1;
        String keyword = (String)kn.getValue();
        String converterClassStr = this.converterMap.get(keyword);
        if (converterClassStr != null) {
            try {
                return (DynamicConverter)OptionHelper.instantiateByClassName(converterClassStr, DynamicConverter.class, this.context);
            }
            catch (Exception e) {
                void var3_3;
                void var2_2;
                this.addError("Failed to instantiate converter class [" + (String)var2_2 + "] for keyword [" + keyword + "]", (Throwable)var3_3);
                return null;
            }
        }
        this.addError("There is no conversion class registered for conversion word [" + (String)var1_1 + "]");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    CompositeConverter<E> createCompositeConverter(CompositeNode cn) {
        void var1_1;
        String keyword = (String)cn.getValue();
        String converterClassStr = this.converterMap.get(keyword);
        if (converterClassStr != null) {
            try {
                return (CompositeConverter)OptionHelper.instantiateByClassName(converterClassStr, CompositeConverter.class, this.context);
            }
            catch (Exception e) {
                void var3_3;
                void var2_2;
                this.addError("Failed to instantiate converter class [" + (String)var2_2 + "] as a composite converter for keyword [" + keyword + "]", (Throwable)var3_3);
                return null;
            }
        }
        this.addError("There is no conversion class registered for composite conversion word [" + (String)var1_1 + "]");
        return null;
    }
}

