/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.net.server.Client;
import ch.qos.logback.core.net.server.ClientVisitor;
import ch.qos.logback.core.net.server.ServerListener;
import ch.qos.logback.core.net.server.ServerRunner;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class ConcurrentServerRunner<T extends Client>
extends ContextAwareBase
implements ServerRunner<T>,
Runnable {
    private final Lock clientsLock = new ReentrantLock();
    private final Collection<T> clients = new ArrayList<T>();
    private final ServerListener<T> listener;
    private final Executor executor;
    private boolean running;

    /*
     * WARNING - void declaration
     */
    public ConcurrentServerRunner(ServerListener<T> listener, Executor executor) {
        void var2_2;
        void var1_1;
        this.listener = var1_1;
        this.executor = var2_2;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - void declaration
     */
    protected void setRunning(boolean running) {
        void var1_1;
        this.running = var1_1;
    }

    @Override
    public void stop() throws IOException {
        this.listener.close();
        this.accept(new ClientVisitor<T>(this){
            final /* synthetic */ ConcurrentServerRunner this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void visit(T client) {
                client.close();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void accept(ClientVisitor<T> visitor) {
        Object object = this.copyClients();
        object = object.iterator();
        while (object.hasNext()) {
            Client client = (Client)object.next();
            try {
                visitor.visit(client);
            }
            catch (RuntimeException ex) {
                void var3_3;
                this.addError(String.valueOf(var3_3) + ": " + String.valueOf(ex));
            }
        }
    }

    private Collection<T> copyClients() {
        this.clientsLock.lock();
        try {
            ArrayList<T> arrayList = new ArrayList<T>(this.clients);
            return arrayList;
        }
        finally {
            this.clientsLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        this.setRunning(true);
        try {
            ConcurrentServerRunner concurrentServerRunner = this;
            concurrentServerRunner.addInfo("listening on " + String.valueOf(concurrentServerRunner.listener));
            while (!Thread.currentThread().isInterrupted()) {
                T client = this.listener.acceptClient();
                if (!this.configureClient(client)) {
                    this.addError(String.valueOf(client) + ": connection dropped");
                    client.close();
                    continue;
                }
                try {
                    this.executor.execute(new ClientWrapper(this, client));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    this.addError(String.valueOf(client) + ": connection dropped");
                    client.close();
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception ex) {
            void var1_2;
            this.addError("listener: " + String.valueOf(var1_2));
        }
        this.setRunning(false);
        this.addInfo("shutting down");
        this.listener.close();
    }

    protected abstract boolean configureClient(T var1);

    /*
     * WARNING - void declaration
     */
    private void addClient(T client) {
        this.clientsLock.lock();
        try {
            void var1_1;
            this.clients.add(var1_1);
            return;
        }
        finally {
            this.clientsLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeClient(T client) {
        this.clientsLock.lock();
        try {
            void var1_1;
            this.clients.remove(var1_1);
            return;
        }
        finally {
            this.clientsLock.unlock();
        }
    }

    private static class ClientWrapper
    implements Client {
        private final T delegate;
        final /* synthetic */ ConcurrentServerRunner this$0;

        /*
         * WARNING - void declaration
         */
        public ClientWrapper(T client) {
            void var2_2;
            this.this$0 = var1_1;
            this.delegate = var2_2;
        }

        @Override
        public void run() {
            this.this$0.addClient(this.delegate);
            try {
                this.delegate.run();
                return;
            }
            finally {
                this.this$0.removeClient(this.delegate);
            }
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }
}

