/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor.conditional;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.conditional.Condition;
import ch.qos.logback.core.joran.conditional.PropertyEvalScriptBuilder;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.conditional.IfModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.OptionHelper;

public class IfModelHandler
extends ModelHandlerBase {
    public static final String MISSING_JANINO_MSG = "Could not find Janino library on the class path. Skipping conditional processing.";
    public static final String MISSING_JANINO_SEE = "See also http://logback.qos.ch/codes.html#ifJanino";
    IfModel ifModel = null;

    /*
     * WARNING - void declaration
     */
    public IfModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        Context context2;
        return new IfModelHandler(context2);
    }

    protected Class<IfModel> getSupportedModelClass() {
        return IfModel.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        this.ifModel = (IfModel)model;
        if (!EnvUtil.isJaninoAvailable()) {
            this.addError(MISSING_JANINO_MSG);
            this.addError(MISSING_JANINO_SEE);
            return;
        }
        mic.pushModel(this.ifModel);
        int lineNum = model.getLineNumber();
        String conditionStr = this.ifModel.getCondition();
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(conditionStr)) {
            try {
                conditionStr = OptionHelper.substVars(conditionStr, mic, this.context);
            }
            catch (ScanException e) {
                this.addError("Failed to parse input [" + conditionStr + "] on line " + lineNum, e);
                this.ifModel.setBranchState(IfModel.BranchState.IN_ERROR);
                return;
            }
            try {
                PropertyEvalScriptBuilder pesb = new PropertyEvalScriptBuilder((PropertyContainer)e);
                pesb.setContext(this.context);
                Condition condition = pesb.build(conditionStr);
            }
            catch (Exception | NoClassDefFoundError e) {
                this.ifModel.setBranchState(IfModel.BranchState.IN_ERROR);
                this.addError("Failed to parse condition [" + conditionStr + "] on line " + lineNum, e);
                return;
            }
            if (e != null) {
                void var1_4;
                void var2_6;
                void var3_7;
                boolean boolResult = e.evaluate();
                this.addInfo("Condition [" + (String)var3_7 + "] evaluated to " + boolResult + " on line " + (int)var2_6);
                this.ifModel.setBranchState((boolean)var1_4);
                return;
            }
            this.addError("The condition variable is null. This should not occur.");
            this.ifModel.setBranchState(IfModel.BranchState.IN_ERROR);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postHandle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        void var1_1;
        if (mic.isModelStackEmpty()) {
            this.addError("Unexpected unexpected empty model stack.");
            return;
        }
        Model o = mic.peekModel();
        if (o != this.ifModel) {
            void var2_2;
            this.addWarn("The object [" + String.valueOf(var2_2) + "] on the top the of the stack is not the expected [" + String.valueOf(this.ifModel));
            return;
        }
        var1_1.popModel();
    }

    static enum Branch {
        IF_BRANCH,
        ELSE_BRANCH;

    }
}

