/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.hook.DefaultShutdownHook;
import ch.qos.logback.core.hook.ShutdownHook;
import ch.qos.logback.core.hook.ShutdownHookBase;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ShutdownHookModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.DynamicClassLoadingException;
import ch.qos.logback.core.util.IncompatibleClassException;
import ch.qos.logback.core.util.OptionHelper;

public class ShutdownHookModelHandler
extends ModelHandlerBase {
    static final String OLD_SHUTDOWN_HOOK_CLASSNAME = "ch.qos.logback.core.hook.DelayingShutdownHook";
    static final String DEFAULT_SHUTDOWN_HOOK_CLASSNAME = DefaultShutdownHook.class.getName();
    public static final String RENAME_WARNING = "ch.qos.logback.core.hook.DelayingShutdownHook was renamed as " + DEFAULT_SHUTDOWN_HOOK_CLASSNAME;
    boolean inError = false;
    ShutdownHook hook = null;

    /*
     * WARNING - void declaration
     */
    public ShutdownHookModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext mic) {
        Context context2;
        return new ShutdownHookModelHandler(context2);
    }

    protected Class<ShutdownHookModel> getSupportedModelClass() {
        return ShutdownHookModel.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(ModelInterpretationContext mic, Model model) {
        void var1_1;
        String className = ((ComponentModel)(model = (ShutdownHookModel)model)).getClassName();
        if (OptionHelper.isNullOrEmptyOrAllSpaces(className)) {
            className = DEFAULT_SHUTDOWN_HOOK_CLASSNAME;
            this.addInfo("Assuming className [" + className + "]");
        } else if ((className = mic.getImport(className)).equals(OLD_SHUTDOWN_HOOK_CLASSNAME)) {
            className = DEFAULT_SHUTDOWN_HOOK_CLASSNAME;
            this.addWarn(RENAME_WARNING);
            this.addWarn("Please use the new class name");
        }
        this.addInfo("About to instantiate shutdown hook of type [" + className + "]");
        try {
            this.hook = (ShutdownHookBase)OptionHelper.instantiateByClassName(className, ShutdownHookBase.class, this.context);
            this.hook.setContext(this.context);
        }
        catch (DynamicClassLoadingException | IncompatibleClassException e) {
            void var1_2;
            void var2_3;
            this.addError("Could not create a shutdown hook of type [" + (String)var2_3 + "].", (Throwable)var1_2);
            this.inError = true;
            return;
        }
        var1_1.pushObject(this.hook);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postHandle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        void var1_1;
        if (this.inError) {
            return;
        }
        Object object = mic.peekObject();
        if (object != this.hook) {
            this.addWarn("The object on the top the of the stack is not the hook object pushed earlier.");
            return;
        }
        object = new ContextUtil(this.context);
        ((ContextUtil)object).addOrReplaceShutdownHook(this.hook);
        var1_1.popObject();
    }
}

