/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.StringToObjectConverter;
import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.joran.util.beans.BeanUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AggregationAssessor
extends ContextAwareBase {
    protected final Class<?> objClass;
    protected final BeanDescription beanDescription;

    /*
     * WARNING - void declaration
     */
    public AggregationAssessor(BeanDescriptionCache beanDescriptionCache, Class objClass) {
        void var2_2;
        void var1_1;
        this.objClass = objClass;
        this.beanDescription = var1_1.getBeanDescription((Class<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public AggregationType computeAggregationType(String name) {
        void var1_1;
        Method setter;
        String cName = StringUtil.capitalizeFirstLetter(name);
        Method addMethod = this.findAdderMethod(cName);
        if (addMethod != null) {
            AggregationType type = this.computeRawAggregationType(addMethod);
            switch (type) {
                case NOT_FOUND: {
                    return AggregationType.NOT_FOUND;
                }
                case AS_BASIC_PROPERTY: {
                    return AggregationType.AS_BASIC_PROPERTY_COLLECTION;
                }
                case AS_COMPLEX_PROPERTY: {
                    return AggregationType.AS_COMPLEX_PROPERTY_COLLECTION;
                }
                case AS_BASIC_PROPERTY_COLLECTION: 
                case AS_COMPLEX_PROPERTY_COLLECTION: {
                    this.addError("Unexpected AggregationType " + String.valueOf((Object)type));
                }
            }
        }
        if ((setter = this.findSetterMethod((String)var1_1)) != null) {
            void var2_2;
            return this.computeRawAggregationType((Method)var2_2);
        }
        return AggregationType.NOT_FOUND;
    }

    /*
     * WARNING - void declaration
     */
    public Method findAdderMethod(String name) {
        void var1_1;
        String propertyName = BeanUtil.toLowerCamelCase(name);
        return this.beanDescription.getAdder((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Method findSetterMethod(String name) {
        void var1_1;
        String propertyName = BeanUtil.toLowerCamelCase(name);
        return this.beanDescription.getSetter((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private AggregationType computeRawAggregationType(Method method) {
        void var1_1;
        Class<?> parameterClass = this.getParameterClassForMethod(method);
        if (parameterClass == null) {
            return AggregationType.NOT_FOUND;
        }
        if (StringToObjectConverter.canBeBuiltFromSimpleString(var1_1)) {
            return AggregationType.AS_BASIC_PROPERTY;
        }
        return AggregationType.AS_COMPLEX_PROPERTY;
    }

    /*
     * WARNING - void declaration
     */
    private Class<?> getParameterClassForMethod(Method method) {
        void var1_1;
        if (method == null) {
            return null;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            return null;
        }
        return var1_1[0];
    }

    /*
     * WARNING - void declaration
     */
    public Class<?> getClassNameViaImplicitRules(String name, AggregationType aggregationType, DefaultNestedComponentRegistry registry) {
        void var2_2;
        void var1_1;
        Class<?> registryResult = registry.findDefaultComponentType(this.objClass, name);
        if (registryResult != null) {
            return registryResult;
        }
        Method relevantMethod = this.getRelevantMethod(name, aggregationType);
        if (relevantMethod == null) {
            return null;
        }
        Class<?> byAnnotation = this.getDefaultClassNameByAnnonation(name, relevantMethod);
        if (byAnnotation != null) {
            void var3_3;
            return var3_3;
        }
        return this.getByConcreteType((String)var1_1, (Method)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    <T extends Annotation> T getAnnotation(String name, Class<T> annonationClass, Method relevantMethod) {
        if (relevantMethod != null) {
            void var2_2;
            void var3_3;
            return var3_3.getAnnotation(var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    Class<?> getDefaultClassNameByAnnonation(String name, Method relevantMethod) {
        void var2_2;
        DefaultClass defaultClassAnnon = this.getAnnotation(name, DefaultClass.class, (Method)var2_2);
        if (defaultClassAnnon != null) {
            void var1_1;
            return var1_1.value();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    Method getRelevantMethod(String name, AggregationType aggregationType) {
        void var1_1;
        Method relevantMethod;
        if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY_COLLECTION) {
            relevantMethod = this.findAdderMethod(name);
        } else if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY) {
            relevantMethod = this.findSetterMethod((String)((Object)relevantMethod));
        } else {
            void var2_2;
            throw new IllegalStateException(String.valueOf(var2_2) + " not allowed here");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    Class<?> getByConcreteType(String name, Method relevantMethod) {
        void var2_2;
        Class<?> paramType = this.getParameterClassForMethod((Method)var2_2);
        if (paramType == null) {
            return null;
        }
        boolean bl = this.isUnequivocallyInstantiable(paramType);
        if (bl) {
            void var1_1;
            return var1_1;
        }
        return null;
    }

    private boolean isUnequivocallyInstantiable(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        try {
            Object t;
            t = ((Class)t).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return t != null;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }
}

