/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class SimpleRuleStore
extends ContextAwareBase
implements RuleStore {
    static String KLEENE_STAR = "*";
    HashMap<ElementSelector, Supplier<Action>> rules = new HashMap();
    List<String> transparentPathParts = new ArrayList<String>(2);
    Map<String, String> pathPartsMapForRenaming = new HashMap<String, String>(2);

    /*
     * WARNING - void declaration
     */
    public SimpleRuleStore(Context context) {
        void var1_1;
        this.setContext((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addTransparentPathPart(String pathPart) {
        void var1_1;
        if (pathPart == null) {
            throw new IllegalArgumentException("pathPart cannot be null");
        }
        if ((pathPart = pathPart.trim()).isEmpty()) {
            throw new IllegalArgumentException("pathPart cannot be empty or to consist of only spaces");
        }
        if (pathPart.contains("/")) {
            throw new IllegalArgumentException("pathPart cannot contain '/', i.e. the forward slash character");
        }
        this.transparentPathParts.add((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addPathPathMapping(String originalName, String modifiedName) {
        void var2_2;
        void var1_1;
        this.pathPartsMapForRenaming.put((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addRule(ElementSelector elementSelector, Supplier<Action> actionSupplier) {
        void var1_1;
        Supplier<Action> supplier = this.rules.get(elementSelector);
        if (supplier == null) {
            void var2_2;
            this.rules.put(elementSelector, (Supplier<Action>)var2_2);
            return;
        }
        throw new IllegalStateException(var1_1.toString() + " already has an associated action supplier");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addRule(ElementSelector elementSelector, String actionClassName) {
        try {
            Action cfr_ignored_0 = (Action)OptionHelper.instantiateByClassName(actionClassName, Action.class, this.context);
            return;
        }
        catch (Exception e) {
            void var1_2;
            void var2_3;
            this.addError("Could not instantiate class [" + (String)var2_3 + "]", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Supplier<Action> matchActions(ElementPath elementPath) {
        void var1_1;
        Supplier<Action> actionSupplier = this.internalMatchAction(elementPath);
        if (actionSupplier != null) {
            void var2_2;
            return var2_2;
        }
        return this.matchActionsWithoutTransparentPartsAndRenamedParts((ElementPath)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Supplier<Action> matchActionsWithoutTransparentPartsAndRenamedParts(ElementPath elementPath) {
        void var1_1;
        ElementPath cleanedElementPath = this.removeTransparentPathParts(elementPath);
        ElementPath renamePathParts = this.renamePathParts(cleanedElementPath);
        return this.internalMatchAction((ElementPath)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Supplier<Action> internalMatchAction(ElementPath elementPath) {
        void var1_1;
        Supplier<Action> actionSupplier = this.fullPathMatch(elementPath);
        if (actionSupplier != null) {
            return actionSupplier;
        }
        actionSupplier = this.suffixMatch(elementPath);
        if (actionSupplier != null) {
            return actionSupplier;
        }
        actionSupplier = this.prefixMatch(elementPath);
        if (actionSupplier != null) {
            return actionSupplier;
        }
        actionSupplier = this.middleMatch((ElementPath)var1_1);
        if (actionSupplier != null) {
            void var2_2;
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    ElementPath removeTransparentPathParts(ElementPath originalElementPath) {
        void var2_2;
        Iterator<String> iterator;
        ArrayList<void> preservedElementList = new ArrayList<void>(originalElementPath.partList.size());
        for (String part : ((ElementPath)((Object)iterator)).partList) {
            void var3_3;
            boolean bl = this.transparentPathParts.stream().noneMatch(p -> {
                String string;
                return p.equalsIgnoreCase(string);
            });
            if (!bl) continue;
            preservedElementList.add(var3_3);
        }
        return new ElementPath((List<String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    ElementPath renamePathParts(ElementPath originalElementPath) {
        void var2_2;
        Iterator<String> iterator;
        ArrayList<void> result = new ArrayList<void>(originalElementPath.partList.size());
        iterator = ((ElementPath)((Object)iterator)).partList.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            String part;
            String string = part = iterator.next();
            String modifiedName = this.pathPartsMapForRenaming.getOrDefault(string, string);
            result.add(var3_3);
        }
        return new ElementPath((List<String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    Supplier<Action> fullPathMatch(ElementPath elementPath) {
        for (ElementSelector selector : this.rules.keySet()) {
            void var3_3;
            if (!selector.fullPathMatch(elementPath)) continue;
            return this.rules.get(var3_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    Supplier<Action> suffixMatch(ElementPath elementPath) {
        int max = 0;
        ElementSelector longestMatchingElementSelector = null;
        for (ElementSelector selector : this.rules.keySet()) {
            int r;
            if (!this.isSuffixPattern(selector) || (r = selector.getTailMatchLength(elementPath)) <= max) continue;
            max = r;
            longestMatchingElementSelector = selector;
        }
        if (longestMatchingElementSelector != null) {
            void var3_3;
            return this.rules.get(var3_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSuffixPattern(ElementSelector p) {
        void var1_1;
        return p.size() > 1 && var1_1.get(0).equals(KLEENE_STAR);
    }

    /*
     * WARNING - void declaration
     */
    Supplier<Action> prefixMatch(ElementPath elementPath) {
        int max = 0;
        ElementSelector longestMatchingElementSelector = null;
        for (ElementSelector selector : this.rules.keySet()) {
            int r;
            String last = selector.peekLast();
            if (!this.isKleeneStar(last) || (r = selector.getPrefixMatchLength(elementPath)) != selector.size() - 1 || r <= max) continue;
            max = r;
            longestMatchingElementSelector = selector;
        }
        if (longestMatchingElementSelector != null) {
            void var3_3;
            return this.rules.get(var3_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isKleeneStar(String last) {
        void var1_1;
        return KLEENE_STAR.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    Supplier<Action> middleMatch(ElementPath path) {
        int max = 0;
        ElementSelector longestMatchingElementSelector = null;
        for (ElementSelector selector : this.rules.keySet()) {
            String last = selector.peekLast();
            String first = null;
            if (selector.size() > 1) {
                first = selector.get(0);
            }
            if (!this.isKleeneStar(last) || !this.isKleeneStar(first)) continue;
            List<String> copyOfPartList = selector.getCopyOfPartList();
            if (copyOfPartList.size() > 2) {
                copyOfPartList.remove(0);
                List<String> list = copyOfPartList;
                list.remove(list.size() - 1);
            }
            int r = 0;
            ElementSelector clone = new ElementSelector(copyOfPartList);
            if (clone.isContainedIn(path)) {
                r = clone.size();
            }
            if (r <= max) continue;
            max = r;
            longestMatchingElementSelector = selector;
        }
        if (longestMatchingElementSelector != null) {
            void var3_3;
            return this.rules.get(var3_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder retValue = new StringBuilder();
        retValue.append("SimpleRuleStore ( rules = ").append(this.rules).append("   )");
        return var1_1.toString();
    }
}

