/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.joran.spi.SaxEventInterpreter;
import ch.qos.logback.core.joran.spi.SimpleRuleStore;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.StatusUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.xml.sax.InputSource;

public abstract class GenericXMLConfigurator
extends ContextAwareBase {
    protected SaxEventInterpreter saxEventInterpreter;
    protected ModelInterpretationContext modelInterpretationContext;
    private RuleStore ruleStore;

    public ModelInterpretationContext getModelInterpretationContext() {
        return this.modelInterpretationContext;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doConfigure(URL url) throws JoranException {
        String errMsg;
        InputStream in = null;
        try {
            GenericXMLConfigurator.informContextOfURLUsedForConfiguration(this.getContext(), url);
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            in = urlConnection.getInputStream();
            this.doConfigure(in, url.toExternalForm());
            if (in == null) return;
        }
        catch (IOException ioe) {
            try {
                void var3_7;
                String errMsg2 = "Could not open URL [" + String.valueOf(errMsg) + "].";
                this.addError(errMsg2, ioe);
                throw new JoranException(errMsg2, (Throwable)var3_7);
            }
            catch (Throwable errMsg2) {
                void var1_2;
                if (in == null) throw var1_2;
                try {
                    in.close();
                    throw var1_2;
                }
                catch (IOException ioe2) {
                    void var1_3;
                    void var2_4;
                    String errMsg3 = "Could not close input stream";
                    this.addError(errMsg3, ioe2);
                    throw new JoranException((String)var2_4, (Throwable)var1_3);
                }
            }
        }
        try {
            in.close();
            return;
        }
        catch (IOException ioe) {
            errMsg = "Could not close input stream";
            this.addError(errMsg, ioe);
            throw new JoranException(errMsg, ioe);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void doConfigure(String filename) throws JoranException {
        void var1_1;
        this.doConfigure(new File((String)var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doConfigure(File file) throws JoranException {
        FileInputStream fis = null;
        try {
            URL url = file.toURI().toURL();
            GenericXMLConfigurator.informContextOfURLUsedForConfiguration(this.getContext(), url);
            fis = new FileInputStream(file);
            this.doConfigure(fis, url.toExternalForm());
        }
        catch (IOException ioe) {
            try {
                void var3_6;
                String errMsg = "Could not open [" + file.getPath() + "].";
                this.addError(errMsg, ioe);
                throw new JoranException(errMsg, (Throwable)var3_6);
            }
            catch (Throwable throwable) {
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException ioe2) {
                    void var2_3;
                    void var1_1;
                    String errMsg = "Could not close [" + file.getName() + "].";
                    this.addError(errMsg, ioe2);
                    throw new JoranException((String)var1_1, (Throwable)var2_3);
                }
            }
        }
        try {
            fis.close();
            return;
        }
        catch (IOException ioe) {
            String errMsg = "Could not close [" + file.getName() + "].";
            this.addError(errMsg, ioe);
            throw new JoranException(errMsg, ioe);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void informContextOfURLUsedForConfiguration(Context context, URL url) {
        void var1_1;
        ConfigurationWatchListUtil.setMainWatchURL(context, (URL)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void doConfigure(InputStream inputStream) throws JoranException {
        void var1_1;
        this.doConfigure(new InputSource((InputStream)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void doConfigure(InputStream inputStream, String systemId) throws JoranException {
        void var1_1;
        void var2_2;
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId((String)var2_2);
        this.doConfigure((InputSource)var1_1);
    }

    protected abstract void addElementSelectorAndActionAssociations(RuleStore var1);

    protected abstract void setImplicitRuleSupplier(SaxEventInterpreter var1);

    protected void addDefaultNestedComponentRegistryRules(DefaultNestedComponentRegistry registry) {
    }

    protected ElementPath initialElementPath() {
        return new ElementPath();
    }

    /*
     * WARNING - void declaration
     */
    protected void buildSaxEventInterpreter(List<SaxEvent> saxEvents) {
        SaxEventInterpretationContext saxEventInterpretationContext;
        void var2_2;
        RuleStore rs = this.getRuleStore();
        this.addElementSelectorAndActionAssociations(rs);
        this.saxEventInterpreter = new SaxEventInterpreter(this.context, (RuleStore)var2_2, this.initialElementPath(), (List<SaxEvent>)((Object)saxEventInterpretationContext));
        saxEventInterpretationContext = this.saxEventInterpreter.getSaxEventInterpretationContext();
        saxEventInterpretationContext.setContext(this.context);
        GenericXMLConfigurator genericXMLConfigurator = this;
        genericXMLConfigurator.setImplicitRuleSupplier(genericXMLConfigurator.saxEventInterpreter);
    }

    public RuleStore getRuleStore() {
        if (this.ruleStore == null) {
            this.ruleStore = new SimpleRuleStore(this.context);
        }
        return this.ruleStore;
    }

    protected void buildModelInterpretationContext() {
        this.modelInterpretationContext = new ModelInterpretationContext(this.context);
        GenericXMLConfigurator genericXMLConfigurator = this;
        genericXMLConfigurator.addDefaultNestedComponentRegistryRules(genericXMLConfigurator.modelInterpretationContext.getDefaultNestedComponentRegistry());
    }

    /*
     * WARNING - void declaration
     */
    public final void doConfigure(InputSource inputSource) throws JoranException {
        void var2_2;
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationStartedEvent(this));
        long threshold = System.currentTimeMillis();
        SaxEventRecorder recorder = this.populateSaxEventRecorder(inputSource);
        Object object = recorder.getSaxEventList();
        if (object.isEmpty()) {
            this.addWarn("Empty sax event list");
            return;
        }
        Model top = this.buildModelFromSaxEventList(recorder.getSaxEventList());
        if (top == null) {
            this.addError("Could not find valid configuration instructions. Exiting.");
            return;
        }
        this.sanityCheck(top);
        this.processModel(top);
        object = new StatusUtil(this.context);
        if (((StatusUtil)object).noXMLParsingErrorsOccurred((long)var2_2)) {
            void var1_1;
            this.addInfo("Registering current configuration as safe fallback point");
            this.registerSafeConfiguration((Model)var1_1);
            this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationEndedSuccessfullyEvent(this));
            return;
        }
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationEndedWithXMLParsingErrorsEvent(this));
    }

    /*
     * WARNING - void declaration
     */
    public SaxEventRecorder populateSaxEventRecorder(InputSource inputSource) throws JoranException {
        void var2_2;
        void var1_1;
        SaxEventRecorder recorder = new SaxEventRecorder(this.context);
        recorder.recordEvents((InputSource)var1_1);
        return var2_2;
    }

    public Model buildModelFromSaxEventList(List<SaxEvent> saxEvents) throws JoranException {
        Model model;
        this.buildSaxEventInterpreter((List<SaxEvent>)((Object)model));
        this.playSaxEvents();
        model = this.saxEventInterpreter.getSaxEventInterpretationContext().peekModel();
        return model;
    }

    private void playSaxEvents() throws JoranException {
        this.saxEventInterpreter.getEventPlayer().play();
    }

    /*
     * WARNING - void declaration
     */
    public void processModel(Model model) {
        this.buildModelInterpretationContext();
        this.modelInterpretationContext.setTopModel(model);
        this.modelInterpretationContext.setConfiguratorHint(this);
        DefaultProcessor defaultProcessor = new DefaultProcessor(this.context, this.modelInterpretationContext);
        this.addModelHandlerAssociations(defaultProcessor);
        ReentrantLock configurationLock = this.context.getConfigurationLock();
        try {
            void var1_1;
            void var2_3;
            configurationLock.lock();
            var2_3.process((Model)var1_1);
            configurationLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            void var3_4;
            var3_4.unlock();
            throw throwable;
        }
    }

    protected void sanityCheck(Model topModel) {
    }

    protected void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
    }

    /*
     * WARNING - void declaration
     */
    public void registerSafeConfiguration(Model top) {
        void var1_1;
        this.context.putObject("SAFE_JORAN_CONFIGURATION", var1_1);
    }

    public Model recallSafeConfiguration() {
        return (Model)this.context.getObject("SAFE_JORAN_CONFIGURATION");
    }
}

