/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.WarnStatus;
import java.util.List;

public abstract class UnsynchronizedAppenderBase<E>
extends ContextAwareBase
implements Appender<E> {
    protected volatile boolean started = false;
    private ThreadLocal<Boolean> guard = new ThreadLocal();
    protected String name;
    private FilterAttachableImpl<E> fai = new FilterAttachableImpl();
    private int statusRepeatCount = 0;
    private int exceptionCount = 0;
    static final int ALLOWED_REPEATS = 3;

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doAppend(E eventObject) {
        if (Boolean.TRUE.equals(this.guard.get())) {
            return;
        }
        try {
            this.guard.set(Boolean.TRUE);
            if (!this.started) {
                if (this.statusRepeatCount++ < 3) {
                    this.addStatus(new WarnStatus("Attempted to append to non started appender [" + this.name + "].", this));
                }
                return;
            }
            if (this.getFilterChainDecision(eventObject) == FilterReply.DENY) {
                return;
            }
            this.append(eventObject);
            return;
        }
        catch (Exception e) {
            if (this.exceptionCount++ < 3) {
                void var1_2;
                UnsynchronizedAppenderBase unsynchronizedAppenderBase = this;
                unsynchronizedAppenderBase.addError("Appender [" + unsynchronizedAppenderBase.name + "] failed to append.", (Throwable)var1_2);
            }
            return;
        }
        finally {
            this.guard.set(Boolean.FALSE);
        }
    }

    protected abstract void append(E var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public void setName(String name) {
        void var1_1;
        this.name = var1_1;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "]";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addFilter(Filter<E> newFilter) {
        void var1_1;
        this.fai.addFilter((Filter<E>)var1_1);
    }

    @Override
    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    @Override
    public List<Filter<E>> getCopyOfAttachedFiltersList() {
        return this.fai.getCopyOfAttachedFiltersList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FilterReply getFilterChainDecision(E event) {
        void var1_1;
        return this.fai.getFilterChainDecision(var1_1);
    }
}

