/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.util.InterruptUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class AsyncAppenderBase<E>
extends UnsynchronizedAppenderBase<E>
implements AppenderAttachable<E> {
    AppenderAttachableImpl<E> aai = new AppenderAttachableImpl();
    BlockingQueue<E> blockingQueue;
    public static final int DEFAULT_QUEUE_SIZE = 256;
    int queueSize = 256;
    int appenderCount = 0;
    static final int UNDEFINED = -1;
    int discardingThreshold = -1;
    boolean neverBlock = false;
    Worker worker = new Worker(this);
    public static final int DEFAULT_MAX_FLUSH_TIME = 1000;
    int maxFlushTime = 1000;

    protected boolean isDiscardable(E eventObject) {
        return false;
    }

    protected void preprocess(E eventObject) {
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        if (this.appenderCount == 0) {
            this.addError("No attached appenders found.");
            return;
        }
        if (this.queueSize <= 0) {
            AsyncAppenderBase asyncAppenderBase = this;
            asyncAppenderBase.addError("Invalid queue size [" + asyncAppenderBase.queueSize + "]");
            return;
        }
        this.blockingQueue = new ArrayBlockingQueue(this.queueSize);
        if (this.discardingThreshold == -1) {
            this.discardingThreshold = this.queueSize / 5;
        }
        AsyncAppenderBase asyncAppenderBase = this;
        asyncAppenderBase.addInfo("Setting discardingThreshold to " + asyncAppenderBase.discardingThreshold);
        this.worker.setDaemon(true);
        this.worker.setName("AsyncAppender-Worker-" + this.getName());
        super.start();
        this.worker.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        this.worker.interrupt();
        InterruptUtil interruptUtil = new InterruptUtil(this.context);
        try {
            interruptUtil.maskInterruptFlag();
            this.worker.join(this.maxFlushTime);
            if (this.worker.isAlive()) {
                AsyncAppenderBase asyncAppenderBase = this;
                asyncAppenderBase.addWarn("Max queue flush timeout (" + asyncAppenderBase.maxFlushTime + " ms) exceeded. Approximately " + this.blockingQueue.size() + " queued events were possibly discarded.");
            } else {
                this.addInfo("Queue flush finished successfully within timeout.");
            }
            interruptUtil.unmaskInterruptFlag();
            return;
        }
        catch (InterruptedException e) {
            try {
                void var2_2;
                void var3_4;
                int remaining = this.blockingQueue.size();
                this.addError("Failed to join worker thread. " + (int)var3_4 + " queued events may be discarded.", (Throwable)var2_2);
                interruptUtil.unmaskInterruptFlag();
                return;
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.unmaskInterruptFlag();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void append(E eventObject) {
        void var1_1;
        if (this.isQueueBelowDiscardingThreshold() && this.isDiscardable(eventObject)) {
            return;
        }
        this.preprocess(eventObject);
        this.put(var1_1);
    }

    public boolean isQueueBelowDiscardingThreshold() {
        return this.blockingQueue.remainingCapacity() < this.discardingThreshold;
    }

    /*
     * WARNING - void declaration
     */
    private void put(E eventObject) {
        void var1_1;
        if (this.neverBlock) {
            this.blockingQueue.offer(eventObject);
            return;
        }
        this.putUninterruptibly(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void putUninterruptibly(E eventObject) {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    this.blockingQueue.put(eventObject);
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        catch (Throwable throwable) {
            void var2_3;
            if (var2_3 != false) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setQueueSize(int queueSize) {
        void var1_1;
        this.queueSize = var1_1;
    }

    public int getDiscardingThreshold() {
        return this.discardingThreshold;
    }

    /*
     * WARNING - void declaration
     */
    public void setDiscardingThreshold(int discardingThreshold) {
        void var1_1;
        this.discardingThreshold = var1_1;
    }

    public int getMaxFlushTime() {
        return this.maxFlushTime;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxFlushTime(int maxFlushTime) {
        void var1_1;
        this.maxFlushTime = var1_1;
    }

    public int getNumberOfElementsInQueue() {
        return this.blockingQueue.size();
    }

    /*
     * WARNING - void declaration
     */
    public void setNeverBlock(boolean neverBlock) {
        void var1_1;
        this.neverBlock = var1_1;
    }

    public boolean isNeverBlock() {
        return this.neverBlock;
    }

    public int getRemainingCapacity() {
        return this.blockingQueue.remainingCapacity();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addAppender(Appender<E> newAppender) {
        void var1_1;
        if (this.appenderCount == 0) {
            ++this.appenderCount;
            this.addInfo("Attaching appender named [" + newAppender.getName() + "] to AsyncAppender.");
            this.aai.addAppender(newAppender);
            return;
        }
        this.addWarn("One and only one appender may be attached to AsyncAppender.");
        this.addWarn("Ignoring additional appender named [" + var1_1.getName() + "]");
    }

    @Override
    public Iterator<Appender<E>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Appender<E> getAppender(String name) {
        void var1_1;
        return this.aai.getAppender((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isAttached(Appender<E> eAppender) {
        void var1_1;
        return this.aai.isAttached((Appender<E>)var1_1);
    }

    @Override
    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean detachAppender(Appender<E> eAppender) {
        void var1_1;
        return this.aai.detachAppender((Appender<E>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean detachAppender(String name) {
        void var1_1;
        return this.aai.detachAppender((String)var1_1);
    }

    class Worker
    extends Thread {
        final /* synthetic */ AsyncAppenderBase this$0;

        /*
         * WARNING - void declaration
         */
        Worker(AsyncAppenderBase this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void var2_2;
            AsyncAppenderBase parent = this.this$0;
            AppenderAttachableImpl aai = parent.aai;
            while (parent.isStarted()) {
                try {
                    Iterator iterator;
                    ArrayList elements = new ArrayList();
                    Object e0 = parent.blockingQueue.take();
                    elements.add(e0);
                    parent.blockingQueue.drainTo(elements);
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        aai.appendLoopOnAppenders(e);
                    }
                    continue;
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            this.this$0.addInfo("Worker thread will flush remaining events before exiting. ");
            for (Object e : parent.blockingQueue) {
                aai.appendLoopOnAppenders(e);
                parent.blockingQueue.remove(e);
            }
            var2_2.detachAndStopAllAppenders();
        }
    }
}

