/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryBaseEvent;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.MetricSummary;
import io.sentry.protocol.SentrySpan;
import io.sentry.protocol.TransactionInfo;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SentryTransaction
extends SentryBaseEvent
implements JsonSerializable {
    private String transaction;
    private Double startTimestamp;
    private Double timestamp;
    private final List<SentrySpan> spans = new ArrayList<SentrySpan>();
    private final String type = "transaction";
    private final Map<String, MeasurementValue> measurements = new HashMap<String, MeasurementValue>();
    private Map<String, List<MetricSummary>> metricSummaries;
    private TransactionInfo transactionInfo;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public SentryTransaction(String transaction, Double startTimestamp, Double timestamp, List<SentrySpan> spans, Map<String, MeasurementValue> measurements, Map<String, List<MetricSummary>> metricsSummaries, TransactionInfo transactionInfo) {
        Iterator<SentrySpan> iterator;
        this.transaction = iterator;
        this.startTimestamp = startTimestamp;
        this.timestamp = null;
        this.spans.addAll(spans);
        this.measurements.putAll(measurements);
        for (SentrySpan span : spans) {
            void var2_2;
            this.measurements.putAll(var2_2.getMeasurements());
        }
        this.transactionInfo = transactionInfo;
        this.metricSummaries = null;
    }

    public final List<SentrySpan> getSpans() {
        return this.spans;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        if (this.transaction != null) {
            writer.name$7c2ed8b3("transaction").value$7c2ed8b3(this.transaction);
        }
        writer.name$7c2ed8b3("start_timestamp").value$74e4a76(logger, SentryTransaction.doubleToBigDecimal(this.startTimestamp));
        if (this.timestamp != null) {
            writer.name$7c2ed8b3("timestamp").value$74e4a76(logger, SentryTransaction.doubleToBigDecimal(this.timestamp));
        }
        if (!this.spans.isEmpty()) {
            writer.name$7c2ed8b3("spans").value$74e4a76(logger, this.spans);
        }
        writer.name$7c2ed8b3("type").value$7c2ed8b3("transaction");
        if (!this.measurements.isEmpty()) {
            writer.name$7c2ed8b3("measurements").value$74e4a76(logger, this.measurements);
        }
        if (this.metricSummaries != null && !this.metricSummaries.isEmpty()) {
            writer.name$7c2ed8b3("_metrics_summary").value$74e4a76(logger, this.metricSummaries);
        }
        writer.name$7c2ed8b3("transaction_info").value$74e4a76(logger, this.transactionInfo);
        new SentryBaseEvent.Serializer();
        SentryBaseEvent.Serializer.serialize(this, writer, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key);
                writer.value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    private static BigDecimal doubleToBigDecimal(Double value) {
        return BigDecimal.valueOf(value).setScale(6, RoundingMode.DOWN);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$002(SentryTransaction x0, String x1) {
        void var1_1;
        x0.transaction = var1_1;
        return x0.transaction;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Double access$102(SentryTransaction x0, Double x1) {
        void var1_1;
        x0.startTimestamp = var1_1;
        return x0.startTimestamp;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Double access$202(SentryTransaction x0, Double x1) {
        void var1_1;
        x0.timestamp = var1_1;
        return x0.timestamp;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$502(SentryTransaction x0, Map x1) {
        void var1_1;
        x0.metricSummaries = var1_1;
        return x0.metricSummaries;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ TransactionInfo access$602(SentryTransaction x0, TransactionInfo x1) {
        void var1_1;
        x0.transactionInfo = var1_1;
        return x0.transactionInfo;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryTransaction> {
        /*
         * WARNING - void declaration
         */
        private static SentryTransaction deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var2_2;
            ObjectReader objectReader;
            void var3_3;
            reader.beginObject();
            SentryTransaction transaction = new SentryTransaction("", 0.0, null, new ArrayList<SentrySpan>(), new HashMap<String, MeasurementValue>(), null, new TransactionInfo(TransactionNameSource.CUSTOM.apiName()));
            ConcurrentHashMap<String, Object> unknown = null;
            new SentryBaseEvent.Deserializer();
            block24: while (reader.peek() == JsonToken.NAME) {
                void var4_4;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "transaction": {
                        SentryTransaction.access$002(transaction, reader.nextStringOrNull());
                        continue block24;
                    }
                    case "start_timestamp": {
                        Date date;
                        try {
                            Double deserializedStartTimestamp = reader.nextDoubleOrNull();
                            if (deserializedStartTimestamp == null) continue block24;
                            SentryTransaction.access$102(transaction, deserializedStartTimestamp);
                        }
                        catch (NumberFormatException numberFormatException) {
                            date = reader.nextDateOrNull(logger);
                            if (date == null) continue block24;
                            SentryTransaction.access$102(transaction, DateUtils.dateToSeconds(date));
                        }
                        continue block24;
                    }
                    case "timestamp": {
                        Date date;
                        try {
                            Double deserializedTimestamp = reader.nextDoubleOrNull();
                            if (deserializedTimestamp == null) continue block24;
                            SentryTransaction.access$202(transaction, deserializedTimestamp);
                        }
                        catch (NumberFormatException numberFormatException) {
                            date = reader.nextDateOrNull(logger);
                            if (date == null) continue block24;
                            SentryTransaction.access$202(transaction, DateUtils.dateToSeconds(date));
                        }
                        continue block24;
                    }
                    case "spans": {
                        List<SentrySpan> deserializedSpans = reader.nextListOrNull(logger, new SentrySpan.Deserializer());
                        if (deserializedSpans == null) continue block24;
                        transaction.spans.addAll(deserializedSpans);
                        continue block24;
                    }
                    case "type": {
                        reader.nextString();
                        continue block24;
                    }
                    case "measurements": {
                        Map<String, MeasurementValue> deserializedMeasurements = reader.nextMapOrNull(logger, new MeasurementValue.Deserializer());
                        if (deserializedMeasurements == null) continue block24;
                        transaction.measurements.putAll(deserializedMeasurements);
                        continue block24;
                    }
                    case "_metrics_summary": {
                        SentryTransaction.access$502(transaction, reader.nextMapOfListOrNull$6cb976c4(logger, new MetricSummary.Deserializer()));
                        continue block24;
                    }
                    case "transaction_info": {
                        new TransactionInfo.Deserializer();
                        SentryTransaction.access$602(transaction, TransactionInfo.Deserializer.deserialize(reader, logger));
                        continue block24;
                    }
                }
                if (SentryBaseEvent.Deserializer.deserializeValue(transaction, (String)var4_4, reader, logger)) continue;
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)var4_4);
            }
            transaction.setUnknown((Map<String, Object>)var3_3);
            objectReader.endObject();
            return var2_2;
        }
    }
}

