/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.MetricSummary;
import io.sentry.protocol.SentryId;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SentrySpan
implements JsonSerializable {
    private final Double startTimestamp;
    private final Double timestamp;
    private final SentryId traceId;
    private final SpanId spanId;
    private final SpanId parentSpanId;
    private final String op;
    private final String description;
    private final SpanStatus status;
    private final String origin;
    private final Map<String, String> tags;
    private Map<String, Object> data;
    private final Map<String, MeasurementValue> measurements;
    private final Map<String, List<MetricSummary>> metricsSummaries;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public SentrySpan(Double startTimestamp, Double timestamp, SentryId traceId, SpanId spanId, SpanId parentSpanId, String op, String description, SpanStatus status, String origin, Map<String, String> tags, Map<String, MeasurementValue> measurements, Map<String, List<MetricSummary>> metricSummaries, Map<String, Object> data) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.startTimestamp = var1_1;
        this.timestamp = var2_2;
        this.traceId = var3_3;
        this.spanId = spanId;
        this.parentSpanId = parentSpanId;
        this.op = op;
        this.description = description;
        this.status = status;
        this.origin = origin;
        this.tags = tags;
        this.measurements = measurements;
        this.metricsSummaries = metricSummaries;
        this.data = data;
    }

    public final Map<String, MeasurementValue> getMeasurements() {
        return this.measurements;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        writer.name$7c2ed8b3("start_timestamp").value$74e4a76(logger, SentrySpan.doubleToBigDecimal(this.startTimestamp));
        if (this.timestamp != null) {
            writer.name$7c2ed8b3("timestamp").value$74e4a76(logger, SentrySpan.doubleToBigDecimal(this.timestamp));
        }
        writer.name$7c2ed8b3("trace_id").value$74e4a76(logger, this.traceId);
        writer.name$7c2ed8b3("span_id").value$74e4a76(logger, this.spanId);
        if (this.parentSpanId != null) {
            writer.name$7c2ed8b3("parent_span_id").value$74e4a76(logger, this.parentSpanId);
        }
        writer.name$7c2ed8b3("op").value$7c2ed8b3(this.op);
        if (this.description != null) {
            writer.name$7c2ed8b3("description").value$7c2ed8b3(this.description);
        }
        if (this.status != null) {
            writer.name$7c2ed8b3("status").value$74e4a76(logger, this.status);
        }
        if (this.origin != null) {
            writer.name$7c2ed8b3("origin").value$74e4a76(logger, this.origin);
        }
        if (!this.tags.isEmpty()) {
            writer.name$7c2ed8b3("tags").value$74e4a76(logger, this.tags);
        }
        if (this.data != null) {
            writer.name$7c2ed8b3("data").value$74e4a76(logger, this.data);
        }
        if (!this.measurements.isEmpty()) {
            writer.name$7c2ed8b3("measurements").value$74e4a76(logger, this.measurements);
        }
        if (this.metricsSummaries != null && !this.metricsSummaries.isEmpty()) {
            writer.name$7c2ed8b3("_metrics_summary").value$74e4a76(logger, this.metricsSummaries);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key);
                writer.value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    private static BigDecimal doubleToBigDecimal(Double value) {
        return BigDecimal.valueOf(value).setScale(6, RoundingMode.DOWN);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentrySpan> {
        /*
         * WARNING - void declaration
         */
        @Override
        private SentrySpan deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            void var3_3;
            reader.beginObject();
            Double startTimestamp = null;
            Double timestamp = null;
            SentryId traceId = null;
            SpanId spanId = null;
            SpanId parentSpanId = null;
            String op = null;
            String description = null;
            SpanStatus status = null;
            String origin = null;
            HashMap<String, String> tags = null;
            HashMap<String, MeasurementValue> measurements = null;
            Map metricSummaries = null;
            Map data = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block34: while (reader.peek() == JsonToken.NAME) {
                Date date;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "start_timestamp": {
                        try {
                            startTimestamp = reader.nextDoubleOrNull();
                        }
                        catch (NumberFormatException numberFormatException) {
                            date = reader.nextDateOrNull(logger);
                            startTimestamp = date != null ? Double.valueOf(DateUtils.dateToSeconds(date)) : null;
                        }
                        continue block34;
                    }
                    case "timestamp": {
                        try {
                            timestamp = reader.nextDoubleOrNull();
                        }
                        catch (NumberFormatException numberFormatException) {
                            date = reader.nextDateOrNull(logger);
                            timestamp = date != null ? Double.valueOf(DateUtils.dateToSeconds(date)) : null;
                        }
                        continue block34;
                    }
                    case "trace_id": {
                        new SentryId.Deserializer();
                        traceId = SentryId.Deserializer.deserialize$46ab8b5b(reader);
                        continue block34;
                    }
                    case "span_id": {
                        new SpanId.Deserializer();
                        spanId = SpanId.Deserializer.deserialize$64cbb345(reader);
                        continue block34;
                    }
                    case "parent_span_id": {
                        parentSpanId = reader.nextOrNull(logger, new SpanId.Deserializer());
                        continue block34;
                    }
                    case "op": {
                        op = reader.nextStringOrNull();
                        continue block34;
                    }
                    case "description": {
                        description = reader.nextStringOrNull();
                        continue block34;
                    }
                    case "status": {
                        status = reader.nextOrNull(logger, new SpanStatus.Deserializer());
                        continue block34;
                    }
                    case "origin": {
                        origin = reader.nextStringOrNull();
                        continue block34;
                    }
                    case "tags": {
                        tags = (Map)reader.nextObjectOrNull();
                        continue block34;
                    }
                    case "data": {
                        data = (Map)reader.nextObjectOrNull();
                        continue block34;
                    }
                    case "measurements": {
                        measurements = reader.nextMapOrNull(logger, new MeasurementValue.Deserializer());
                        continue block34;
                    }
                    case "_metrics_summary": {
                        metricSummaries = reader.nextMapOfListOrNull$6cb976c4(logger, new MetricSummary.Deserializer());
                        continue block34;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)((Object)date));
            }
            if (startTimestamp == null) {
                throw Deserializer.missingRequiredFieldException("start_timestamp", logger);
            }
            if (traceId == null) {
                throw Deserializer.missingRequiredFieldException("trace_id", logger);
            }
            if (spanId == null) {
                throw Deserializer.missingRequiredFieldException("span_id", logger);
            }
            if (op == null) {
                void var2_2;
                throw Deserializer.missingRequiredFieldException("op", (ILogger)var2_2);
            }
            if (tags == null) {
                tags = new HashMap();
            }
            if (measurements == null) {
                measurements = new HashMap();
            }
            SentrySpan sentrySpan = new SentrySpan((Double)var3_3, timestamp, traceId, spanId, parentSpanId, op, description, status, origin, tags, measurements, metricSummaries, data);
            sentrySpan.setUnknown(unknown);
            var1_1.endObject();
            return sentrySpan;
        }

        /*
         * WARNING - void declaration
         */
        private static Exception missingRequiredFieldException(String field, ILogger logger) {
            void var2_2;
            String string;
            void var1_1;
            String message = "Missing required field \"" + field + "\"";
            IllegalStateException exception = new IllegalStateException(message);
            var1_1.log(SentryLevel.ERROR, string, exception);
            return var2_2;
        }
    }
}

