/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.util.CollectionUtils;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class App
implements JsonSerializable {
    private String appIdentifier;
    private Date appStartTime;
    private String deviceAppHash;
    private String buildType;
    private String appName;
    private String appVersion;
    private String appBuild;
    private Map<String, String> permissions;
    private List<String> viewNames;
    private String startType;
    private Boolean inForeground;
    private Map<String, Object> unknown;

    public App() {
    }

    /*
     * WARNING - void declaration
     */
    App(App app) {
        void var1_1;
        this.appBuild = app.appBuild;
        this.appIdentifier = app.appIdentifier;
        this.appName = app.appName;
        this.appStartTime = app.appStartTime;
        this.appVersion = app.appVersion;
        this.buildType = app.buildType;
        this.deviceAppHash = app.deviceAppHash;
        this.permissions = CollectionUtils.newConcurrentHashMap(app.permissions);
        this.inForeground = app.inForeground;
        this.viewNames = CollectionUtils.newArrayList(app.viewNames);
        this.startType = app.startType;
        this.unknown = CollectionUtils.newConcurrentHashMap(var1_1.unknown);
    }

    /*
     * WARNING - void declaration
     */
    public final void setViewNames(List<String> viewNames) {
        void var1_1;
        this.viewNames = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        App app = (App)o;
        return Objects.equals(this.appIdentifier, app.appIdentifier) && Objects.equals(this.appStartTime, app.appStartTime) && Objects.equals(this.deviceAppHash, app.deviceAppHash) && Objects.equals(this.buildType, app.buildType) && Objects.equals(this.appName, app.appName) && Objects.equals(this.appVersion, app.appVersion) && Objects.equals(this.appBuild, app.appBuild) && Objects.equals(this.permissions, app.permissions) && Objects.equals(this.inForeground, app.inForeground) && Objects.equals(this.viewNames, app.viewNames) && Objects.equals(this.startType, var1_1.startType);
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.appIdentifier, this.appStartTime, this.deviceAppHash, this.buildType, this.appName, this.appVersion, this.appBuild, this.permissions, this.inForeground, this.viewNames, this.startType};
        return Arrays.hashCode(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        if (this.appIdentifier != null) {
            writer.name$7c2ed8b3("app_identifier").value$7c2ed8b3(this.appIdentifier);
        }
        if (this.appStartTime != null) {
            writer.name$7c2ed8b3("app_start_time").value$74e4a76(logger, this.appStartTime);
        }
        if (this.deviceAppHash != null) {
            writer.name$7c2ed8b3("device_app_hash").value$7c2ed8b3(this.deviceAppHash);
        }
        if (this.buildType != null) {
            writer.name$7c2ed8b3("build_type").value$7c2ed8b3(this.buildType);
        }
        if (this.appName != null) {
            writer.name$7c2ed8b3("app_name").value$7c2ed8b3(this.appName);
        }
        if (this.appVersion != null) {
            writer.name$7c2ed8b3("app_version").value$7c2ed8b3(this.appVersion);
        }
        if (this.appBuild != null) {
            writer.name$7c2ed8b3("app_build").value$7c2ed8b3(this.appBuild);
        }
        if (this.permissions != null && !this.permissions.isEmpty()) {
            writer.name$7c2ed8b3("permissions").value$74e4a76(logger, this.permissions);
        }
        if (this.inForeground != null) {
            writer.name$7c2ed8b3("in_foreground").value$64a46b74(this.inForeground);
        }
        if (this.viewNames != null) {
            writer.name$7c2ed8b3("view_names").value$74e4a76(logger, this.viewNames);
        }
        if (this.startType != null) {
            writer.name$7c2ed8b3("start_type").value$7c2ed8b3(this.startType);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key).value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$002(App x0, String x1) {
        void var1_1;
        x0.appIdentifier = var1_1;
        return x0.appIdentifier;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Date access$102(App x0, Date x1) {
        void var1_1;
        x0.appStartTime = var1_1;
        return x0.appStartTime;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$202(App x0, String x1) {
        void var1_1;
        x0.deviceAppHash = var1_1;
        return x0.deviceAppHash;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$302(App x0, String x1) {
        void var1_1;
        x0.buildType = var1_1;
        return x0.buildType;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$402(App x0, String x1) {
        void var1_1;
        x0.appName = var1_1;
        return x0.appName;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$502(App x0, String x1) {
        void var1_1;
        x0.appVersion = var1_1;
        return x0.appVersion;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$602(App x0, String x1) {
        void var1_1;
        x0.appBuild = var1_1;
        return x0.appBuild;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$702(App x0, Map x1) {
        void var1_1;
        x0.permissions = var1_1;
        return x0.permissions;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Boolean access$802(App x0, Boolean x1) {
        void var1_1;
        x0.inForeground = var1_1;
        return x0.inForeground;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$902(App x0, String x1) {
        void var1_1;
        x0.startType = var1_1;
        return x0.startType;
    }

    public static final class Deserializer
    implements JsonDeserializer<App> {
        /*
         * WARNING - void declaration
         */
        public static App deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var2_2;
            ObjectReader objectReader;
            void var3_3;
            reader.beginObject();
            App app = new App();
            ConcurrentHashMap<String, Object> unknown = null;
            block26: while (reader.peek() == JsonToken.NAME) {
                void var4_4;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "app_identifier": {
                        App.access$002(app, reader.nextStringOrNull());
                        continue block26;
                    }
                    case "app_start_time": {
                        App.access$102(app, reader.nextDateOrNull(logger));
                        continue block26;
                    }
                    case "device_app_hash": {
                        App.access$202(app, reader.nextStringOrNull());
                        continue block26;
                    }
                    case "build_type": {
                        App.access$302(app, reader.nextStringOrNull());
                        continue block26;
                    }
                    case "app_name": {
                        App.access$402(app, reader.nextStringOrNull());
                        continue block26;
                    }
                    case "app_version": {
                        App.access$502(app, reader.nextStringOrNull());
                        continue block26;
                    }
                    case "app_build": {
                        App.access$602(app, reader.nextStringOrNull());
                        continue block26;
                    }
                    case "permissions": {
                        App.access$702(app, CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull()));
                        continue block26;
                    }
                    case "in_foreground": {
                        App.access$802(app, reader.nextBooleanOrNull());
                        continue block26;
                    }
                    case "view_names": {
                        List viewNames = (List)reader.nextObjectOrNull();
                        if (viewNames == null) continue block26;
                        app.setViewNames(viewNames);
                        continue block26;
                    }
                    case "start_type": {
                        App.access$902(app, reader.nextStringOrNull());
                        continue block26;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)var4_4);
            }
            app.setUnknown((Map<String, Object>)var3_3);
            objectReader.endObject();
            return var2_2;
        }
    }
}

