/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Baggage;
import io.sentry.Instrumenter;
import io.sentry.PropagationContext;
import io.sentry.SpanContext;
import io.sentry.SpanId;
import io.sentry.TracesSamplingDecision;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.util.Objects;

public final class TransactionContext
extends SpanContext {
    private static final TransactionNameSource DEFAULT_NAME_SOURCE = TransactionNameSource.CUSTOM;
    private String name;
    private TransactionNameSource transactionNameSource;
    private TracesSamplingDecision parentSamplingDecision;
    private Baggage baggage;
    private Instrumenter instrumenter = Instrumenter.SENTRY;
    private boolean isForNextAppStart = false;

    /*
     * WARNING - void declaration
     */
    public static TransactionContext fromPropagationContext(PropagationContext propagationContext) {
        void var3_3;
        PropagationContext propagationContext2;
        TracesSamplingDecision tracesSamplingDecision;
        Boolean parentSampled = propagationContext.isSampled();
        TracesSamplingDecision samplingDecision = parentSampled == null ? null : new TracesSamplingDecision(parentSampled);
        Baggage baggage = propagationContext.getBaggage();
        if (baggage != null) {
            void var1_1;
            baggage.freeze();
            Double sampleRate = baggage.getSampleRateDouble();
            Boolean sampled = parentSampled != null ? parentSampled : false;
            tracesSamplingDecision = sampleRate != null ? new TracesSamplingDecision(sampled, (Double)((Object)tracesSamplingDecision)) : new TracesSamplingDecision((Boolean)var1_1);
        }
        return new TransactionContext(propagationContext.getTraceId(), propagationContext.getSpanId(), propagationContext2.getParentSpanId(), tracesSamplingDecision, (Baggage)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public TransactionContext(String name, String operation) {
        this((String)var1_1, (String)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private TransactionContext(String name, String operation, TracesSamplingDecision samplingDecision) {
        this((String)var1_1, TransactionNameSource.CUSTOM, (String)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private TransactionContext(String name, TransactionNameSource transactionNameSource, String operation, TracesSamplingDecision samplingDecision) {
        super((String)var3_3);
        void var2_2;
        void var1_1;
        void var3_3;
        this.name = (String)Objects.requireNonNull(var1_1, "name is required");
        this.transactionNameSource = var2_2;
        this.setSamplingDecision(samplingDecision);
    }

    /*
     * WARNING - void declaration
     */
    private TransactionContext(SentryId traceId, SpanId spanId, SpanId parentSpanId, TracesSamplingDecision parentSamplingDecision, Baggage baggage) {
        super((SentryId)var1_1, (SpanId)var2_2, "default", (SpanId)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = "<unlabeled transaction>";
        this.parentSamplingDecision = parentSamplingDecision;
        this.transactionNameSource = DEFAULT_NAME_SOURCE;
        this.baggage = baggage;
    }

    public final TracesSamplingDecision getParentSamplingDecision() {
        return this.parentSamplingDecision;
    }

    public final void setForNextAppStart(boolean forNextAppStart) {
        this.isForNextAppStart = true;
    }
}

