/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.TracesSamplingDecision;
import io.sentry.protocol.SentryId;
import io.sentry.util.CollectionUtils;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SpanContext
implements JsonSerializable {
    private final SentryId traceId;
    private final SpanId spanId;
    private final SpanId parentSpanId;
    private transient TracesSamplingDecision samplingDecision;
    protected String op;
    protected String description;
    protected SpanStatus status;
    protected Map<String, String> tags = new ConcurrentHashMap<String, String>();
    protected String origin = "manual";
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public SpanContext(String operation) {
        this(new SentryId(), new SpanId(), (String)var1_1, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SpanContext(SentryId traceId, SpanId spanId, String operation, SpanId parentSpanId, TracesSamplingDecision samplingDecision) {
        this((SentryId)var1_1, (SpanId)var2_2, parentSpanId, (String)var3_3, null, null, null, "manual");
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SpanContext(SentryId traceId, SpanId spanId, SpanId parentSpanId, String operation, String description, TracesSamplingDecision samplingDecision, SpanStatus status, String origin) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.traceId = (SentryId)Objects.requireNonNull(var1_1, "traceId is required");
        this.spanId = (SpanId)Objects.requireNonNull(var2_2, "spanId is required");
        this.op = Objects.requireNonNull(operation, "operation is required");
        this.parentSpanId = var3_3;
        this.samplingDecision = samplingDecision;
        this.description = description;
        this.status = status;
        this.origin = origin;
    }

    /*
     * WARNING - void declaration
     */
    public SpanContext(SpanContext spanContext) {
        this.traceId = spanContext.traceId;
        this.spanId = spanContext.spanId;
        this.parentSpanId = spanContext.parentSpanId;
        this.samplingDecision = spanContext.samplingDecision;
        this.op = spanContext.op;
        this.description = spanContext.description;
        this.status = spanContext.status;
        Map<String, String> copiedTags = CollectionUtils.newConcurrentHashMap(spanContext.tags);
        if (copiedTags != null) {
            void var1_1;
            this.tags = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setDescription(String description) {
        void var1_1;
        this.description = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setStatus(SpanStatus status) {
        void var1_1;
        this.status = var1_1;
    }

    public final SentryId getTraceId() {
        return this.traceId;
    }

    public final TracesSamplingDecision getSamplingDecision() {
        return this.samplingDecision;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSamplingDecision(TracesSamplingDecision samplingDecision) {
        void var1_1;
        this.samplingDecision = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setOrigin(String origin) {
        void var1_1;
        this.origin = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanContext)) {
            return false;
        }
        SpanContext that = (SpanContext)o;
        return this.traceId.equals(that.traceId) && this.spanId.equals(that.spanId) && Objects.equals(this.parentSpanId, that.parentSpanId) && this.op.equals(that.op) && Objects.equals(this.description, that.description) && this.status == var1_1.status;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.traceId, this.spanId, this.parentSpanId, this.op, this.description, this.status};
        return Arrays.hashCode(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        writer.name$7c2ed8b3("trace_id");
        this.traceId.serialize(writer, logger);
        writer.name$7c2ed8b3("span_id");
        this.spanId.serialize(writer, logger);
        if (this.parentSpanId != null) {
            writer.name$7c2ed8b3("parent_span_id");
            this.parentSpanId.serialize(writer, logger);
        }
        writer.name$7c2ed8b3("op").value$7c2ed8b3(this.op);
        if (this.description != null) {
            writer.name$7c2ed8b3("description").value$7c2ed8b3(this.description);
        }
        if (this.status != null) {
            writer.name$7c2ed8b3("status").value$74e4a76(logger, this.status);
        }
        if (this.origin != null) {
            writer.name$7c2ed8b3("origin").value$74e4a76(logger, this.origin);
        }
        if (!this.tags.isEmpty()) {
            writer.name$7c2ed8b3("tags").value$74e4a76(logger, this.tags);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key).value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class Deserializer
    implements JsonDeserializer<SpanContext> {
        /*
         * WARNING - void declaration
         */
        public static SpanContext deserialize(ObjectReader reader, ILogger logger) throws Exception {
            ObjectReader objectReader;
            void var3_3;
            void var2_2;
            IllegalStateException exception;
            String message;
            reader.beginObject();
            SentryId traceId = null;
            SpanId spanId = null;
            SpanId parentSpanId = null;
            String op = null;
            String description = null;
            SpanStatus status = null;
            String origin = null;
            Map tags = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block20: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "trace_id": {
                        new SentryId.Deserializer();
                        traceId = SentryId.Deserializer.deserialize$46ab8b5b(reader);
                        continue block20;
                    }
                    case "span_id": {
                        new SpanId.Deserializer();
                        spanId = SpanId.Deserializer.deserialize$64cbb345(reader);
                        continue block20;
                    }
                    case "parent_span_id": {
                        parentSpanId = reader.nextOrNull(logger, new SpanId.Deserializer());
                        continue block20;
                    }
                    case "op": {
                        op = reader.nextString();
                        continue block20;
                    }
                    case "description": {
                        description = reader.nextString();
                        continue block20;
                    }
                    case "status": {
                        status = reader.nextOrNull(logger, new SpanStatus.Deserializer());
                        continue block20;
                    }
                    case "origin": {
                        origin = reader.nextString();
                        continue block20;
                    }
                    case "tags": {
                        tags = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        continue block20;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            if (traceId == null) {
                message = "Missing required field \"trace_id\"";
                exception = new IllegalStateException(message);
                logger.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            if (spanId == null) {
                void var1_1;
                message = "Missing required field \"span_id\"";
                exception = new IllegalStateException(message);
                var1_1.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            if (op == null) {
                op = "";
            }
            SpanContext spanContext = new SpanContext((SentryId)var2_2, (SpanId)var3_3, op, parentSpanId, null);
            spanContext.setDescription(description);
            spanContext.setStatus(status);
            spanContext.setOrigin(origin);
            if (tags != null) {
                spanContext.tags = tags;
            }
            spanContext.setUnknown(unknown);
            objectReader.endObject();
            return spanContext;
        }
    }
}

