/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.util.StringUtils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class Session
implements JsonSerializable {
    private final Date started;
    private Date timestamp;
    private final AtomicInteger errorCount;
    private final String distinctId;
    private final UUID sessionId;
    private Boolean init;
    private State status;
    private Long sequence;
    private Double duration;
    private final String ipAddress;
    private String userAgent;
    private final String environment;
    private final String release;
    private String abnormalMechanism;
    private final Object sessionLock = new Object();
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public Session(State status, Date started, Date timestamp, int errorCount, String distinctId, UUID sessionId, Boolean init, Long sequence, Double duration, String ipAddress, String userAgent, String environment, String release, String abnormalMechanism) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.status = var1_1;
        this.started = var2_2;
        this.timestamp = var3_3;
        this.errorCount = new AtomicInteger(errorCount);
        this.distinctId = distinctId;
        this.sessionId = sessionId;
        this.init = init;
        this.sequence = sequence;
        this.duration = duration;
        this.ipAddress = ipAddress;
        this.userAgent = userAgent;
        this.environment = environment;
        this.release = release;
        this.abnormalMechanism = abnormalMechanism;
    }

    public final boolean isTerminated() {
        return this.status != State.Ok;
    }

    public final Date getStarted() {
        if (this.started == null) {
            return null;
        }
        return (Date)this.started.clone();
    }

    public final UUID getSessionId() {
        return this.sessionId;
    }

    public final Boolean getInit() {
        return this.init;
    }

    public final void setInitAsTrue() {
        this.init = Boolean.TRUE;
    }

    public final int errorCount() {
        return this.errorCount.get();
    }

    public final State getStatus() {
        return this.status;
    }

    public final String getAbnormalMechanism() {
        return this.abnormalMechanism;
    }

    /*
     * WARNING - void declaration
     */
    public final void end(Date timestamp) {
        Object object = this.sessionLock;
        synchronized (object) {
            void var1_1;
            this.init = null;
            if (this.status == State.Ok) {
                this.status = State.Exited;
            }
            this.timestamp = timestamp != null ? var1_1 : DateUtils.getCurrentDateTime();
            if (this.timestamp != null) {
                this.duration = this.calculateDurationTime(this.timestamp);
                this.sequence = Session.getSequenceTimestamp(this.timestamp);
            }
            return;
        }
    }

    private double calculateDurationTime(Date timestamp) {
        long l = Math.abs(timestamp.getTime() - this.started.getTime());
        return (double)l / 1000.0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean update(State status, String userAgent, boolean addErrorsCount, String abnormalMechanism) {
        Object object = this.sessionLock;
        synchronized (object) {
            void var3_4;
            boolean sessionHasBeenUpdated = false;
            if (status != null) {
                void var1_1;
                this.status = var1_1;
                sessionHasBeenUpdated = true;
            }
            if (userAgent != null) {
                void var2_3;
                this.userAgent = var2_3;
                sessionHasBeenUpdated = true;
            }
            if (var3_4 != false) {
                this.errorCount.addAndGet(1);
                sessionHasBeenUpdated = true;
            }
            if (abnormalMechanism != null) {
                this.abnormalMechanism = abnormalMechanism;
                sessionHasBeenUpdated = true;
            }
            if (sessionHasBeenUpdated) {
                this.init = null;
                this.timestamp = DateUtils.getCurrentDateTime();
                if (this.timestamp != null) {
                    this.sequence = Session.getSequenceTimestamp(this.timestamp);
                }
            }
            return sessionHasBeenUpdated;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static long getSequenceTimestamp(Date timestamp) {
        void var1_1;
        long sequence = timestamp.getTime();
        if (sequence < 0L) {
            sequence = Math.abs(sequence);
        }
        return (long)var1_1;
    }

    public final Session clone() {
        return new Session(this.status, this.started, this.timestamp, this.errorCount.get(), this.distinctId, this.sessionId, this.init, this.sequence, this.duration, this.ipAddress, this.userAgent, this.environment, this.release, this.abnormalMechanism);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        if (this.sessionId != null) {
            writer.name$7c2ed8b3("sid").value$7c2ed8b3(this.sessionId.toString());
        }
        if (this.distinctId != null) {
            writer.name$7c2ed8b3("did").value$7c2ed8b3(this.distinctId);
        }
        if (this.init != null) {
            writer.name$7c2ed8b3("init").value$64a46b74(this.init);
        }
        writer.name$7c2ed8b3("started").value$74e4a76(logger, this.started);
        writer.name$7c2ed8b3("status").value$74e4a76(logger, this.status.name().toLowerCase(Locale.ROOT));
        if (this.sequence != null) {
            writer.name$7c2ed8b3("seq").value$35a3737b(this.sequence);
        }
        writer.name$7c2ed8b3("errors").value$1b925ea3(this.errorCount.intValue());
        if (this.duration != null) {
            writer.name$7c2ed8b3("duration").value$35a3737b(this.duration);
        }
        if (this.timestamp != null) {
            writer.name$7c2ed8b3("timestamp").value$74e4a76(logger, this.timestamp);
        }
        if (this.abnormalMechanism != null) {
            writer.name$7c2ed8b3("abnormal_mechanism").value$74e4a76(logger, this.abnormalMechanism);
        }
        writer.name$7c2ed8b3("attrs");
        writer.beginObject$4f1a06e9();
        writer.name$7c2ed8b3("release").value$74e4a76(logger, this.release);
        if (this.environment != null) {
            writer.name$7c2ed8b3("environment").value$74e4a76(logger, this.environment);
        }
        if (this.ipAddress != null) {
            writer.name$7c2ed8b3("ip_address").value$74e4a76(logger, this.ipAddress);
        }
        if (this.userAgent != null) {
            writer.name$7c2ed8b3("user_agent").value$74e4a76(logger, this.userAgent);
        }
        writer.endObject$4f1a06e9();
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key);
                writer.value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static enum State {
        Ok,
        Exited,
        Crashed,
        Abnormal;

    }

    public static final class Deserializer
    implements JsonDeserializer<Session> {
        /*
         * WARNING - void declaration
         */
        @Override
        private Session deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            void var3_3;
            reader.beginObject();
            Date started = null;
            Date timestamp = null;
            Integer errorCount = null;
            String distinctId = null;
            UUID sessionId = null;
            Boolean init = null;
            State status = null;
            Long sequence = null;
            Double duration = null;
            String ipAddress = null;
            String userAgent = null;
            String environment = null;
            String release = null;
            String abnormalMechanism = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block40: while (reader.peek() == JsonToken.NAME) {
                String statusValue;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "sid": {
                        String sidString = null;
                        try {
                            sidString = reader.nextStringOrNull();
                            sessionId = UUID.fromString(sidString);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            logger.log(SentryLevel.ERROR, "%s sid is not valid.", sidString);
                        }
                        continue block40;
                    }
                    case "did": {
                        distinctId = reader.nextStringOrNull();
                        continue block40;
                    }
                    case "init": {
                        init = reader.nextBooleanOrNull();
                        continue block40;
                    }
                    case "started": {
                        started = reader.nextDateOrNull(logger);
                        continue block40;
                    }
                    case "status": {
                        statusValue = StringUtils.capitalize(reader.nextStringOrNull());
                        if (statusValue == null) continue block40;
                        status = State.valueOf(statusValue);
                        continue block40;
                    }
                    case "seq": {
                        sequence = reader.nextLongOrNull();
                        continue block40;
                    }
                    case "errors": {
                        errorCount = reader.nextIntegerOrNull();
                        continue block40;
                    }
                    case "duration": {
                        duration = reader.nextDoubleOrNull();
                        continue block40;
                    }
                    case "timestamp": {
                        timestamp = reader.nextDateOrNull(logger);
                        continue block40;
                    }
                    case "abnormal_mechanism": {
                        abnormalMechanism = reader.nextStringOrNull();
                        continue block40;
                    }
                    case "attrs": {
                        reader.beginObject();
                        block41: while (reader.peek() == JsonToken.NAME) {
                            switch (reader.nextName()) {
                                case "release": {
                                    release = reader.nextStringOrNull();
                                    continue block41;
                                }
                                case "environment": {
                                    environment = reader.nextStringOrNull();
                                    continue block41;
                                }
                                case "ip_address": {
                                    ipAddress = reader.nextStringOrNull();
                                    continue block41;
                                }
                                case "user_agent": {
                                    userAgent = reader.nextStringOrNull();
                                    continue block41;
                                }
                            }
                            reader.skipValue();
                        }
                        reader.endObject();
                        continue block40;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, statusValue);
            }
            if (status == null) {
                throw Deserializer.missingRequiredFieldException("status", logger);
            }
            if (started == null) {
                throw Deserializer.missingRequiredFieldException("started", logger);
            }
            if (errorCount == null) {
                throw Deserializer.missingRequiredFieldException("errors", logger);
            }
            if (release == null) {
                void var2_2;
                throw Deserializer.missingRequiredFieldException("release", (ILogger)var2_2);
            }
            Session session = new Session(status, (Date)var3_3, timestamp, errorCount, distinctId, sessionId, init, sequence, duration, ipAddress, userAgent, environment, release, abnormalMechanism);
            session.setUnknown(unknown);
            var1_1.endObject();
            return session;
        }

        /*
         * WARNING - void declaration
         */
        private static Exception missingRequiredFieldException(String field, ILogger logger) {
            void var2_2;
            String string;
            void var1_1;
            String message = "Missing required field \"" + field + "\"";
            IllegalStateException exception = new IllegalStateException(message);
            var1_1.log(SentryLevel.ERROR, string, exception);
            return var2_2;
        }
    }
}

