/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.AsyncHttpTransportFactory;
import io.sentry.DiagnosticLogger;
import io.sentry.Dsn;
import io.sentry.DuplicateEventDetectionEventProcessor;
import io.sentry.EnvelopeReader;
import io.sentry.EventProcessor;
import io.sentry.ExperimentalOptions;
import io.sentry.ExternalOptions;
import io.sentry.FullyDisplayedReporter;
import io.sentry.Hint;
import io.sentry.IConnectionStatusProvider;
import io.sentry.IEnvelopeReader;
import io.sentry.ILogger;
import io.sentry.IOptionsObserver;
import io.sentry.IScopeObserver;
import io.sentry.ISentryExecutorService;
import io.sentry.ISerializer;
import io.sentry.ITransactionProfiler;
import io.sentry.ITransportFactory;
import io.sentry.Instrumenter;
import io.sentry.Integration;
import io.sentry.JavaMemoryCollector;
import io.sentry.JsonSerializer;
import io.sentry.MainEventProcessor;
import io.sentry.NoOpConnectionStatusProvider;
import io.sentry.NoOpLogger;
import io.sentry.NoOpReplayController;
import io.sentry.NoOpSentryExecutorService;
import io.sentry.NoOpTransactionPerformanceCollector;
import io.sentry.NoOpTransactionProfiler;
import io.sentry.NoOpTransportFactory;
import io.sentry.ReplayController;
import io.sentry.SentryAutoDateProvider;
import io.sentry.SentryDateProvider;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEvent;
import io.sentry.SentryExecutorService;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryRuntimeEventProcessor;
import io.sentry.ShutdownHookIntegration;
import io.sentry.SpotlightIntegration;
import io.sentry.SystemOutLogger;
import io.sentry.TransactionPerformanceCollector;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.backpressure.BackpressureMonitor;
import io.sentry.backpressure.IBackpressureMonitor;
import io.sentry.backpressure.NoOpBackpressureMonitor;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.clientreport.ClientReportRecorder;
import io.sentry.clientreport.IClientReportRecorder;
import io.sentry.clientreport.NoOpClientReportRecorder;
import io.sentry.internal.debugmeta.IDebugMetaLoader;
import io.sentry.internal.debugmeta.NoOpDebugMetaLoader;
import io.sentry.internal.debugmeta.ResourcesDebugMetaLoader;
import io.sentry.internal.modules.IModulesLoader;
import io.sentry.internal.modules.NoOpModulesLoader;
import io.sentry.protocol.SdkVersion;
import io.sentry.transport.ITransportGate;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.transport.NoOpTransportGate;
import io.sentry.util.LazyEvaluator;
import io.sentry.util.Platform;
import io.sentry.util.SampleRateUtils;
import io.sentry.util.StringUtils;
import io.sentry.util.thread.IMainThreadChecker;
import io.sentry.util.thread.MainThreadChecker;
import io.sentry.util.thread.NoOpMainThreadChecker;
import java.io.File;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.net.ssl.SSLSocketFactory;

public final class SentryOptions {
    static final SentryLevel DEFAULT_DIAGNOSTIC_LEVEL = SentryLevel.DEBUG;
    private final List<EventProcessor> eventProcessors = new CopyOnWriteArrayList<EventProcessor>();
    private final Set<Class<? extends Throwable>> ignoredExceptionsForType = new CopyOnWriteArraySet<Class<? extends Throwable>>();
    private final List<Integration> integrations = new CopyOnWriteArrayList<Integration>();
    private final Set<String> bundleIds = new CopyOnWriteArraySet<String>();
    private String dsn;
    private final LazyEvaluator<Dsn> parsedDsn = new LazyEvaluator<Dsn>(() -> new Dsn(this.dsn));
    private String dsnHash;
    private long shutdownTimeoutMillis = 2000L;
    private long flushTimeoutMillis = 15000L;
    private long sessionFlushTimeoutMillis = 15000L;
    private boolean debug;
    private ILogger logger = NoOpLogger.getInstance();
    private SentryLevel diagnosticLevel = DEFAULT_DIAGNOSTIC_LEVEL;
    private final LazyEvaluator<ISerializer> serializer = new LazyEvaluator<ISerializer>(() -> new JsonSerializer(this));
    private final LazyEvaluator<IEnvelopeReader> envelopeReader = new LazyEvaluator<IEnvelopeReader>(() -> new EnvelopeReader(this.serializer.getValue()));
    private int maxDepth = 100;
    private String sentryClientName;
    private BeforeSendCallback beforeSend;
    private BeforeBreadcrumbCallback beforeBreadcrumb;
    private String cacheDirPath;
    private int maxCacheItems;
    private int maxQueueSize = this.maxCacheItems = 30;
    private int maxBreadcrumbs = 100;
    private String release;
    private String environment;
    private Proxy proxy;
    private Double sampleRate;
    private Boolean enableTracing;
    private Double tracesSampleRate;
    private TracesSamplerCallback tracesSampler;
    private final List<String> inAppExcludes = new CopyOnWriteArrayList<String>();
    private final List<String> inAppIncludes = new CopyOnWriteArrayList<String>();
    private ITransportFactory transportFactory = NoOpTransportFactory.getInstance();
    private ITransportGate transportGate = NoOpTransportGate.getInstance();
    private String dist;
    private boolean attachThreads;
    private boolean attachStacktrace = true;
    private boolean enableAutoSessionTracking = true;
    private long sessionTrackingIntervalMillis = 30000L;
    private String serverName;
    private boolean attachServerName = true;
    private boolean enableUncaughtExceptionHandler = true;
    private boolean printUncaughtStackTrace = false;
    private ISentryExecutorService executorService = NoOpSentryExecutorService.getInstance$6fecc271();
    private int connectionTimeoutMillis = 5000;
    private int readTimeoutMillis = 5000;
    private IEnvelopeCache envelopeDiskCache = NoOpEnvelopeCache.getInstance();
    private SdkVersion sdkVersion;
    private boolean sendDefaultPii = false;
    private SSLSocketFactory sslSocketFactory;
    private final List<IScopeObserver> observers = new CopyOnWriteArrayList<IScopeObserver>();
    private final List<IOptionsObserver> optionsObservers = new CopyOnWriteArrayList<IOptionsObserver>();
    private boolean enableExternalConfiguration;
    private final Map<String, String> tags = new ConcurrentHashMap<String, String>();
    private long maxAttachmentSize = 0x1400000L;
    private boolean enableDeduplication = true;
    private int maxSpans = 1000;
    private boolean enableShutdownHook = true;
    private RequestSize maxRequestBodySize = RequestSize.NONE;
    private boolean traceSampling = true;
    private Double profilesSampleRate;
    private ProfilesSamplerCallback profilesSampler;
    private long maxTraceFileSize = 0x500000L;
    private ITransactionProfiler transactionProfiler = NoOpTransactionProfiler.getInstance();
    private List<String> tracePropagationTargets = null;
    private final List<String> defaultTracePropagationTargets = Collections.singletonList(".*");
    private String proguardUuid;
    private Long idleTimeout = 3000L;
    private final List<String> contextTags = new CopyOnWriteArrayList<String>();
    private boolean sendClientReports = true;
    IClientReportRecorder clientReportRecorder = new ClientReportRecorder(this);
    private IModulesLoader modulesLoader = NoOpModulesLoader.getInstance();
    private IDebugMetaLoader debugMetaLoader = NoOpDebugMetaLoader.getInstance();
    private boolean enableUserInteractionTracing = false;
    private boolean enableUserInteractionBreadcrumbs = true;
    private Instrumenter instrumenter = Instrumenter.SENTRY;
    private final List<Object> gestureTargetLocators = new ArrayList<Object>();
    private final List<Object> viewHierarchyExporters = new ArrayList<Object>();
    private IMainThreadChecker mainThreadChecker = NoOpMainThreadChecker.getInstance();
    private boolean traceOptionsRequests = true;
    private final LazyEvaluator<SentryDateProvider> dateProvider = new LazyEvaluator<SentryDateProvider>(() -> new SentryAutoDateProvider());
    private final List<Object> performanceCollectors = new ArrayList<Object>();
    private TransactionPerformanceCollector transactionPerformanceCollector = NoOpTransactionPerformanceCollector.getInstance();
    private boolean enableTimeToFullDisplayTracing = false;
    private FullyDisplayedReporter fullyDisplayedReporter = FullyDisplayedReporter.getInstance();
    private IConnectionStatusProvider connectionStatusProvider = new NoOpConnectionStatusProvider();
    private boolean enabled = true;
    private boolean enablePrettySerializationOutput = true;
    private boolean sendModules = true;
    private BeforeEnvelopeCallback beforeEnvelopeCallback;
    private boolean enableSpotlight = false;
    private String spotlightConnectionUrl;
    private boolean enableScopePersistence = true;
    private List<String> ignoredCheckIns = null;
    private IBackpressureMonitor backpressureMonitor = NoOpBackpressureMonitor.getInstance();
    private boolean enableBackpressureHandling = true;
    private boolean enableAppStartProfiling = false;
    private boolean enableMetrics = false;
    private boolean enableDefaultTagsForMetrics = true;
    private boolean enableSpanLocalMetricAggregation = true;
    private BeforeEmitMetricCallback beforeEmitMetricCallback = null;
    private int profilingTracesHz = 101;
    private Cron cron = null;
    private final ExperimentalOptions experimental;
    private ReplayController replayController = NoOpReplayController.getInstance();
    private boolean enableScreenTracking = true;

    public final List<EventProcessor> getEventProcessors() {
        return this.eventProcessors;
    }

    public final List<Integration> getIntegrations() {
        return this.integrations;
    }

    public final String getDsn() {
        return this.dsn;
    }

    final Dsn getParsedDsn() throws IllegalArgumentException {
        return this.parsedDsn.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setDsn(String dsn) {
        void var1_1;
        this.dsn = var1_1;
        this.parsedDsn.resetValue();
        this.dsnHash = StringUtils.calculateStringHash(this.dsn, this.logger);
    }

    public final boolean isDebug() {
        return this.debug;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDebug(boolean debug) {
        void var1_1;
        this.debug = var1_1;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLogger$1c54ab9a(SystemOutLogger logger) {
        void var1_1;
        this.logger = new DiagnosticLogger(this, (ILogger)var1_1);
    }

    public final SentryLevel getDiagnosticLevel() {
        return this.diagnosticLevel;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDiagnosticLevel(SentryLevel diagnosticLevel) {
        void var1_1;
        this.diagnosticLevel = diagnosticLevel != null ? var1_1 : DEFAULT_DIAGNOSTIC_LEVEL;
    }

    public final ISerializer getSerializer() {
        return this.serializer.getValue();
    }

    public final int getMaxDepth() {
        return this.maxDepth;
    }

    public final IEnvelopeReader getEnvelopeReader() {
        return this.envelopeReader.getValue();
    }

    public final long getShutdownTimeoutMillis() {
        return this.shutdownTimeoutMillis;
    }

    public final String getSentryClientName() {
        return this.sentryClientName;
    }

    public final BeforeSendCallback getBeforeSend() {
        return this.beforeSend;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBeforeSend(BeforeSendCallback beforeSend) {
        void var1_1;
        this.beforeSend = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBeforeBreadcrumb(BeforeBreadcrumbCallback beforeBreadcrumb) {
        void var1_1;
        this.beforeBreadcrumb = var1_1;
    }

    public final String getCacheDirPath() {
        if (this.cacheDirPath == null || this.cacheDirPath.isEmpty()) {
            return null;
        }
        if (this.dsnHash != null) {
            return new File(this.cacheDirPath, this.dsnHash).getAbsolutePath();
        }
        return this.cacheDirPath;
    }

    final String getCacheDirPathWithoutDsn() {
        if (this.cacheDirPath == null || this.cacheDirPath.isEmpty()) {
            return null;
        }
        return this.cacheDirPath;
    }

    public final int getMaxBreadcrumbs() {
        return this.maxBreadcrumbs;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMaxBreadcrumbs(int maxBreadcrumbs) {
        void var1_1;
        this.maxBreadcrumbs = var1_1;
    }

    public final String getRelease() {
        return this.release;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRelease(String release) {
        void var1_1;
        this.release = var1_1;
    }

    public final String getEnvironment() {
        if (this.environment != null) {
            return this.environment;
        }
        return "production";
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnvironment(String environment) {
        void var1_1;
        this.environment = var1_1;
    }

    public final Proxy getProxy() {
        return this.proxy;
    }

    public final Double getSampleRate() {
        return this.sampleRate;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSampleRate(Double sampleRate) {
        void var1_1;
        if (!SampleRateUtils.isValidSampleRate(sampleRate)) {
            throw new IllegalArgumentException("The value " + sampleRate + " is not valid. Use null to disable or values >= 0.0 and <= 1.0.");
        }
        this.sampleRate = var1_1;
    }

    @Deprecated
    public final Boolean getEnableTracing() {
        return this.enableTracing;
    }

    public final Double getTracesSampleRate() {
        return this.tracesSampleRate;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTracesSampleRate(Double tracesSampleRate) {
        void var1_1;
        Double d = tracesSampleRate;
        if (!SampleRateUtils.isValidTracesSampleRate(d, true)) {
            throw new IllegalArgumentException("The value " + tracesSampleRate + " is not valid. Use null to disable or values between 0.0 and 1.0.");
        }
        this.tracesSampleRate = var1_1;
    }

    public final TracesSamplerCallback getTracesSampler() {
        return this.tracesSampler;
    }

    public final List<String> getInAppExcludes() {
        return this.inAppExcludes;
    }

    public final List<String> getInAppIncludes() {
        return this.inAppIncludes;
    }

    public final ITransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransportFactory$3a022769(AsyncHttpTransportFactory transportFactory) {
        void var1_1;
        this.transportFactory = var1_1;
    }

    public final String getDist() {
        return this.dist;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDist(String dist) {
        void var1_1;
        this.dist = var1_1;
    }

    public final ITransportGate getTransportGate() {
        return this.transportGate;
    }

    public final boolean isAttachStacktrace() {
        return this.attachStacktrace;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAttachStacktrace(boolean attachStacktrace) {
        void var1_1;
        this.attachStacktrace = var1_1;
    }

    public final boolean isAttachThreads() {
        return this.attachThreads;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAttachThreads(boolean attachThreads) {
        void var1_1;
        this.attachThreads = var1_1;
    }

    public final boolean isEnableAutoSessionTracking() {
        return this.enableAutoSessionTracking;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnableAutoSessionTracking(boolean enableAutoSessionTracking) {
        void var1_1;
        this.enableAutoSessionTracking = var1_1;
    }

    public final String getServerName() {
        return this.serverName;
    }

    public final boolean isAttachServerName() {
        return this.attachServerName;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSessionTrackingIntervalMillis(long sessionTrackingIntervalMillis) {
        void var1_1;
        this.sessionTrackingIntervalMillis = var1_1;
    }

    public final long getFlushTimeoutMillis() {
        return this.flushTimeoutMillis;
    }

    public final boolean isEnableUncaughtExceptionHandler() {
        return this.enableUncaughtExceptionHandler;
    }

    public final boolean isPrintUncaughtStackTrace() {
        return this.printUncaughtStackTrace;
    }

    public final ISentryExecutorService getExecutorService() {
        return this.executorService;
    }

    /*
     * WARNING - void declaration
     */
    public final void setExecutorService$7056313d(SentryExecutorService executorService) {
        void var1_1;
        this.executorService = var1_1;
    }

    public final int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public final int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public final IEnvelopeCache getEnvelopeDiskCache() {
        return this.envelopeDiskCache;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnvelopeDiskCache(IEnvelopeCache envelopeDiskCache) {
        void var1_1;
        this.envelopeDiskCache = envelopeDiskCache != null ? var1_1 : NoOpEnvelopeCache.getInstance();
    }

    public final int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public final SdkVersion getSdkVersion() {
        return this.sdkVersion;
    }

    public final SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public final List<IScopeObserver> getScopeObservers() {
        return this.observers;
    }

    public final List<IOptionsObserver> getOptionsObservers() {
        return this.optionsObservers;
    }

    public final boolean isEnableExternalConfiguration() {
        return this.enableExternalConfiguration;
    }

    public final Map<String, String> getTags() {
        return this.tags;
    }

    public final long getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMaxAttachmentSize(long maxAttachmentSize) {
        void var1_1;
        this.maxAttachmentSize = var1_1;
    }

    public final boolean isEnableDeduplication() {
        return this.enableDeduplication;
    }

    public final boolean isTracingEnabled() {
        block5: {
            block4: {
                if (this.enableTracing != null) {
                    return this.enableTracing;
                }
                SentryOptions sentryOptions = this;
                if (sentryOptions.tracesSampleRate != null) break block4;
                sentryOptions = this;
                if (sentryOptions.tracesSampler == null) break block5;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final boolean containsIgnoredExceptionForType(Throwable throwable) {
        void var1_1;
        return this.ignoredExceptionsForType.contains(var1_1.getClass());
    }

    public final boolean isEnableShutdownHook() {
        return this.enableShutdownHook;
    }

    public final int getMaxCacheItems() {
        return this.maxCacheItems;
    }

    public final long getMaxTraceFileSize() {
        return this.maxTraceFileSize;
    }

    public final ITransactionProfiler getTransactionProfiler() {
        return this.transactionProfiler;
    }

    public final boolean isProfilingEnabled() {
        block4: {
            block3: {
                SentryOptions sentryOptions;
                block2: {
                    sentryOptions = this;
                    if (sentryOptions.profilesSampleRate == null) break block2;
                    sentryOptions = this;
                    if (sentryOptions.profilesSampleRate > 0.0) break block3;
                }
                sentryOptions = this;
                if (sentryOptions.profilesSampler == null) break block4;
            }
            return true;
        }
        return false;
    }

    public final ProfilesSamplerCallback getProfilesSampler() {
        return this.profilesSampler;
    }

    public final Double getProfilesSampleRate() {
        return this.profilesSampleRate;
    }

    /*
     * WARNING - void declaration
     */
    public final String getProfilingTracesDirPath() {
        void var1_1;
        String cacheDirPath = this.getCacheDirPath();
        if (cacheDirPath == null) {
            return null;
        }
        return new File((String)var1_1, "profiling_traces").getAbsolutePath();
    }

    public final String getProguardUuid() {
        return this.proguardUuid;
    }

    /*
     * WARNING - void declaration
     */
    public final void setProguardUuid(String proguardUuid) {
        void var1_1;
        this.proguardUuid = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void addBundleId(String bundleId) {
        String trimmedBundleId;
        if (bundleId != null && !(trimmedBundleId = bundleId.trim()).isEmpty()) {
            void var1_1;
            this.bundleIds.add((String)var1_1);
        }
    }

    public final Set<String> getBundleIds() {
        return this.bundleIds;
    }

    public final IClientReportRecorder getClientReportRecorder() {
        return this.clientReportRecorder;
    }

    public final IModulesLoader getModulesLoader() {
        return this.modulesLoader;
    }

    /*
     * WARNING - void declaration
     */
    public final void setModulesLoader(IModulesLoader modulesLoader) {
        void var1_1;
        this.modulesLoader = modulesLoader != null ? var1_1 : NoOpModulesLoader.getInstance();
    }

    public final IDebugMetaLoader getDebugMetaLoader() {
        return this.debugMetaLoader;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDebugMetaLoader$36e8bc88(ResourcesDebugMetaLoader debugMetaLoader) {
        void var1_1;
        this.debugMetaLoader = var1_1;
    }

    public final IMainThreadChecker getMainThreadChecker() {
        return this.mainThreadChecker;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMainThreadChecker$28b81ffc(MainThreadChecker mainThreadChecker) {
        void var1_1;
        this.mainThreadChecker = var1_1;
    }

    public final TransactionPerformanceCollector getTransactionPerformanceCollector() {
        return this.transactionPerformanceCollector;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean isEnablePrettySerializationOutput() {
        return this.enablePrettySerializationOutput;
    }

    public final boolean isSendModules() {
        return this.sendModules;
    }

    public final boolean isEnableAppStartProfiling() {
        return this.isProfilingEnabled() && this.enableAppStartProfiling;
    }

    public final SentryDateProvider getDateProvider() {
        return this.dateProvider.getValue();
    }

    public final void addPerformanceCollector$71cb9fb3(JavaMemoryCollector javaMemoryCollector) {
        this.performanceCollectors.add(javaMemoryCollector);
    }

    public final List<Object> getPerformanceCollectors() {
        return this.performanceCollectors;
    }

    public final IBackpressureMonitor getBackpressureMonitor() {
        return this.backpressureMonitor;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBackpressureMonitor$434665d5(BackpressureMonitor backpressureMonitor) {
        void var1_1;
        this.backpressureMonitor = var1_1;
    }

    public final int getProfilingTracesHz() {
        return this.profilingTracesHz;
    }

    public final boolean isEnableBackpressureHandling() {
        return this.enableBackpressureHandling;
    }

    public final long getSessionFlushTimeoutMillis() {
        return this.sessionFlushTimeoutMillis;
    }

    public final BeforeEnvelopeCallback getBeforeEnvelopeCallback() {
        return this.beforeEnvelopeCallback;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBeforeEnvelopeCallback$19b2053c(SpotlightIntegration beforeEnvelopeCallback) {
        void var1_1;
        this.beforeEnvelopeCallback = var1_1;
    }

    public final String getSpotlightConnectionUrl() {
        return this.spotlightConnectionUrl;
    }

    public final boolean isEnableSpotlight() {
        return this.enableSpotlight;
    }

    public final boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public final BeforeEmitMetricCallback getBeforeEmitMetricCallback() {
        return this.beforeEmitMetricCallback;
    }

    public final ExperimentalOptions getExperimental() {
        return this.experimental;
    }

    public final ReplayController getReplayController() {
        return this.replayController;
    }

    public static SentryOptions empty() {
        return new SentryOptions(true);
    }

    public SentryOptions() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    private SentryOptions(boolean empty) {
        void var1_1;
        this.experimental = new ExperimentalOptions(empty);
        if (var1_1 == false) {
            this.executorService = new SentryExecutorService();
            this.integrations.add(new UncaughtExceptionHandlerIntegration());
            this.integrations.add(new ShutdownHookIntegration());
            this.integrations.add(new SpotlightIntegration());
            this.eventProcessors.add(new MainEventProcessor(this));
            this.eventProcessors.add(new DuplicateEventDetectionEventProcessor(this));
            if (Platform.isJvm()) {
                this.eventProcessors.add(new SentryRuntimeEventProcessor());
            }
            Object object = "sentry.java/7.16.0";
            Object object2 = this;
            this.sentryClientName = object;
            object2 = new SdkVersion("sentry.java", "7.16.0");
            ((SdkVersion)object2).setVersion("7.16.0");
            object = object2;
            object2 = this;
            this.sdkVersion = object;
            SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry", "7.16.0");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void merge(ExternalOptions options) {
        SentryOptions sentryOptions;
        Object object;
        if (options.getDsn() != null) {
            this.setDsn(options.getDsn());
        }
        if (options.getEnvironment() != null) {
            String string = options.getEnvironment();
            SentryOptions sentryOptions2 = this;
            this.environment = string;
        }
        if (options.getRelease() != null) {
            String bl = options.getRelease();
            SentryOptions sentryOptions3 = this;
            this.release = bl;
        }
        if (options.getDist() != null) {
            String iterator = options.getDist();
            SentryOptions sentryOptions4 = this;
            this.dist = iterator;
        }
        if (options.getServerName() != null) {
            object = options.getServerName();
            sentryOptions = this;
            this.serverName = object;
        }
        if (options.getProxy() != null) {
            object = options.getProxy();
            sentryOptions = this;
            this.proxy = object;
        }
        if (options.getEnableUncaughtExceptionHandler() != null) {
            boolean bl = options.getEnableUncaughtExceptionHandler();
            sentryOptions = this;
            this.enableUncaughtExceptionHandler = bl;
        }
        if (options.getPrintUncaughtStackTrace() != null) {
            boolean bl = options.getPrintUncaughtStackTrace();
            sentryOptions = this;
            this.printUncaughtStackTrace = bl;
        }
        if (options.getEnableTracing() != null) {
            Boolean bl = options.getEnableTracing();
            sentryOptions = this;
            this.enableTracing = bl;
        }
        if (options.getTracesSampleRate() != null) {
            this.setTracesSampleRate(options.getTracesSampleRate());
        }
        if (options.getProfilesSampleRate() != null) {
            Double d = options.getProfilesSampleRate();
            sentryOptions = this;
            if (!SampleRateUtils.isValidProfilesSampleRate(d)) {
                throw new IllegalArgumentException("The value " + d + " is not valid. Use null to disable or values between 0.0 and 1.0.");
            }
            sentryOptions.profilesSampleRate = d;
        }
        if (options.getDebug() != null) {
            boolean bl = options.getDebug();
            SentryOptions sentryOptions5 = this;
            this.debug = bl;
        }
        if (options.getEnableDeduplication() != null) {
            boolean bl = options.getEnableDeduplication();
            sentryOptions = this;
            this.enableDeduplication = bl;
        }
        if (options.getSendClientReports() != null) {
            boolean bl = options.getSendClientReports();
            sentryOptions = this;
            this.sendClientReports = bl;
            sentryOptions.clientReportRecorder = bl ? new ClientReportRecorder(sentryOptions) : new NoOpClientReportRecorder();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(options.getTags());
        for (Map.Entry entry : hashMap.entrySet()) {
            this.tags.put((String)entry.getKey(), (String)entry.getValue());
        }
        ArrayList<String> arrayList = new ArrayList<String>(options.getInAppIncludes());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = (String)iterator.next();
            sentryOptions = this;
            sentryOptions.inAppIncludes.add(string2);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(options.getInAppExcludes());
        Iterator iterator2 = arrayList2.iterator();
        while (iterator2.hasNext()) {
            String string;
            String string3 = string = (String)iterator2.next();
            sentryOptions = this;
            sentryOptions.inAppExcludes.add(string3);
        }
        Iterator<Class<? extends Throwable>> iterator3 = new HashSet<Class<? extends Throwable>>(options.getIgnoredExceptionsForType()).iterator();
        while (iterator3.hasNext()) {
            Class<? extends Throwable> clazz;
            Class<? extends Throwable> clazz2 = clazz = iterator3.next();
            sentryOptions = this;
            sentryOptions.ignoredExceptionsForType.add(clazz2);
        }
        if (options.getTracePropagationTargets() != null) {
            ArrayList<String> arrayList3 = new ArrayList<String>(options.getTracePropagationTargets());
            Object object2 = arrayList3;
            sentryOptions = this;
            ArrayList<String> arrayList4 = new ArrayList<String>();
            Iterator iterator4 = object2.iterator();
            while (iterator4.hasNext()) {
                object2 = (String)iterator4.next();
                if (((String)object2).isEmpty()) continue;
                arrayList4.add((String)object2);
            }
            sentryOptions.tracePropagationTargets = arrayList4;
        }
        ArrayList<String> arrayList5 = new ArrayList<String>(options.getContextTags());
        Iterator iterator5 = arrayList5.iterator();
        while (iterator5.hasNext()) {
            String string;
            String string4 = string = (String)iterator5.next();
            sentryOptions = this;
            sentryOptions.contextTags.add(string4);
        }
        if (options.getProguardUuid() != null) {
            String string = options.getProguardUuid();
            SentryOptions sentryOptions6 = this;
            this.proguardUuid = string;
        }
        if (options.getIdleTimeout() != null) {
            Long l = options.getIdleTimeout();
            sentryOptions = this;
            this.idleTimeout = l;
        }
        for (String string : options.getBundleIds()) {
            this.addBundleId(string);
        }
        if (options.isEnabled() != null) {
            boolean bl = options.isEnabled();
            sentryOptions = this;
            this.enabled = bl;
        }
        if (options.isEnablePrettySerializationOutput() != null) {
            boolean bl = options.isEnablePrettySerializationOutput();
            sentryOptions = this;
            this.enablePrettySerializationOutput = bl;
        }
        if (options.isSendModules() != null) {
            boolean bl = options.isSendModules();
            sentryOptions = this;
            this.sendModules = bl;
        }
        if (options.getIgnoredCheckIns() != null) {
            ArrayList<String> arrayList6 = new ArrayList<String>(options.getIgnoredCheckIns());
            Object object3 = arrayList6;
            sentryOptions = this;
            ArrayList<String> arrayList7 = new ArrayList<String>();
            Iterator iterator6 = object3.iterator();
            while (iterator6.hasNext()) {
                object3 = (String)iterator6.next();
                if (((String)object3).isEmpty()) continue;
                arrayList7.add((String)object3);
            }
            sentryOptions.ignoredCheckIns = arrayList7;
        }
        if (options.isEnableBackpressureHandling() != null) {
            boolean bl = options.isEnableBackpressureHandling();
            sentryOptions = this;
            this.enableBackpressureHandling = bl;
        }
        if (options.getCron() != null) {
            SentryOptions sentryOptions7 = this;
            if (sentryOptions7.cron == null) {
                Cron cron = options.getCron();
                sentryOptions = this;
                this.cron = cron;
                return;
            }
            if (options.getCron().getDefaultCheckinMargin() != null) {
                SentryOptions sentryOptions8 = this;
                sentryOptions8.cron.setDefaultCheckinMargin(options.getCron().getDefaultCheckinMargin());
            }
            if (options.getCron().getDefaultMaxRuntime() != null) {
                SentryOptions sentryOptions9 = this;
                sentryOptions9.cron.setDefaultMaxRuntime(options.getCron().getDefaultMaxRuntime());
            }
            if (options.getCron().getDefaultTimezone() != null) {
                SentryOptions sentryOptions10 = this;
                sentryOptions10.cron.setDefaultTimezone(options.getCron().getDefaultTimezone());
            }
            if (options.getCron().getDefaultFailureIssueThreshold() != null) {
                SentryOptions sentryOptions11 = this;
                sentryOptions11.cron.setDefaultFailureIssueThreshold(options.getCron().getDefaultFailureIssueThreshold());
            }
            if (options.getCron().getDefaultRecoveryThreshold() != null) {
                void var1_1;
                SentryOptions sentryOptions12 = this;
                sentryOptions12.cron.setDefaultRecoveryThreshold(var1_1.getCron().getDefaultRecoveryThreshold());
            }
        }
    }

    public static interface BeforeSendCallback {
        public SentryEvent execute(SentryEvent var1, Hint var2);
    }

    public static interface BeforeBreadcrumbCallback {
    }

    public static final class Proxy {
        private String host;
        private String port;
        private String user;
        private String pass;
        private Proxy.Type type;

        public Proxy() {
            this(null, null, null, null, null);
        }

        /*
         * WARNING - void declaration
         */
        public Proxy(String host, String port, String user, String pass) {
            this((String)var1_1, (String)var2_2, null, (String)var3_3, pass);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private Proxy(String host, String port, Proxy.Type type, String user, String pass) {
            void var2_2;
            void var1_1;
            this.host = var1_1;
            this.port = var2_2;
            this.type = null;
            this.user = user;
            this.pass = pass;
        }

        public final String getHost() {
            return this.host;
        }

        public final String getPort() {
            return this.port;
        }

        public final String getUser() {
            return this.user;
        }

        public final String getPass() {
            return this.pass;
        }

        public final Proxy.Type getType() {
            return this.type;
        }
    }

    public static interface TracesSamplerCallback {
        public Double sample$7bdd8675();
    }

    public static enum RequestSize {
        NONE,
        SMALL,
        MEDIUM,
        ALWAYS;

    }

    public static interface ProfilesSamplerCallback {
        public Double sample$7bdd8675();
    }

    public static interface BeforeEnvelopeCallback {
        public void execute$74b70ef(SentryEnvelope var1);
    }

    public static interface BeforeEmitMetricCallback {
    }

    public static final class Cron {
        private Long defaultCheckinMargin;
        private Long defaultMaxRuntime;
        private String defaultTimezone;
        private Long defaultFailureIssueThreshold;
        private Long defaultRecoveryThreshold;

        public final Long getDefaultCheckinMargin() {
            return this.defaultCheckinMargin;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDefaultCheckinMargin(Long defaultCheckinMargin) {
            void var1_1;
            this.defaultCheckinMargin = var1_1;
        }

        public final Long getDefaultMaxRuntime() {
            return this.defaultMaxRuntime;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDefaultMaxRuntime(Long defaultMaxRuntime) {
            void var1_1;
            this.defaultMaxRuntime = var1_1;
        }

        public final String getDefaultTimezone() {
            return this.defaultTimezone;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDefaultTimezone(String defaultTimezone) {
            void var1_1;
            this.defaultTimezone = var1_1;
        }

        public final Long getDefaultFailureIssueThreshold() {
            return this.defaultFailureIssueThreshold;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDefaultFailureIssueThreshold(Long defaultFailureIssueThreshold) {
            void var1_1;
            this.defaultFailureIssueThreshold = var1_1;
        }

        public final Long getDefaultRecoveryThreshold() {
            return this.defaultRecoveryThreshold;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDefaultRecoveryThreshold(Long defaultRecoveryThreshold) {
            void var1_1;
            this.defaultRecoveryThreshold = var1_1;
        }
    }
}

