/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.AsyncHttpTransportFactory;
import io.sentry.Attachment;
import io.sentry.BackfillingEventProcessor;
import io.sentry.Baggage;
import io.sentry.Breadcrumb;
import io.sentry.DataCategory;
import io.sentry.DateUtils;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.IMetricsAggregator;
import io.sentry.IScope;
import io.sentry.ISentryClient;
import io.sentry.ITransportFactory;
import io.sentry.MetricsAggregator;
import io.sentry.NoOpTransportFactory;
import io.sentry.ProfilingTraceData;
import io.sentry.RequestDetailsResolver;
import io.sentry.Scope;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeHeader;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.SpanStatus;
import io.sentry.TraceContext;
import io.sentry.TransactionContext;
import io.sentry.clientreport.DiscardReason;
import io.sentry.exception.SentryEnvelopeException;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.Backfillable;
import io.sentry.hints.DiskFlushNotification;
import io.sentry.hints.TransactionEnd;
import io.sentry.metrics.EncodedMetrics;
import io.sentry.metrics.IMetricsClient;
import io.sentry.metrics.NoopMetricsAggregator;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.SentryId;
import io.sentry.transport.ITransport;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import io.sentry.util.Random;
import io.sentry.util.TracingUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SentryClient
implements ISentryClient,
IMetricsClient {
    private boolean enabled;
    private final SentryOptions options;
    private final ITransport transport;
    private final Random random;
    private final SortBreadcrumbsByDate sortBreadcrumbsByDate = new SortBreadcrumbsByDate(0);
    private final IMetricsAggregator metricsAggregator;

    /*
     * WARNING - void declaration
     */
    SentryClient(SentryOptions options) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.options = Objects.requireNonNull(options, "SentryOptions is required.");
        this.enabled = true;
        ITransportFactory transportFactory = options.getTransportFactory();
        if (transportFactory instanceof NoOpTransportFactory) {
            transportFactory = new AsyncHttpTransportFactory();
            options.setTransportFactory$3a022769((AsyncHttpTransportFactory)transportFactory);
        }
        RequestDetailsResolver requestDetailsResolver = new RequestDetailsResolver(options);
        this.transport = var2_2.create(options, var3_3.resolve());
        this.metricsAggregator = options.isEnableMetrics() ? new MetricsAggregator(options, this) : NoopMetricsAggregator.getInstance();
        this.random = var1_1.getSampleRate() == null ? null : new Random();
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldApplyScopeData(SentryBaseEvent event, Hint hint) {
        void var1_1;
        if (HintUtils.shouldApplyScopeData(hint)) {
            return true;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying scope: %s", var1_1.getEventId());
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final SentryId captureEvent(SentryEvent event, IScope scope, Hint hint) {
        Objects.requireNonNull(event, "SentryEvent is required.");
        if (hint == null) {
            hint = new Hint();
        }
        if (this.shouldApplyScopeData(event, hint)) {
            SentryClient.addScopeAttachmentsToHint(scope, hint);
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Capturing event: %s", new Object[]{event.getEventId()});
        if (event != null && (eventThrowable = event.getThrowable()) != null && this.options.containsIgnoredExceptionForType(eventThrowable)) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped as the exception %s is ignored", new Object[]{eventThrowable.getClass()});
            var6_7 = this.options;
            var6_7.clientReportRecorder.recordLostEvent(DiscardReason.EVENT_PROCESSOR, DataCategory.Error);
            return SentryId.EMPTY_ID;
        }
        if (this.shouldApplyScopeData(event, hint)) {
            var7_16 = hint;
            var15_20 = scope;
            var14_21 = event;
            var6_8 = this;
            if (var15_20 != null) {
                var6_8.applyScope(var14_21, (IScope)var15_20);
                if (var14_21.getTransaction() == null) {
                    var14_21.setTransaction(var15_20.getTransactionName());
                }
                if (var14_21.getFingerprints() == null) {
                    var14_21.setFingerprints(var15_20.getFingerprint());
                }
                if (var15_20.getLevel() != null) {
                    var14_21.setLevel(var15_20.getLevel());
                }
                var8_24 = var15_20.getSpan();
                if (var14_21.getContexts().getTrace() == null) {
                    if (var8_24 == null) {
                        var14_21.getContexts().setTrace(TransactionContext.fromPropagationContext(var15_20.getPropagationContext()));
                    } else {
                        var14_21.getContexts().setTrace(var8_24.getSpanContext());
                    }
                }
                var14_21 = super.processEvent(var14_21, (Hint)var7_16, var15_20.getEventProcessors());
            }
            if ((event = var14_21) == null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by applyScope", new Object[0]);
                return SentryId.EMPTY_ID;
            }
        }
        if ((event = this.processEvent(event, hint, this.options.getEventProcessors())) != null && (event = this.executeBeforeSend(event, hint)) == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by beforeSend", new Object[0]);
            var6_8 = this.options;
            var6_8.clientReportRecorder.recordLostEvent(DiscardReason.BEFORE_SEND, DataCategory.Error);
        }
        if (event == null) {
            return SentryId.EMPTY_ID;
        }
        sessionBeforeUpdate = scope != null ? scope.withSession((Scope.IWithSession)LambdaMetafactory.metafactory(null, null, null, (Lio/sentry/Session;)V, lambda$captureEvent$0(io.sentry.Session ), (Lio/sentry/Session;)V)()) : null;
        session = null;
        if (event != null) {
            if (sessionBeforeUpdate == null || !sessionBeforeUpdate.isTerminated()) {
                var7_16 = scope;
                var15_20 = hint;
                var14_21 = event;
                var6_8 = this;
                var8_24 = null;
                if (HintUtils.shouldApplyScopeData((Hint)var15_20)) {
                    if (var7_16 != null) {
                        var8_24 = var7_16.withSession((Scope.IWithSession)LambdaMetafactory.metafactory(null, null, null, (Lio/sentry/Session;)V, lambda$updateSessionData$1(io.sentry.SentryEvent io.sentry.Hint io.sentry.Session ), (Lio/sentry/Session;)V)((SentryClient)var6_8, (SentryEvent)var14_21, (Hint)var15_20));
                    } else {
                        var6_8.options.getLogger().log(SentryLevel.INFO, "Scope is null on client.captureEvent", new Object[0]);
                    }
                }
                session = var8_24;
            }
            var6_8 = this;
            if (!(var6_8.options.getSampleRate() != null && var6_8.random != null ? !((var14_22 = var6_8.options.getSampleRate().doubleValue()) < var6_8.random.nextDouble()) : true)) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Event %s was dropped due to sampling decision.", new Object[]{event.getEventId()});
                var6_8 = this.options;
                var6_8.clientReportRecorder.recordLostEvent(DiscardReason.SAMPLE_RATE, DataCategory.Error);
                event = null;
            }
        }
        var14_23 = session;
        var6_8 = sessionBeforeUpdate;
        if (var14_23 == null) ** GOTO lbl-1000
        if (var6_8 == null) {
            v0 = true;
        } else {
            var7_17 = var14_23.getStatus() == Session.State.Crashed && var6_8.getStatus() != Session.State.Crashed;
            if (var7_17) {
                v0 = true;
            } else {
                var8_25 = var14_23.errorCount() > 0 && var6_8.errorCount() <= 0;
                if (var8_25) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = shouldSendSessionUpdate = false;
                }
            }
        }
        if (event == null && !shouldSendSessionUpdate) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Not sending session update for dropped event as it did not cause the session health to change.", new Object[0]);
            return SentryId.EMPTY_ID;
        }
        sentryId = SentryId.EMPTY_ID;
        if (event != null && event.getEventId() != null) {
            sentryId = event.getEventId();
        }
        isBackfillable = HintUtils.hasType(hint, Backfillable.class);
        if (event != null && !isBackfillable && (event.isErrored() || event.isCrashed())) {
            this.options.getReplayController();
            Boolean.valueOf(event.isCrashed());
        }
        try {
            traceContext = null;
            if (isBackfillable) {
                if (event != null) {
                    isBackfillable = Baggage.fromEvent(event, this.options);
                    traceContext = isBackfillable.toTraceContext();
                }
            } else if (scope != null) {
                transaction = scope.getTransaction();
                if (transaction != null) {
                    traceContext = transaction.traceContext();
                } else {
                    transaction = TracingUtils.maybeUpdateBaggage(scope, this.options);
                    traceContext = transaction.traceContext();
                }
            }
            transaction = event != null;
            attachments = transaction != false ? SentryClient.getAttachments(hint) : null;
            envelope = this.buildEnvelope(event, attachments, (Session)session, traceContext, null);
            hint.clear();
            if (envelope != null) {
                sentryId = this.sendEnvelope((SentryEnvelope)var1_1, hint);
            }
        }
        catch (SentryEnvelopeException | IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, e, "Capturing event %s failed.", new Object[]{sentryId});
            sentryId = SentryId.EMPTY_ID;
        }
        if (scope != null) {
            var14_23 = var3_3;
            var6_15 = var2_2;
            var7_18 = var6_15.getTransaction();
            if (var7_18 != null && HintUtils.hasType((Hint)var14_23, TransactionEnd.class)) {
                var6_15 = var14_23;
                var8_26 = var6_15.get("sentry:typeCheckHint");
                if (var8_26 instanceof DiskFlushNotification) {
                    ((DiskFlushNotification)var8_26).setFlushable(var7_18.getEventId());
                    var7_18.forceFinish(SpanStatus.ABORTED, false, (Hint)var14_23);
                } else {
                    var7_18.forceFinish(SpanStatus.ABORTED, false, null);
                }
            }
        }
        return sentryId;
    }

    /*
     * WARNING - void declaration
     */
    private static void addScopeAttachmentsToHint(IScope scope, Hint hint) {
        if (scope != null) {
            IScope iScope;
            void var1_1;
            var1_1.addAttachments(iScope.getAttachments());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<Attachment> getAttachments(Hint hint) {
        void var1_1;
        Object threadDump;
        Attachment viewHierarchy;
        List<Attachment> attachments = hint.getAttachments();
        Attachment screenshot = hint.getScreenshot();
        if (screenshot != null) {
            attachments.add(screenshot);
        }
        if ((viewHierarchy = hint.getViewHierarchy()) != null) {
            void var2_2;
            attachments.add((Attachment)var2_2);
        }
        if ((threadDump = hint.getThreadDump()) != null) {
            Object object;
            attachments.add((Attachment)object);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private SentryEnvelope buildEnvelope(SentryBaseEvent event, List<Attachment> attachments, Session session, TraceContext traceContext, ProfilingTraceData profilingTraceData) throws IOException, SentryEnvelopeException {
        SentryId sentryId = null;
        ArrayList<SentryEnvelopeItem> envelopeItems = new ArrayList<SentryEnvelopeItem>();
        if (event != null) {
            SentryEnvelopeItem eventItem = SentryEnvelopeItem.fromEvent(this.options.getSerializer(), event);
            envelopeItems.add(eventItem);
            sentryId = event.getEventId();
        }
        if (session != null) {
            void var3_3;
            SentryEnvelopeItem sessionItem = SentryEnvelopeItem.fromSession(this.options.getSerializer(), (Session)var3_3);
            envelopeItems.add(sessionItem);
        }
        if (profilingTraceData != null) {
            SentryEnvelopeItem profilingTraceItem = SentryEnvelopeItem.fromProfilingTrace(profilingTraceData, this.options.getMaxTraceFileSize(), this.options.getSerializer());
            envelopeItems.add(profilingTraceItem);
            if (sentryId == null) {
                sentryId = new SentryId(profilingTraceData.getProfileId());
            }
        }
        if (attachments != null) {
            void var2_2;
            for (Attachment attachment : var2_2) {
                void var1_1;
                SentryEnvelopeItem attachmentItem = SentryEnvelopeItem.fromAttachment(this.options.getSerializer(), this.options.getLogger(), attachment, this.options.getMaxAttachmentSize());
                envelopeItems.add((SentryEnvelopeItem)var1_1);
            }
        }
        if (!envelopeItems.isEmpty()) {
            SentryEnvelopeHeader envelopeHeader = new SentryEnvelopeHeader(sentryId, this.options.getSdkVersion(), traceContext);
            return new SentryEnvelope(envelopeHeader, envelopeItems);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private SentryEvent processEvent(SentryEvent event, Hint hint, List<EventProcessor> eventProcessors) {
        void var1_1;
        for (EventProcessor processor : eventProcessors) {
            try {
                boolean isBackfillingProcessor = processor instanceof BackfillingEventProcessor;
                boolean isBackfillable = HintUtils.hasType((Hint)hint, Backfillable.class);
                if (isBackfillable && isBackfillingProcessor) {
                    event = processor.process(event, (Hint)hint);
                } else if (!isBackfillable && !isBackfillingProcessor) {
                    event = processor.process(event, (Hint)hint);
                }
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, e, "An exception occurred while processing event by processor: %s", processor.getClass().getName());
            }
            if (event != null) continue;
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by a processor: %s", processor.getClass().getName());
            hint = this.options;
            ((SentryOptions)hint).clientReportRecorder.recordLostEvent(DiscardReason.EVENT_PROCESSOR, DataCategory.Error);
            break;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureEnvelope(SentryEnvelope envelope, Hint hint) {
        Objects.requireNonNull(envelope, "SentryEnvelope is required.");
        if (hint == null) {
            hint = new Hint();
        }
        try {
            void var2_3;
            hint.clear();
            return this.sendEnvelope(envelope, (Hint)var2_3);
        }
        catch (IOException e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to capture envelope.", (Throwable)var1_2);
            return SentryId.EMPTY_ID;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SentryId sendEnvelope(SentryEnvelope envelope, Hint hint) throws IOException {
        void var1_1;
        SentryOptions.BeforeEnvelopeCallback beforeEnvelopeCallback = this.options.getBeforeEnvelopeCallback();
        if (beforeEnvelopeCallback != null) {
            try {
                beforeEnvelopeCallback.execute$74b70ef(envelope);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "The BeforeEnvelope callback threw an exception.", e);
            }
        }
        if (hint == null) {
            this.transport.send(envelope);
        } else {
            void var2_2;
            this.transport.send(envelope, (Hint)var2_2);
        }
        SentryId id = var1_1.getHeader().getEventId();
        if (id != null) {
            void var3_3;
            return var3_3;
        }
        return SentryId.EMPTY_ID;
    }

    /*
     * WARNING - void declaration
     */
    private <T extends SentryBaseEvent> T applyScope(T sentryBaseEvent, IScope scope) {
        void var1_1;
        if (scope != null) {
            if (sentryBaseEvent.getRequest() == null) {
                sentryBaseEvent.setRequest(scope.getRequest());
            }
            if (sentryBaseEvent.getUser() == null) {
                sentryBaseEvent.setUser(scope.getUser());
            }
            if (sentryBaseEvent.getTags() == null) {
                sentryBaseEvent.setTags(new HashMap<String, String>(scope.getTags()));
            } else {
                for (Map.Entry<String, String> entry : scope.getTags().entrySet()) {
                    if (sentryBaseEvent.getTags().containsKey(entry.getKey())) continue;
                    sentryBaseEvent.getTags().put(entry.getKey(), entry.getValue());
                }
            }
            if (sentryBaseEvent.getBreadcrumbs() == null) {
                sentryBaseEvent.setBreadcrumbs(new ArrayList<Breadcrumb>(scope.getBreadcrumbs()));
            } else {
                this.sortBreadcrumbsByDate(sentryBaseEvent, scope.getBreadcrumbs());
            }
            if (sentryBaseEvent.getExtras() == null) {
                sentryBaseEvent.setExtras(new HashMap<String, Object>(scope.getExtras()));
            } else {
                for (Map.Entry<String, Object> entry : scope.getExtras().entrySet()) {
                    if (sentryBaseEvent.getExtras().containsKey(entry.getKey())) continue;
                    sentryBaseEvent.getExtras().put(entry.getKey(), entry.getValue());
                }
            }
            Contexts contexts = sentryBaseEvent.getContexts();
            for (Map.Entry entry : new Contexts(scope.getContexts()).entrySet()) {
                void var2_2;
                if (contexts.containsKey(entry.getKey())) continue;
                contexts.put((String)entry.getKey(), var2_2.getValue());
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void sortBreadcrumbsByDate(SentryBaseEvent event, Collection<Breadcrumb> breadcrumbs) {
        List<Breadcrumb> sortedBreadcrumbs = event.getBreadcrumbs();
        if (sortedBreadcrumbs != null && !breadcrumbs.isEmpty()) {
            void var1_1;
            void var2_2;
            sortedBreadcrumbs.addAll((Collection<Breadcrumb>)var2_2);
            Collections.sort(var1_1, this.sortBreadcrumbsByDate);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SentryEvent executeBeforeSend(SentryEvent event, Hint hint) {
        Object var1_1;
        SentryOptions.BeforeSendCallback beforeSend = this.options.getBeforeSend();
        if (beforeSend != null) {
            try {
                void var2_3;
                void var3_4;
                event = var3_4.execute(event, (Hint)var2_3);
            }
            catch (Throwable e) {
                void var1_2;
                this.options.getLogger().log(SentryLevel.ERROR, "The BeforeSend callback threw an exception. It will be added as breadcrumb and continue.", (Throwable)var1_2);
                var1_1 = null;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close(boolean isRestarting) {
        this.options.getLogger().log(SentryLevel.INFO, "Closing SentryClient.", new Object[0]);
        try {
            this.metricsAggregator.close();
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the metrics aggregator.", e);
        }
        try {
            this.flush(isRestarting ? 0L : this.options.getShutdownTimeoutMillis());
            this.transport.close(isRestarting);
        }
        catch (IOException e) {
            void var2_4;
            this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the connection to the Sentry Server.", (Throwable)var2_4);
        }
        for (EventProcessor eventProcessor : this.options.getEventProcessors()) {
            if (!(eventProcessor instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)eventProcessor)).close();
            }
            catch (IOException e) {
                void var3_6;
                void var1_2;
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the event processor {}.", var1_2, var3_6);
            }
        }
        this.enabled = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void flush(long timeoutMillis) {
        void var1_1;
        this.transport.flush((long)var1_1);
    }

    @Override
    public final boolean isHealthy() {
        return this.transport.isHealthy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId captureMetrics(EncodedMetrics metrics) {
        void var2_2;
        SentryEnvelopeItem envelopeItem = SentryEnvelopeItem.fromMetrics(metrics);
        SentryEnvelopeHeader envelopeHeader = new SentryEnvelopeHeader(new SentryId(), this.options.getSdkVersion(), null);
        SentryEnvelope envelope = new SentryEnvelope((SentryEnvelopeHeader)var2_2, Collections.singleton(envelopeItem));
        SentryId id = this.captureEnvelope(envelope);
        if (id != null) {
            void var1_1;
            return var1_1;
        }
        return SentryId.EMPTY_ID;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$updateSessionData$1(SentryEvent event, Hint hint, Session session) {
        if (session != null) {
            void var2_2;
            void var1_1;
            Session.State status = null;
            if (((SentryEvent)event).isCrashed()) {
                status = Session.State.Crashed;
            }
            boolean crashedOrErrored = false;
            if (Session.State.Crashed == status || ((SentryEvent)event).isErrored()) {
                crashedOrErrored = true;
            }
            String userAgent = null;
            if (((SentryBaseEvent)event).getRequest() != null && ((SentryBaseEvent)event).getRequest().getHeaders() != null && ((SentryBaseEvent)event).getRequest().getHeaders().containsKey("user-agent")) {
                userAgent = ((SentryBaseEvent)event).getRequest().getHeaders().get("user-agent");
            }
            event = hint;
            Object sentrySdkHint = ((Hint)event).get("sentry:typeCheckHint");
            String abnormalMechanism = null;
            if (sentrySdkHint instanceof AbnormalExit) {
                abnormalMechanism = ((AbnormalExit)var1_1).mechanism();
                status = Session.State.Abnormal;
            }
            if (session.update(status, userAgent, crashedOrErrored, (String)var2_2) && session.isTerminated()) {
                void var3_3;
                var1_1 = var3_3;
                var1_1.end(DateUtils.getCurrentDateTime());
            }
            return;
        }
        this.options.getLogger().log(SentryLevel.INFO, "Session is null on scope.withSession", new Object[0]);
    }

    private static /* synthetic */ void lambda$captureEvent$0(Session session) {
    }

    private static final class SortBreadcrumbsByDate
    implements Comparator<Breadcrumb> {
        private SortBreadcrumbsByDate() {
        }

        /* synthetic */ SortBreadcrumbsByDate(byte by) {
            this();
        }
    }
}

