/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.HostnameCache;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryEvent;
import io.sentry.SentryExceptionFactory;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryStackTraceFactory;
import io.sentry.SentryThreadFactory;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.Cached;
import io.sentry.protocol.DebugImage;
import io.sentry.protocol.DebugMeta;
import io.sentry.protocol.SentryException;
import io.sentry.protocol.User;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MainEventProcessor
implements EventProcessor,
Closeable {
    private final SentryOptions options;
    private final SentryThreadFactory sentryThreadFactory;
    private final SentryExceptionFactory sentryExceptionFactory;
    private volatile HostnameCache hostnameCache = null;

    /*
     * WARNING - void declaration
     */
    public MainEventProcessor(SentryOptions options) {
        void var1_1;
        this.options = Objects.requireNonNull(options, "The SentryOptions is required.");
        SentryStackTraceFactory sentryStackTraceFactory = new SentryStackTraceFactory(this.options);
        this.sentryExceptionFactory = new SentryExceptionFactory(sentryStackTraceFactory);
        this.sentryThreadFactory = new SentryThreadFactory((SentryStackTraceFactory)var1_1, this.options);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryEvent process(SentryEvent event, Hint hint) {
        void var1_1;
        Map<String, String> map;
        Map<String, String> map2 = event;
        Map<String, String> map3 = this;
        MainEventProcessor.setPlatform((SentryBaseEvent)((Object)map2));
        Object object = event;
        map2 = this;
        map3 = ((SentryBaseEvent)object).getThrowableMechanism();
        if (map3 != null) {
            ((SentryEvent)object).setExceptions(((MainEventProcessor)((Object)map2)).sentryExceptionFactory.getSentryExceptions((Throwable)((Object)map3)));
        }
        this.setDebugMeta(event);
        object = event;
        map2 = this;
        map3 = ((MainEventProcessor)((Object)map2)).options.getModulesLoader().getOrLoadModules();
        if (map3 != null) {
            map = ((SentryEvent)object).getModules();
            if (map == null) {
                ((SentryEvent)object).setModules(map3);
            } else {
                map.putAll(map3);
            }
        }
        if (this.shouldApplyScopeData(event, hint)) {
            List<SentryException> list;
            this.processNonCachedEvent(event);
            map3 = list;
            object = event;
            map2 = this;
            if (((SentryEvent)object).getThreads() == null) {
                map = null;
                list = ((SentryEvent)object).getExceptions();
                if (list != null && !list.isEmpty()) {
                    for (SentryException sentryException : list) {
                        if (sentryException.getMechanism() == null || sentryException.getThreadId() == null) continue;
                        if (map == null) {
                            map = new ArrayList();
                        }
                        map.add(sentryException.getThreadId());
                    }
                }
                if (((MainEventProcessor)((Object)map2)).options.isAttachThreads() || HintUtils.hasType(map3, AbnormalExit.class)) {
                    Object object2 = ((Hint)((Object)map3)).get("sentry:typeCheckHint");
                    boolean bl = false;
                    if (object2 instanceof AbnormalExit) {
                        bl = ((AbnormalExit)object2).ignoreCurrentThread();
                    }
                    boolean bl2 = bl;
                    map2 = map;
                    list = ((MainEventProcessor)((Object)map2)).sentryThreadFactory;
                    ((SentryEvent)object).setThreads(((SentryThreadFactory)((Object)list)).getCurrentThreads(Thread.getAllStackTraces(), (List<Long>)((Object)map2), bl2));
                } else if (((MainEventProcessor)((Object)map2)).options.isAttachStacktrace() && (list == null || list.isEmpty()) && !HintUtils.hasType(list = map3, Cached.class)) {
                    SentryEvent sentryEvent = object;
                    list = ((MainEventProcessor)((Object)map2)).sentryThreadFactory;
                    map2 = new HashMap<String, String>();
                    Object object3 = object = Thread.currentThread();
                    map2.put((String)object3, (String)((Thread)object3).getStackTrace());
                    sentryEvent.setThreads(((SentryThreadFactory)((Object)list)).getCurrentThreads(map2, null, false));
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void setDebugMeta(SentryBaseEvent event) {
        ArrayList<DebugImage> debugImages = new ArrayList<DebugImage>();
        if (this.options.getProguardUuid() != null) {
            DebugImage proguardMappingImage = new DebugImage();
            proguardMappingImage.setType("proguard");
            proguardMappingImage.setUuid(this.options.getProguardUuid());
            debugImages.add(proguardMappingImage);
        }
        for (String bundleId : this.options.getBundleIds()) {
            DebugImage sourceBundleImage = new DebugImage();
            sourceBundleImage.setType("jvm");
            sourceBundleImage.setDebugId(bundleId);
            debugImages.add(sourceBundleImage);
        }
        if (!debugImages.isEmpty()) {
            void var3_3;
            void var1_1;
            DebugMeta debugMeta = event.getDebugMeta();
            if (debugMeta == null) {
                debugMeta = new DebugMeta();
            }
            if (debugMeta.getImages() == null) {
                debugMeta.setImages(debugImages);
            } else {
                void var2_2;
                debugMeta.getImages().addAll((Collection<DebugImage>)var2_2);
            }
            var1_1.setDebugMeta((DebugMeta)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldApplyScopeData(SentryBaseEvent event, Hint hint) {
        void var1_1;
        if (HintUtils.shouldApplyScopeData(hint)) {
            return true;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying data relevant to the current app execution/version: %s", var1_1.getEventId());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void processNonCachedEvent(SentryBaseEvent event) {
        void var1_1;
        this.setRelease(event);
        this.setEnvironment(event);
        this.setServerName(event);
        this.setDist(event);
        this.setSdk(event);
        this.setTags(event);
        MainEventProcessor.mergeUser((SentryBaseEvent)var1_1);
    }

    private static void setPlatform(SentryBaseEvent event) {
        if (event.getPlatform() == null) {
            SentryBaseEvent sentryBaseEvent;
            sentryBaseEvent.setPlatform("java");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setRelease(SentryBaseEvent event) {
        if (event.getRelease() == null) {
            void var1_1;
            var1_1.setRelease(this.options.getRelease());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setEnvironment(SentryBaseEvent event) {
        if (event.getEnvironment() == null) {
            void var1_1;
            var1_1.setEnvironment(this.options.getEnvironment());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setServerName(SentryBaseEvent event) {
        if (event.getServerName() == null) {
            event.setServerName(this.options.getServerName());
        }
        if (this.options.isAttachServerName() && event.getServerName() == null) {
            this.ensureHostnameCache();
            if (this.hostnameCache != null) {
                void var1_1;
                var1_1.setServerName(this.hostnameCache.getHostname());
            }
        }
    }

    private void ensureHostnameCache() {
        if (this.hostnameCache == null) {
            MainEventProcessor mainEventProcessor = this;
            synchronized (mainEventProcessor) {
                if (this.hostnameCache == null) {
                    this.hostnameCache = HostnameCache.getInstance();
                }
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setDist(SentryBaseEvent event) {
        if (event.getDist() == null) {
            void var1_1;
            var1_1.setDist(this.options.getDist());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setSdk(SentryBaseEvent event) {
        if (event.getSdk() == null) {
            void var1_1;
            var1_1.setSdk(this.options.getSdkVersion());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setTags(SentryBaseEvent event) {
        if (event.getTags() == null) {
            event.setTags(new HashMap<String, String>(this.options.getTags()));
            return;
        }
        for (Map.Entry<String, String> item : this.options.getTags().entrySet()) {
            void var3_3;
            if (event.getTags().containsKey(item.getKey())) continue;
            event.setTag(item.getKey(), (String)var3_3.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void mergeUser(SentryBaseEvent event) {
        User user = event.getUser();
        if (user == null) {
            SentryBaseEvent sentryBaseEvent;
            user = new User();
            sentryBaseEvent.setUser(user);
        }
        if (user.getIpAddress() == null) {
            void var1_1;
            var1_1.setIpAddress("{{auto}}");
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.hostnameCache != null) {
            this.hostnameCache.close();
        }
    }
}

