/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Breadcrumb;
import io.sentry.ISerializer;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.ProfilingTraceData;
import io.sentry.ProfilingTransactionData;
import io.sentry.ReplayRecording;
import io.sentry.SentryAppStartProfilingOptions;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeHeader;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryEnvelopeItemHeader;
import io.sentry.SentryEvent;
import io.sentry.SentryItemType;
import io.sentry.SentryLevel;
import io.sentry.SentryLockReason;
import io.sentry.SentryOptions;
import io.sentry.SentryReplayEvent;
import io.sentry.Session;
import io.sentry.SpanContext;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.UserFeedback;
import io.sentry.clientreport.ClientReport;
import io.sentry.profilemeasurements.ProfileMeasurement;
import io.sentry.profilemeasurements.ProfileMeasurementValue;
import io.sentry.protocol.App;
import io.sentry.protocol.Browser;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.DebugImage;
import io.sentry.protocol.DebugMeta;
import io.sentry.protocol.Device;
import io.sentry.protocol.Geo;
import io.sentry.protocol.Gpu;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.Message;
import io.sentry.protocol.MetricSummary;
import io.sentry.protocol.OperatingSystem;
import io.sentry.protocol.Request;
import io.sentry.protocol.SdkInfo;
import io.sentry.protocol.SdkVersion;
import io.sentry.protocol.SentryException;
import io.sentry.protocol.SentryPackage;
import io.sentry.protocol.SentryRuntime;
import io.sentry.protocol.SentrySpan;
import io.sentry.protocol.SentryStackFrame;
import io.sentry.protocol.SentryStackTrace;
import io.sentry.protocol.SentryThread;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.User;
import io.sentry.protocol.ViewHierarchy;
import io.sentry.protocol.ViewHierarchyNode;
import io.sentry.rrweb.RRWebBreadcrumbEvent;
import io.sentry.rrweb.RRWebEventType;
import io.sentry.rrweb.RRWebInteractionEvent;
import io.sentry.rrweb.RRWebInteractionMoveEvent;
import io.sentry.rrweb.RRWebMetaEvent;
import io.sentry.rrweb.RRWebSpanEvent;
import io.sentry.rrweb.RRWebVideoEvent;
import io.sentry.util.Objects;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class JsonSerializer
implements ISerializer {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final SentryOptions options;
    private final Map<Class<?>, JsonDeserializer<?>> deserializersByClass;

    /*
     * WARNING - void declaration
     */
    public JsonSerializer(SentryOptions options) {
        void var1_1;
        this.options = var1_1;
        this.deserializersByClass = new HashMap();
        this.deserializersByClass.put(App.class, new App.Deserializer());
        this.deserializersByClass.put(Breadcrumb.class, new Breadcrumb.Deserializer());
        this.deserializersByClass.put(Browser.class, new Browser.Deserializer());
        this.deserializersByClass.put(Contexts.class, new Contexts.Deserializer());
        this.deserializersByClass.put(DebugImage.class, new DebugImage.Deserializer());
        this.deserializersByClass.put(DebugMeta.class, new DebugMeta.Deserializer());
        this.deserializersByClass.put(Device.class, new Device.Deserializer());
        this.deserializersByClass.put(Device.DeviceOrientation.class, new Device.DeviceOrientation.Deserializer());
        this.deserializersByClass.put(Gpu.class, new Gpu.Deserializer());
        this.deserializersByClass.put(MeasurementValue.class, new MeasurementValue.Deserializer());
        this.deserializersByClass.put(Mechanism.class, new Mechanism.Deserializer());
        this.deserializersByClass.put(Message.class, new Message.Deserializer());
        this.deserializersByClass.put(MetricSummary.class, new MetricSummary.Deserializer());
        this.deserializersByClass.put(OperatingSystem.class, new OperatingSystem.Deserializer());
        this.deserializersByClass.put(ProfilingTraceData.class, new ProfilingTraceData.Deserializer());
        this.deserializersByClass.put(ProfilingTransactionData.class, new ProfilingTransactionData.Deserializer());
        this.deserializersByClass.put(ProfileMeasurement.class, new ProfileMeasurement.Deserializer());
        this.deserializersByClass.put(ProfileMeasurementValue.class, new ProfileMeasurementValue.Deserializer());
        this.deserializersByClass.put(Request.class, new Request.Deserializer());
        this.deserializersByClass.put(ReplayRecording.class, new ReplayRecording.Deserializer());
        this.deserializersByClass.put(RRWebBreadcrumbEvent.class, new RRWebBreadcrumbEvent.Deserializer());
        this.deserializersByClass.put(RRWebEventType.class, new RRWebEventType.Deserializer());
        this.deserializersByClass.put(RRWebInteractionEvent.class, new RRWebInteractionEvent.Deserializer());
        this.deserializersByClass.put(RRWebInteractionMoveEvent.class, new RRWebInteractionMoveEvent.Deserializer());
        this.deserializersByClass.put(RRWebMetaEvent.class, new RRWebMetaEvent.Deserializer());
        this.deserializersByClass.put(RRWebSpanEvent.class, new RRWebSpanEvent.Deserializer());
        this.deserializersByClass.put(RRWebVideoEvent.class, new RRWebVideoEvent.Deserializer());
        this.deserializersByClass.put(SdkInfo.class, new SdkInfo.Deserializer());
        this.deserializersByClass.put(SdkVersion.class, new SdkVersion.Deserializer());
        this.deserializersByClass.put(SentryEnvelopeHeader.class, new SentryEnvelopeHeader.Deserializer());
        this.deserializersByClass.put(SentryEnvelopeItemHeader.class, new SentryEnvelopeItemHeader.Deserializer());
        this.deserializersByClass.put(SentryEvent.class, new SentryEvent.Deserializer());
        this.deserializersByClass.put(SentryException.class, new SentryException.Deserializer());
        this.deserializersByClass.put(SentryItemType.class, new SentryItemType.Deserializer());
        this.deserializersByClass.put(SentryLevel.class, new SentryLevel.Deserializer());
        this.deserializersByClass.put(SentryLockReason.class, new SentryLockReason.Deserializer());
        this.deserializersByClass.put(SentryPackage.class, new SentryPackage.Deserializer());
        this.deserializersByClass.put(SentryRuntime.class, new SentryRuntime.Deserializer());
        this.deserializersByClass.put(SentryReplayEvent.class, new SentryReplayEvent.Deserializer());
        this.deserializersByClass.put(SentrySpan.class, new SentrySpan.Deserializer());
        this.deserializersByClass.put(SentryStackFrame.class, new SentryStackFrame.Deserializer());
        this.deserializersByClass.put(SentryStackTrace.class, new SentryStackTrace.Deserializer());
        this.deserializersByClass.put(SentryAppStartProfilingOptions.class, new SentryAppStartProfilingOptions.Deserializer());
        this.deserializersByClass.put(SentryThread.class, new SentryThread.Deserializer());
        this.deserializersByClass.put(SentryTransaction.class, new SentryTransaction.Deserializer());
        this.deserializersByClass.put(Session.class, new Session.Deserializer());
        this.deserializersByClass.put(SpanContext.class, new SpanContext.Deserializer());
        this.deserializersByClass.put(SpanId.class, new SpanId.Deserializer());
        this.deserializersByClass.put(SpanStatus.class, new SpanStatus.Deserializer());
        this.deserializersByClass.put(User.class, new User.Deserializer());
        this.deserializersByClass.put(Geo.class, new Geo.Deserializer());
        this.deserializersByClass.put(UserFeedback.class, new UserFeedback.Deserializer());
        this.deserializersByClass.put(ClientReport.class, new ClientReport.Deserializer());
        this.deserializersByClass.put(ViewHierarchyNode.class, new ViewHierarchyNode.Deserializer());
        this.deserializersByClass.put(ViewHierarchy.class, new ViewHierarchy.Deserializer());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <T> T deserialize(Reader reader, Class<T> clazz) {
        try (JsonObjectReader jsonObjectReader = new JsonObjectReader(reader);){
            void var2_3;
            JsonDeserializer<?> deserializer = this.deserializersByClass.get(clazz);
            if (deserializer != null) {
                void var3_4;
                Object object = var3_4.deserialize(jsonObjectReader, this.options.getLogger());
                clazz = clazz.cast(object);
                return (T)clazz;
            }
            if (!(var2_3.isArray() || Collection.class.isAssignableFrom((Class<?>)var2_3) || String.class.isAssignableFrom((Class<?>)var2_3) || Map.class.isAssignableFrom((Class<?>)var2_3))) return null;
            Object object = jsonObjectReader.nextObjectOrNull();
            return (T)object;
        }
        catch (Exception e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, "Error when deserializing", (Throwable)var1_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryEnvelope deserializeEnvelope(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "The InputStream object is required.");
        try {
            return this.options.getEnvelopeReader().read(inputStream);
        }
        catch (IOException e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, "Error deserializing envelope.", (Throwable)var1_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> void serialize(T entity, Writer writer) throws IOException {
        void var2_2;
        void var1_1;
        Object object;
        Objects.requireNonNull(entity, "The entity is required.");
        Objects.requireNonNull(writer, "The Writer object is required.");
        if (this.options.getLogger().isEnabled(SentryLevel.DEBUG)) {
            boolean bl = this.options.isEnablePrettySerializationOutput();
            T t = entity;
            object = this;
            StringWriter stringWriter = new StringWriter();
            JsonObjectWriter jsonObjectWriter = new JsonObjectWriter(stringWriter, ((JsonSerializer)object).options.getMaxDepth());
            if (bl) {
                jsonObjectWriter.setIndent("\t");
            }
            jsonObjectWriter.value(((JsonSerializer)object).options.getLogger(), t);
            String serialized = stringWriter.toString();
            this.options.getLogger().log(SentryLevel.DEBUG, "Serializing object: %s", object);
        }
        object = new JsonObjectWriter(writer, this.options.getMaxDepth());
        ((JsonObjectWriter)object).value(this.options.getLogger(), var1_1);
        var2_2.flush();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(SentryEnvelope envelope, OutputStream outputStream) throws Exception {
        Objects.requireNonNull(envelope, "The SentryEnvelope object is required.");
        Objects.requireNonNull(outputStream, "The Stream object is required.");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, UTF_8));
        try {
            Iterator<SentryEnvelopeItem> iterator;
            envelope.getHeader().serialize(new JsonObjectWriter(writer, this.options.getMaxDepth()), this.options.getLogger());
            writer.write("\n");
            for (SentryEnvelopeItem item : ((SentryEnvelope)((Object)iterator)).getItems()) {
                try {
                    byte[] data = item.getData();
                    item.getHeader().serialize(new JsonObjectWriter(writer, this.options.getMaxDepth()), this.options.getLogger());
                    writer.write("\n");
                    ((Writer)writer).flush();
                    outputStream.write(data);
                    writer.write("\n");
                }
                catch (Exception exception) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to create envelope item. Dropping it.", exception);
                }
            }
        }
        catch (Throwable throwable) {
            void var3_4;
            var3_4.flush();
            throw throwable;
        }
        ((Writer)writer).flush();
    }
}

