/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.util.JsonSerializationUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;

public final class JsonReflectionObjectSerializer {
    private final Set<Object> visiting = new HashSet<Object>();
    private final int maxDepth;

    /*
     * WARNING - void declaration
     */
    JsonReflectionObjectSerializer(int maxDepth) {
        void var1_1;
        this.maxDepth = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Object serialize(Object object, ILogger logger) throws Exception {
        void var3_4;
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return object.toString();
        }
        if (object instanceof Number) {
            return object;
        }
        if (object instanceof Boolean) {
            return object;
        }
        if (object instanceof String) {
            return object;
        }
        if (object instanceof Locale) {
            return object.toString();
        }
        if (object instanceof AtomicIntegerArray) {
            return JsonSerializationUtils.atomicIntegerArrayToList((AtomicIntegerArray)object);
        }
        if (object instanceof AtomicBoolean) {
            return ((AtomicBoolean)object).get();
        }
        if (object instanceof URI) {
            return object.toString();
        }
        if (object instanceof InetAddress) {
            return object.toString();
        }
        if (object instanceof UUID) {
            return object.toString();
        }
        if (object instanceof Currency) {
            return object.toString();
        }
        if (object instanceof Calendar) {
            return JsonSerializationUtils.calendarToMap((Calendar)object);
        }
        if (object.getClass().isEnum()) {
            return object.toString();
        }
        if (this.visiting.contains(object)) {
            logger.log(SentryLevel.INFO, "Cyclic reference detected. Calling toString() on object.", new Object[0]);
            return object.toString();
        }
        this.visiting.add(object);
        if (this.visiting.size() > this.maxDepth) {
            this.visiting.remove(object);
            logger.log(SentryLevel.INFO, "Max depth exceeded. Calling toString() on object.", new Object[0]);
            return object.toString();
        }
        Object serializedObject = null;
        try {
            if (object.getClass().isArray()) {
                ILogger iLogger = logger;
                Object object2 = (Object[])object;
                JsonReflectionObjectSerializer jsonReflectionObjectSerializer = this;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Object[] objectArray = object2;
                int n = ((Object[])object2).length;
                for (int i = 0; i < n; ++i) {
                    object2 = objectArray[i];
                    arrayList.add(jsonReflectionObjectSerializer.serialize(object2, iLogger));
                }
                serializedObject = arrayList;
            } else if (object instanceof Collection) {
                ILogger iLogger = logger;
                Collection collection = (Collection)object;
                JsonReflectionObjectSerializer jsonReflectionObjectSerializer = this;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Object e : collection) {
                    arrayList.add(jsonReflectionObjectSerializer.serialize(e, iLogger));
                }
                serializedObject = arrayList;
            } else if (object instanceof Map) {
                ILogger iLogger = logger;
                Map map = (Map)object;
                JsonReflectionObjectSerializer jsonReflectionObjectSerializer = this;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                for (Object k : map.keySet()) {
                    Object v = map.get(k);
                    if (v != null) {
                        hashMap.put(k.toString(), jsonReflectionObjectSerializer.serialize(v, iLogger));
                        continue;
                    }
                    hashMap.put(k.toString(), null);
                }
                serializedObject = hashMap;
            } else {
                Map<String, Object> objectAsMap = this.serializeObject(object, logger);
                serializedObject = objectAsMap.isEmpty() ? object.toString() : objectAsMap;
            }
            this.visiting.remove(object);
        }
        catch (Exception exception) {
            try {
                void var2_2;
                var2_2.log(SentryLevel.INFO, "Not serializing object due to throwing sub-path.", exception);
                this.visiting.remove(object);
            }
            catch (Throwable throwable) {
                void var1_1;
                this.visiting.remove(var1_1);
                throw throwable;
            }
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> serializeObject(Object object, ILogger logger) throws Exception {
        void var3_3;
        Field[] fields = object.getClass().getDeclaredFields();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (void field : var3_3) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            String fieldName = field.getName();
            try {
                field.setAccessible(true);
                Object fieldObject = field.get(object);
                map.put(fieldName, this.serialize(fieldObject, logger));
                field.setAccessible(false);
            }
            catch (Exception exception) {
                logger.log(SentryLevel.INFO, "Cannot access field " + fieldName + ".", new Object[0]);
            }
        }
        return map;
    }
}

