/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.config.PropertiesProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public final class ExternalOptions {
    private String dsn;
    private String environment;
    private String release;
    private String dist;
    private String serverName;
    private Boolean enableUncaughtExceptionHandler;
    private Boolean debug;
    private Boolean enableDeduplication;
    private Boolean enableTracing;
    private Double tracesSampleRate;
    private Double profilesSampleRate;
    private SentryOptions.RequestSize maxRequestBodySize;
    private final Map<String, String> tags = new ConcurrentHashMap<String, String>();
    private SentryOptions.Proxy proxy;
    private final List<String> inAppExcludes = new CopyOnWriteArrayList<String>();
    private final List<String> inAppIncludes = new CopyOnWriteArrayList<String>();
    private List<String> tracePropagationTargets = null;
    private final List<String> contextTags = new CopyOnWriteArrayList<String>();
    private String proguardUuid;
    private Long idleTimeout;
    private final Set<Class<? extends Throwable>> ignoredExceptionsForType = new CopyOnWriteArraySet<Class<? extends Throwable>>();
    private Boolean printUncaughtStackTrace;
    private Boolean sendClientReports;
    private Set<String> bundleIds = new CopyOnWriteArraySet<String>();
    private Boolean enabled;
    private Boolean enablePrettySerializationOutput;
    private List<String> ignoredCheckIns;
    private Boolean sendModules;
    private Boolean enableBackpressureHandling;
    private SentryOptions.Cron cron;

    /*
     * WARNING - void declaration
     */
    public static ExternalOptions from(PropertiesProvider propertiesProvider, ILogger logger) {
        void var2_2;
        ExternalOptions options = new ExternalOptions();
        Object object = propertiesProvider.getProperty("dsn");
        ExternalOptions externalOptions = options;
        options.dsn = object;
        object = propertiesProvider.getProperty("environment");
        externalOptions = options;
        options.environment = object;
        object = propertiesProvider.getProperty("release");
        externalOptions = options;
        options.release = object;
        object = propertiesProvider.getProperty("dist");
        externalOptions = options;
        options.dist = object;
        object = propertiesProvider.getProperty("servername");
        externalOptions = options;
        options.serverName = object;
        object = propertiesProvider.getBooleanProperty("uncaught.handler.enabled");
        externalOptions = options;
        options.enableUncaughtExceptionHandler = object;
        object = propertiesProvider.getBooleanProperty("uncaught.handler.print-stacktrace");
        externalOptions = options;
        options.printUncaughtStackTrace = object;
        object = propertiesProvider.getBooleanProperty("enable-tracing");
        externalOptions = options;
        options.enableTracing = object;
        object = propertiesProvider.getDoubleProperty("traces-sample-rate");
        externalOptions = options;
        options.tracesSampleRate = object;
        object = propertiesProvider.getDoubleProperty("profiles-sample-rate");
        externalOptions = options;
        options.profilesSampleRate = object;
        object = propertiesProvider.getBooleanProperty("debug");
        externalOptions = options;
        options.debug = object;
        object = propertiesProvider.getBooleanProperty("enable-deduplication");
        externalOptions = options;
        options.enableDeduplication = object;
        object = propertiesProvider.getBooleanProperty("send-client-reports");
        externalOptions = options;
        options.sendClientReports = object;
        Object maxRequestBodySize = propertiesProvider.getProperty("max-request-body-size");
        if (maxRequestBodySize != null) {
            object = SentryOptions.RequestSize.valueOf(((String)maxRequestBodySize).toUpperCase(Locale.ROOT));
            externalOptions = options;
            options.maxRequestBodySize = object;
        }
        maxRequestBodySize = propertiesProvider.getMap("tags");
        for (Map.Entry<String, String> entry : maxRequestBodySize.entrySet()) {
            String string = entry.getValue();
            object = entry.getKey();
            externalOptions = options;
            externalOptions.tags.put((String)object, string);
        }
        Iterator<String> proxyHost = propertiesProvider.getProperty("proxy.host");
        String string = propertiesProvider.getProperty("proxy.user");
        Object proxyPass = propertiesProvider.getProperty("proxy.pass");
        Class<?> proxyPort = propertiesProvider.getProperty("proxy.port", "80");
        if (proxyHost != null) {
            proxyPort = new SentryOptions.Proxy((String)((Object)proxyHost), (String)((Object)proxyPort), string, (String)proxyPass);
            proxyPass = options;
            options.proxy = proxyPort;
        }
        for (String string2 : propertiesProvider.getList("in-app-includes")) {
            proxyPort = string2;
            proxyPass = options;
            ((ExternalOptions)proxyPass).inAppIncludes.add((String)((Object)proxyPort));
        }
        for (String string3 : propertiesProvider.getList("in-app-excludes")) {
            proxyPort = string3;
            proxyPass = options;
            ((ExternalOptions)proxyPass).inAppExcludes.add((String)((Object)proxyPort));
        }
        List<String> tracePropagationTargets = null;
        if (propertiesProvider.getProperty("trace-propagation-targets") != null) {
            tracePropagationTargets = propertiesProvider.getList("trace-propagation-targets");
        }
        if (tracePropagationTargets == null && propertiesProvider.getProperty("tracing-origins") != null) {
            tracePropagationTargets = propertiesProvider.getList("tracing-origins");
        }
        if (tracePropagationTargets != null) {
            for (String tracePropagationTarget : tracePropagationTargets) {
                proxyPort = tracePropagationTarget;
                proxyPass = options;
                if (((ExternalOptions)proxyPass).tracePropagationTargets == null) {
                    ((ExternalOptions)proxyPass).tracePropagationTargets = new CopyOnWriteArrayList<String>();
                }
                if (((String)((Object)proxyPort)).isEmpty()) continue;
                ((ExternalOptions)proxyPass).tracePropagationTargets.add((String)((Object)proxyPort));
            }
        }
        for (String contextTag : propertiesProvider.getList("context-tags")) {
            proxyPort = contextTag;
            proxyPass = options;
            ((ExternalOptions)proxyPass).contextTags.add((String)((Object)proxyPort));
        }
        proxyPort = propertiesProvider.getProperty("proguard-uuid");
        proxyPass = options;
        options.proguardUuid = proxyPort;
        for (String bundleId : propertiesProvider.getList("bundle-ids")) {
            proxyPort = bundleId;
            proxyPass = options;
            ((ExternalOptions)proxyPass).bundleIds.add((String)((Object)proxyPort));
        }
        proxyPort = propertiesProvider.getLongProperty("idle-timeout");
        proxyPass = options;
        options.idleTimeout = proxyPort;
        proxyPort = propertiesProvider.getBooleanProperty("enabled");
        proxyPass = options;
        options.enabled = proxyPort;
        proxyPort = propertiesProvider.getBooleanProperty("enable-pretty-serialization-output");
        proxyPass = options;
        options.enablePrettySerializationOutput = proxyPort;
        proxyPort = propertiesProvider.getBooleanProperty("send-modules");
        proxyPass = options;
        options.sendModules = proxyPort;
        proxyPort = propertiesProvider.getList("ignored-checkins");
        proxyPass = options;
        options.ignoredCheckIns = proxyPort;
        proxyPort = propertiesProvider.getBooleanProperty("enable-backpressure-handling");
        proxyPass = options;
        options.enableBackpressureHandling = proxyPort;
        for (String ignoredExceptionType : propertiesProvider.getList("ignored-exceptions-for-type")) {
            try {
                Object clazz = Class.forName(ignoredExceptionType);
                if (Throwable.class.isAssignableFrom((Class<?>)clazz)) {
                    proxyPort = clazz;
                    clazz = options;
                    ((ExternalOptions)clazz).ignoredExceptionsForType.add(proxyPort);
                    continue;
                }
                logger.log(SentryLevel.WARNING, "Skipping setting %s as ignored-exception-for-type. Reason: %s does not extend Throwable", ignoredExceptionType, ignoredExceptionType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(SentryLevel.WARNING, "Skipping setting %s as ignored-exception-for-type. Reason: %s class is not found", ignoredExceptionType, ignoredExceptionType);
            }
        }
        Long l = propertiesProvider.getLongProperty("cron.default-checkin-margin");
        Long cronDefaultMaxRuntime = propertiesProvider.getLongProperty("cron.default-max-runtime");
        String cronDefaultTimezone = propertiesProvider.getProperty("cron.default-timezone");
        Long cronDefaultFailureIssueThreshold = propertiesProvider.getLongProperty("cron.default-failure-issue-threshold");
        Long cronDefaultRecoveryThreshold = propertiesProvider.getLongProperty("cron.default-recovery-threshold");
        if (l != null || cronDefaultMaxRuntime != null || cronDefaultTimezone != null || cronDefaultFailureIssueThreshold != null || cronDefaultRecoveryThreshold != null) {
            Long l2;
            void var1_1;
            void var3_5;
            SentryOptions.Cron cron = new SentryOptions.Cron();
            cron.setDefaultCheckinMargin(l);
            cron.setDefaultMaxRuntime((Long)var3_5);
            cron.setDefaultTimezone(cronDefaultTimezone);
            cron.setDefaultFailureIssueThreshold((Long)var1_1);
            cron.setDefaultRecoveryThreshold(l2);
            object = cron;
            externalOptions = options;
            options.cron = object;
        }
        return var2_2;
    }

    public final String getDsn() {
        return this.dsn;
    }

    public final String getEnvironment() {
        return this.environment;
    }

    public final String getRelease() {
        return this.release;
    }

    public final String getDist() {
        return this.dist;
    }

    public final String getServerName() {
        return this.serverName;
    }

    public final Boolean getEnableUncaughtExceptionHandler() {
        return this.enableUncaughtExceptionHandler;
    }

    public final List<String> getTracePropagationTargets() {
        return this.tracePropagationTargets;
    }

    public final Boolean getDebug() {
        return this.debug;
    }

    public final Boolean getEnableDeduplication() {
        return this.enableDeduplication;
    }

    public final Boolean getEnableTracing() {
        return this.enableTracing;
    }

    public final Double getTracesSampleRate() {
        return this.tracesSampleRate;
    }

    public final Double getProfilesSampleRate() {
        return this.profilesSampleRate;
    }

    public final Map<String, String> getTags() {
        return this.tags;
    }

    public final SentryOptions.Proxy getProxy() {
        return this.proxy;
    }

    public final List<String> getInAppExcludes() {
        return this.inAppExcludes;
    }

    public final List<String> getInAppIncludes() {
        return this.inAppIncludes;
    }

    public final List<String> getContextTags() {
        return this.contextTags;
    }

    public final String getProguardUuid() {
        return this.proguardUuid;
    }

    public final Set<Class<? extends Throwable>> getIgnoredExceptionsForType() {
        return this.ignoredExceptionsForType;
    }

    public final Boolean getPrintUncaughtStackTrace() {
        return this.printUncaughtStackTrace;
    }

    public final Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public final Boolean getSendClientReports() {
        return this.sendClientReports;
    }

    public final Set<String> getBundleIds() {
        return this.bundleIds;
    }

    public final Boolean isEnabled() {
        return this.enabled;
    }

    public final Boolean isEnablePrettySerializationOutput() {
        return this.enablePrettySerializationOutput;
    }

    public final Boolean isSendModules() {
        return this.sendModules;
    }

    public final List<String> getIgnoredCheckIns() {
        return this.ignoredCheckIns;
    }

    public final Boolean isEnableBackpressureHandling() {
        return this.enableBackpressureHandling;
    }

    public final SentryOptions.Cron getCron() {
        return this.cron;
    }
}

