/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.vendor.gson.internal.bind.util.ISO8601Utils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;

public final class DateUtils {
    public static Date getCurrentDateTime() {
        Calendar calendar = Calendar.getInstance(ISO8601Utils.TIMEZONE_UTC);
        return calendar.getTime();
    }

    public static Date getDateTime(String timestamp) throws IllegalArgumentException {
        try {
            return ISO8601Utils.parse(timestamp, new ParsePosition(0));
        }
        catch (ParseException parseException) {
            String string;
            throw new IllegalArgumentException("timestamp is not ISO format " + string);
        }
    }

    public static Date getDateTimeWithMillisPrecision(String timestamp) throws IllegalArgumentException {
        try {
            return DateUtils.getDateTime(new BigDecimal(timestamp).setScale(3, RoundingMode.DOWN).movePointRight(3).longValue());
        }
        catch (NumberFormatException numberFormatException) {
            String string;
            throw new IllegalArgumentException("timestamp is not millis format " + string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Date getDateTime(long millis) {
        void var2_1;
        long l;
        Calendar calendar = Calendar.getInstance(ISO8601Utils.TIMEZONE_UTC);
        calendar.setTimeInMillis(l);
        return var2_1.getTime();
    }

    public static double dateToSeconds(Date date) {
        double d = date.getTime();
        return d / 1000.0;
    }
}

