/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.IScope;
import io.sentry.PropagationContext;
import io.sentry.SentryEvent;
import io.sentry.SentryOptions;
import io.sentry.SpanContext;
import io.sentry.TraceContext;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.User;
import io.sentry.util.SampleRateUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Baggage {
    static final Integer MAX_BAGGAGE_STRING_LENGTH = 8192;
    static final Integer MAX_BAGGAGE_LIST_MEMBER_COUNT = 64;
    final Map<String, String> keyValues;
    final String thirdPartyHeader;
    private boolean mutable;
    final ILogger logger;

    /*
     * WARNING - void declaration
     */
    public static Baggage fromEvent(SentryEvent event, SentryOptions options) {
        void var2_2;
        Baggage baggage;
        Baggage baggage2 = new Baggage(options.getLogger());
        SpanContext trace = event.getContexts().getTrace();
        String string = trace != null ? ((SpanContext)((Object)baggage)).getTraceId().toString() : null;
        baggage = baggage2;
        baggage.set("sentry-trace_id", string);
        string = options.getParsedDsn().getPublicKey();
        baggage = baggage2;
        baggage.set("sentry-public_key", string);
        string = event.getRelease();
        baggage = baggage2;
        baggage.set("sentry-release", string);
        string = event.getEnvironment();
        baggage = baggage2;
        baggage.set("sentry-environment", string);
        User user = event.getUser();
        string = user != null ? Baggage.getSegment(user) : null;
        baggage = baggage2;
        baggage.set("sentry-user_segment", string);
        string = event.getTransaction();
        baggage = baggage2;
        baggage.set("sentry-transaction", string);
        string = null;
        baggage = baggage2;
        baggage.set("sentry-sample_rate", string);
        string = null;
        baggage = baggage2;
        baggage.set("sentry-sampled", string);
        Object replayId = event.getContexts().get("replay_id");
        if (replayId != null && !replayId.toString().equals(SentryId.EMPTY_ID.toString())) {
            SentryEvent sentryEvent;
            void var1_1;
            string = var1_1.toString();
            baggage = baggage2;
            baggage.set("sentry-replay_id", string);
            sentryEvent.getContexts().remove("replay_id");
        }
        baggage = baggage2;
        baggage2.mutable = false;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Baggage(ILogger logger) {
        this(new HashMap<String, String>(), null, true, (ILogger)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Baggage(Baggage baggage) {
        this(baggage.keyValues, baggage.thirdPartyHeader, baggage.mutable, var1_1.logger);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Baggage(Map<String, String> keyValues, String thirdPartyHeader, boolean isMutable, ILogger logger) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.keyValues = var1_1;
        this.logger = logger;
        this.mutable = var3_3;
        this.thirdPartyHeader = var2_2;
    }

    public final void freeze() {
        this.mutable = false;
    }

    public final boolean isMutable() {
        return this.mutable;
    }

    /*
     * WARNING - void declaration
     */
    private String get(String key) {
        void var1_1;
        return this.keyValues.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void set(String key, String value) {
        if (this.mutable) {
            void var2_2;
            void var1_1;
            this.keyValues.put((String)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setValuesFromScope(IScope scope, SentryOptions options) {
        void var2_2;
        Baggage baggage;
        PropagationContext propagationContext = scope.getPropagationContext();
        User user = scope.getUser();
        SentryId replayId = scope.getReplayId();
        String string = ((PropagationContext)((Object)baggage)).getTraceId().toString();
        baggage = this;
        baggage.set("sentry-trace_id", string);
        string = options.getParsedDsn().getPublicKey();
        baggage = this;
        baggage.set("sentry-public_key", string);
        string = options.getRelease();
        baggage = this;
        baggage.set("sentry-release", string);
        string = var2_2.getEnvironment();
        baggage = this;
        baggage.set("sentry-environment", string);
        if (!SentryId.EMPTY_ID.equals(replayId)) {
            void var1_1;
            string = var1_1.toString();
            baggage = this;
            baggage.set("sentry-replay_id", string);
        }
        string = user != null ? Baggage.getSegment(user) : null;
        baggage = this;
        baggage.set("sentry-user_segment", string);
        string = null;
        baggage = this;
        baggage.set("sentry-transaction", string);
        string = null;
        baggage = this;
        baggage.set("sentry-sample_rate", string);
        string = null;
        baggage = this;
        baggage.set("sentry-sampled", string);
    }

    @Deprecated
    private static String getSegment(User user) {
        if (user.getSegment() != null) {
            return user.getSegment();
        }
        Map<String, String> userData = user.getData();
        if (userData != null) {
            Map<String, String> map;
            return (String)map.get("segment");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final Double getSampleRateDouble() {
        Baggage baggage = this;
        String sampleRateString = baggage.get("sentry-sample_rate");
        if (sampleRateString != null) {
            try {
                double sampleRate = Double.parseDouble((String)((Object)baggage));
                if (SampleRateUtils.isValidTracesSampleRate(sampleRate, false)) {
                    void var2_2;
                    return (double)var2_2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final TraceContext toTraceContext() {
        Object object = this;
        Object traceIdString = ((Baggage)object).get("sentry-trace_id");
        object = this;
        String replayIdString = ((Baggage)object).get("sentry-replay_id");
        object = this;
        String publicKey = ((Baggage)object).get("sentry-public_key");
        if (traceIdString != null && publicKey != null) {
            void var1_2;
            ConcurrentHashMap<String, Object> concurrentHashMap;
            SentryId sentryId = new SentryId((String)traceIdString);
            Baggage baggage = object;
            object = this;
            String string = ((Baggage)object).get("sentry-release");
            object = this;
            String string2 = ((Baggage)object).get("sentry-environment");
            object = this;
            String string3 = ((Baggage)object).get("sentry-user_id");
            object = this;
            String string4 = ((Baggage)object).get("sentry-user_segment");
            object = this;
            String string5 = ((Baggage)object).get("sentry-transaction");
            traceIdString = this;
            object = this;
            TraceContext traceContext = new TraceContext(sentryId, (String)((Object)baggage), string, string2, string3, string4, string5, ((Baggage)traceIdString).get("sentry-sample_rate"), ((Baggage)object).get("sentry-sampled"), replayIdString == null ? null : new SentryId((String)((Object)concurrentHashMap)));
            object = this;
            concurrentHashMap = new ConcurrentHashMap<String, Object>();
            for (Map.Entry entry : ((Baggage)object).keyValues.entrySet()) {
                String string6 = (String)entry.getKey();
                String object2 = (String)entry.getValue();
                if (DSCKeys.ALL.contains(string6) || object2 == null) continue;
                string6 = string6.replaceFirst("sentry-", "");
                concurrentHashMap.put(string6, object2);
            }
            traceContext.setUnknown(concurrentHashMap);
            return var1_2;
        }
        return null;
    }

    public static final class DSCKeys {
        public static final List<String> ALL = Arrays.asList("sentry-trace_id", "sentry-public_key", "sentry-release", "sentry-user_id", "sentry-environment", "sentry-user_segment", "sentry-transaction", "sentry-sample_rate", "sentry-sampled", "sentry-replay_id");
    }
}

