/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.File;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLDecoder;
import org.newsclub.net.unix.AFSocketAddressFromHostname$;
import org.newsclub.net.unix.AFSocketFactory;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

public abstract class AFUNIXSocketFactory
extends AFSocketFactory<AFUNIXSocketAddress> {
    protected AFUNIXSocketFactory() {
        super(AFUNIXSocketAddress.class);
    }

    @Override
    public Socket createSocket() throws SocketException {
        return AFUNIXSocket.newInstance(this);
    }

    @Override
    public boolean isHostnameSupported(String string) {
        return AFSocketAddressFromHostname$.isHostnameSupported$4ab7969b$24b91c42(string);
    }

    public static final class URIScheme
    extends AFUNIXSocketFactory {
        private static String stripBrackets(String host) {
            String string;
            if (host.startsWith("[")) {
                host = host.endsWith("]") ? host.substring(1, host.length() - 1) : host.substring(1);
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isHostnameSupported(String host) {
            void var1_1;
            return (host = URIScheme.stripBrackets(host)).startsWith("file://") || var1_1.startsWith("file%");
        }

        /*
         * WARNING - void declaration
         */
        private static AFUNIXSocketAddress addressFromHost(String host, int port) throws SocketException {
            void var1_2;
            File file;
            File e2;
            if ((host = URIScheme.stripBrackets(host)).startsWith("file%")) {
                try {
                    host = URLDecoder.decode(host, "UTF-8");
                }
                catch (Exception e2) {
                    throw (SocketException)new SocketException().initCause(e2);
                }
            }
            if (!((String)((Object)e2)).startsWith("file://")) {
                throw new SocketException("Unsupported scheme");
            }
            File path = ((String)((Object)e2)).substring(7);
            if (((String)((Object)path)).startsWith("localhost")) {
                path = ((String)((Object)path)).substring(9);
            }
            if (((String)((Object)path)).isEmpty()) {
                throw new SocketException("Path is empty");
            }
            if (!((String)((Object)path)).startsWith("/")) {
                throw new SocketException("Path must be absolute");
            }
            file = new File((String)((Object)file));
            return AFUNIXSocketAddress.of(file, (int)var1_2);
        }
    }

    public static final class SystemProperty
    extends DefaultSocketHostnameSocketFactory {
    }

    public static final class FactoryArg
    extends DefaultSocketHostnameSocketFactory {
        private final File socketFile;
    }

    private static abstract class DefaultSocketHostnameSocketFactory
    extends AFUNIXSocketFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isHostnameSupported(String host) {
            void var1_1;
            return System.getProperty("org.newsclub.net.unix.socket.hostname", "localhost").equals(var1_1);
        }
    }
}

