/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketAddressConfig;
import org.newsclub.net.unix.AFUNIXSelectorProvider;
import org.newsclub.net.unix.AFUNIXSocketAddress$$Lambda$1;
import org.newsclub.net.unix.AFUNIXSocketAddress$1$$Lambda$1;
import org.newsclub.net.unix.AFUNIXSocketAddress$1$$Lambda$2;
import org.newsclub.net.unix.PathUtil;
import org.newsclub.net.unix.pool.ObjectPool;

public final class AFUNIXSocketAddress
extends AFSocketAddress {
    private static final Charset ADDRESS_CHARSET = Charset.defaultCharset();
    static final AFAddressFamily<@NonNull AFUNIXSocketAddress> AF_UNIX = AFAddressFamily.registerAddressFamily("un", AFUNIXSocketAddress.class, new AFSocketAddressConfig<AFUNIXSocketAddress>(){
        private final AFSocketAddress.AFSocketAddressConstructor<AFUNIXSocketAddress> addrConstr = AFSocketAddress.isUseDeserializationForInit() ? AFUNIXSocketAddress$1$$Lambda$1.lambdaFactory$$62da34d0() : AFUNIXSocketAddress$1$$Lambda$2.lambdaFactory$$62da34d0();

        @Override
        protected final AFSocketAddress.AFSocketAddressConstructor<AFUNIXSocketAddress> addressConstructor() {
            return this.addrConstr;
        }

        @Override
        protected final String selectorProviderClassname() {
            return AFUNIXSelectorProvider.class.getName();
        }

        @Override
        protected final Set<String> uriSchemes() {
            return new HashSet<String>(Arrays.asList("unix", "http+unix", "https+unix"));
        }

        @Override
        protected final AFUNIXSocketAddress nullBindAddress$71c1176e() throws IOException {
            return AFUNIXSocketAddress.ofNewTempFile();
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ AFUNIXSocketAddress lambda$$0(int x$0, byte[] x$1, ObjectPool.Lease x$2) throws SocketException {
            void var2_2;
            void var1_1;
            int n;
            return new AFUNIXSocketAddress(n, (byte[])var1_1, (ObjectPool.Lease)var2_2, 0);
        }
    });

    /*
     * WARNING - void declaration
     */
    private AFUNIXSocketAddress(int port, byte[] socketAddress, ObjectPool.Lease<ByteBuffer> nativeAddress) throws SocketException {
        super((int)var1_1, (byte[])var2_2, (ObjectPool.Lease<ByteBuffer>)var3_3, AF_UNIX);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static AFUNIXSocketAddress newAFSocketAddress(int port, byte[] socketAddress, ObjectPool.Lease<ByteBuffer> nativeAddress) throws SocketException {
        void var2_2;
        void var1_1;
        return AFUNIXSocketAddress.newDeserializedAFSocketAddress(port, (byte[])var1_1, (ObjectPool.Lease<ByteBuffer>)var2_2, AF_UNIX, AFUNIXSocketAddress$$Lambda$1.lambdaFactory$$62da34d0());
    }

    public static AFUNIXSocketAddress of(File socketFile) throws SocketException {
        return AFUNIXSocketAddress.of(socketFile, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static AFUNIXSocketAddress of(File socketFile, int port) throws SocketException {
        void var1_1;
        return AFUNIXSocketAddress.of(socketFile.getPath().getBytes(ADDRESS_CHARSET), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static AFUNIXSocketAddress of(byte[] socketAddress, int port) throws SocketException {
        void var1_1;
        return AFSocketAddress.resolveAddress(socketAddress, (int)var1_1, AF_UNIX);
    }

    public static AFUNIXSocketAddress of(Path socketPath) throws SocketException {
        boolean bl = false;
        Path path = socketPath;
        if (!PathUtil.isPathInDefaultFileSystem(path)) {
            throw new SocketException("Path is not in the default file system");
        }
        return AFUNIXSocketAddress.of(path.toString().getBytes(ADDRESS_CHARSET), 0);
    }

    public static AFUNIXSocketAddress ofNewTempFile() throws IOException {
        boolean bl = false;
        bl = true;
        File file = File.createTempFile("jux", ".sock");
        file.deleteOnExit();
        if (!file.delete() && file.exists()) {
            throw new IOException("Could not delete temporary file that we just created: " + file);
        }
        return AFUNIXSocketAddress.of(file, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        String string;
        void var1_1;
        int port = this.getPort();
        StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName()).append("[").append(port == 0 ? "" : "port=" + (int)var1_1 + ";").append("path=");
        byte[] byArray = this.getBytes();
        int n = byArray.length;
        if (n == 0) {
            string = "";
        } else {
            StringBuilder stringBuilder2 = new StringBuilder(n + 16);
            for (int i = 0; i < n; ++i) {
                byte by = byArray[i];
                if (by >= 32 && by < 127) {
                    stringBuilder2.append((char)by);
                    continue;
                }
                stringBuilder2.append("\\x");
                stringBuilder2.append(String.format(Locale.ENGLISH, "%02x", by));
            }
            string = stringBuilder2.toString();
        }
        return stringBuilder.append(string).append("]").toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean hasFilename() {
        void var1_1;
        byte[] bytes = this.getBytes();
        return bytes.length > 0 && var1_1[0] != false;
    }

    @Override
    public final File getFile() throws FileNotFoundException {
        Object object = this;
        byte[] byArray = ((AFSocketAddress)object).getBytes();
        object = byArray;
        if (byArray.length > 0 && object[0] == false) {
            throw new FileNotFoundException("Socket is in abstract namespace");
        }
        byte[] bytes = this.getBytes();
        if (bytes.length == 0) {
            throw new FileNotFoundException("No name");
        }
        return new File(new String((byte[])object, ADDRESS_CHARSET));
    }

    static /* synthetic */ AFUNIXSocketAddress lambda$supportedAddressSupplier$0(SocketAddress addr) {
        return (AFUNIXSocketAddress)addr;
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ AFUNIXSocketAddress(int x0, byte[] x1, ObjectPool.Lease x2, byte by) throws SocketException {
        this((int)var1_1, (byte[])var2_2, (ObjectPool.Lease<ByteBuffer>)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    static /* synthetic */ AFUNIXSocketAddress access$lambda$0(int n, byte[] byArray, ObjectPool.Lease lease) {
        return new AFUNIXSocketAddress(n, byArray, lease);
    }
}

