/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import javax.net.SocketFactory;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketAddressFromHostname;
import org.newsclub.net.unix.AFSocketAddressFromHostname$;

public abstract class AFSocketFactory<A extends AFSocketAddress>
extends SocketFactory
implements AFSocketAddressFromHostname<A> {
    private final Class<? extends AFSocketAddress> socketAddressClass;

    /*
     * WARNING - void declaration
     */
    protected AFSocketFactory(Class<? extends AFSocketAddress> socketAddressClass) {
        void var1_1;
        this.socketAddressClass = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInetAddressSupported(InetAddress address) {
        void var1_1;
        return address != null && this.isHostnameSupported(var1_1.getHostName());
    }

    protected abstract Socket connectTo(A var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    @Override
    public final Socket createSocket(String host, int port) throws IOException {
        Object object;
        void var2_2;
        if (!this.isHostnameSupported(host)) {
            throw new SocketException("Unsupported hostname");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Illegal port");
        }
        SocketAddress socketAddress = this.addressFromHost(host, (int)var2_2);
        void var2_3 = object;
        object = this;
        if (AFSocketAddress.canMap((SocketAddress)var2_3, ((AFSocketFactory)object).socketAddressClass)) {
            return ((AFSocketFactory)object).connectTo(AFSocketAddress.mapOrFail((SocketAddress)var2_3, ((AFSocketFactory)object).socketAddressClass));
        }
        object = new Socket();
        ((Socket)object).connect((SocketAddress)var2_3);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        void var2_2;
        void var1_1;
        if (!this.isHostnameSupported(host)) {
            throw new SocketException("Unsupported hostname");
        }
        if (localPort < 0) {
            throw new IllegalArgumentException("Illegal local port");
        }
        return this.createSocket((String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Socket createSocket(InetAddress address, int port) throws IOException {
        void var2_2;
        void var1_1;
        if (!this.isInetAddressSupported(address)) {
            throw new SocketException("Unsupported address");
        }
        String hostname = address.getHostName();
        if (!this.isHostnameSupported(hostname)) {
            throw new SocketException("Unsupported hostname");
        }
        return this.createSocket((String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        void var2_2;
        void var1_1;
        if (!this.isInetAddressSupported(address)) {
            throw new SocketException("Unsupported address");
        }
        if (localPort < 0) {
            throw new IllegalArgumentException("Illegal local port");
        }
        return this.createSocket((InetAddress)var1_1, (int)var2_2);
    }

    @Override
    public boolean isHostnameSupported(String string) {
        return AFSocketAddressFromHostname$.isHostnameSupported$4ab7969b$24b91c42(string);
    }

    public static final class FixedAddressSocketFactory
    extends AFSocketFactory<AFSocketAddress> {
        private final SocketAddress forceAddr;

        @Override
        public final boolean isHostnameSupported(String host) {
            return true;
        }

        @Override
        public final SocketAddress addressFromHost(String host, int port) throws SocketException {
            return this.forceAddr;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Socket createSocket() throws SocketException {
            try {
                if (AFSocketAddress.canMap(this.forceAddr)) {
                    AFSocket<?> socket = AFSocketAddress.mapOrFail(this.forceAddr).getAddressFamily().newSocket();
                    socket.forceConnectAddress(this.forceAddr);
                    return socket;
                }
                return new Socket(this){
                    final /* synthetic */ FixedAddressSocketFactory this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    @Override
                    public void connect(SocketAddress endpoint) throws IOException {
                        1 v0 = this;
                        super.connect(v0.this$0.forceAddr);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void connect(SocketAddress endpoint, int timeout) throws IOException {
                        void var2_2;
                        1 v0 = this;
                        super.connect(v0.this$0.forceAddr, (int)var2_2);
                    }
                };
            }
            catch (SocketException socketException) {
                SocketException socket = socketException;
                throw socketException;
            }
            catch (IOException e) {
                void var1_3;
                throw (SocketException)new SocketException().initCause((Throwable)var1_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final Socket connectTo(AFSocketAddress addr) throws IOException {
            void var1_1;
            Socket sock = this.createSocket();
            sock.connect(this.forceAddr);
            return var1_1;
        }
    }
}

