/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFCore;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketOption;
import org.newsclub.net.unix.AFSupplier;
import org.newsclub.net.unix.AncillaryDataSupport;
import org.newsclub.net.unix.NamedInteger;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.pool.ObjectPool;

class AFSocketCore
extends AFCore {
    private final AtomicInteger pendingAccepts = new AtomicInteger(0);
    final AtomicLong inode = new AtomicLong(-1L);
    AFSocketAddress socketAddress;
    private final AFAddressFamily<?> af;
    private boolean shutdownOnClose = true;

    /*
     * WARNING - void declaration
     */
    protected AFSocketCore(Object observed, FileDescriptor fd, AncillaryDataSupport ancillaryDataSupport, AFAddressFamily<?> af, boolean datagramMode) {
        super(var1_1, (FileDescriptor)var2_2, (AncillaryDataSupport)var3_3, datagramMode);
        void var3_3;
        void var2_2;
        void var1_1;
        this.af = af;
    }

    protected final AFAddressFamily<?> addressFamily() {
        return this.af;
    }

    @Override
    protected final void doClose() throws IOException {
        AFSocketCore aFSocketCore = this;
        if (aFSocketCore.shutdownOnClose) {
            NativeUnixSocket.shutdown(this.fd, 2);
            this.unblockAccepts();
        }
        super.doClose();
    }

    protected void unblockAccepts() {
    }

    /*
     * WARNING - void declaration
     */
    final AFSocketAddress receive(ByteBuffer dst, AFSupplier<Integer> socketTimeout) throws IOException {
        ObjectPool.Lease<ByteBuffer> socketAddressBufferLease = AFSocketAddress.SOCKETADDRESS_BUFFER_TL.take();
        try {
            void var2_5;
            void var1_1;
            ByteBuffer socketAddressBuffer = socketAddressBufferLease.get();
            int n = this.read((ByteBuffer)var1_1, (AFSupplier<Integer>)var2_5, socketAddressBuffer, 0);
            if (n > 0) {
                Object obj = AFSocketAddress.ofInternal(socketAddressBuffer, this.af);
                if (socketAddressBufferLease != null) {
                    socketAddressBufferLease.close();
                }
                return obj;
            }
            if (socketAddressBufferLease != null) {
                socketAddressBufferLease.close();
            }
            return null;
        }
        catch (Throwable throwable) {
            if (socketAddressBufferLease != null) {
                try {
                    void var3_6;
                    var3_6.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean isConnected(boolean boundOk) {
        try {
            if (this.fd.valid()) {
                switch (NativeUnixSocket.socketStatus(this.fd)) {
                    case 2: {
                        return true;
                    }
                    case 1: {
                        if (!boundOk) break;
                        return true;
                    }
                }
            }
        }
        catch (IOException e) {
            void var1_2;
            throw new IllegalStateException((Throwable)var1_2);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final <T> T getOption(AFSocketOption<T> name) throws IOException {
        void var2_4;
        void var1_1;
        Class<T> type = name.type();
        if (Boolean.class.isAssignableFrom(type)) {
            return (T)Boolean.valueOf(NativeUnixSocket.getSocketOption(this.fd, name.level(), name.optionName(), Integer.class) != 0);
        }
        if (NamedInteger.HasOfValue.class.isAssignableFrom(type)) {
            int v = NativeUnixSocket.getSocketOption(this.fd, name.level(), name.optionName(), Integer.class);
            try {
                return (T)type.getMethod("ofValue", Integer.TYPE).invoke(null, v);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                void var1_3;
                throw new IOException("Value casting problem", (Throwable)var1_3);
            }
        }
        return NativeUnixSocket.getSocketOption(this.fd, var1_1.level(), var1_1.optionName(), var2_4);
    }

    /*
     * WARNING - void declaration
     */
    final <T> void setOption(AFSocketOption<T> name, T value) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        Integer val;
        if (value instanceof Boolean) {
            val = (Boolean)value != false ? 1 : 0;
        } else if (val instanceof NamedInteger) {
            val = ((NamedInteger)((Object)val)).value();
        }
        int level = name.level();
        int optionName = name.optionName();
        NativeUnixSocket.setSocketOption(this.fd, level, optionName, var2_3);
        if (var3_4 == 271 && var1_2 == 135) {
            try {
                Thread.sleep(1L);
                return;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected final void incPendingAccepts() throws SocketException {
        if (this.pendingAccepts.incrementAndGet() >= Integer.MAX_VALUE) {
            this.pendingAccepts.decrementAndGet();
            throw new SocketException("Too many pending accepts");
        }
    }

    protected final void decPendingAccepts() {
        this.pendingAccepts.decrementAndGet();
    }

    protected final boolean hasPendingAccepts() {
        return this.pendingAccepts.get() > 0;
    }

    final boolean isShutdownOnClose() {
        return this.shutdownOnClose;
    }
}

