/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.AFInputStream;
import org.newsclub.net.unix.AFOutputStream;
import org.newsclub.net.unix.AFSocket$$Lambda$1;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketAddressFromHostname;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketChannel;
import org.newsclub.net.unix.AFSocketExtensions;
import org.newsclub.net.unix.AFSocketFactory;
import org.newsclub.net.unix.AFSocketImpl;
import org.newsclub.net.unix.AFSomeSocket;
import org.newsclub.net.unix.Closeables;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.SentinelSocketAddress;
import org.newsclub.net.unix.SocketAddressFilter;
import org.newsclub.net.unix.SocketClosedException;

public abstract class AFSocket<A extends AFSocketAddress>
extends Socket
implements AFSocketExtensions,
AFSomeSocket {
    private static final byte[] ZERO_BYTES = new byte[0];
    static String loadedLibrary;
    private static Integer capabilitiesValue;
    private final AFSocketImpl<A> impl;
    private final AFSocketAddressFromHostname<A> afh;
    private final Closeables closeables = new Closeables();
    private final AtomicBoolean created = new AtomicBoolean(false);
    private final AFSocketChannel<A> channel = this.newChannel();
    private @Nullable SocketAddressFilter connectFilter;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    protected AFSocket(AFSocketImpl impl, AFSocketFactory afh) throws SocketException {
        super(impl);
        void var1_1;
        void var2_2;
        this.afh = var2_2;
        this.impl = var1_1;
    }

    private Class<? extends AFSocketAddress> socketAddressClass() {
        return this.getAFImpl(false).getAddressFamily().getSocketAddressClass();
    }

    protected abstract AFSocketChannel<A> newChannel();

    /*
     * WARNING - void declaration
     */
    protected static final <A extends AFSocketAddress> AFSocket<A> newInstance(Constructor<A> constr, AFSocketFactory<A> factory) throws SocketException {
        void var1_1;
        Constructor<A> constructor = null;
        constructor = constr;
        return constructor.newInstance(null, (AFSocketFactory<A>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void bind(SocketAddress bindpoint) throws IOException {
        void var1_1;
        if (bindpoint == null) {
            throw new IllegalArgumentException();
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        this.preprocessSocketAddress((SocketAddress)var1_1);
        throw new SocketException("Use AF*ServerSocket#bind or #bindOn");
    }

    @Override
    public final boolean isBound() {
        return this.impl.getFD().valid() && (super.isBound() || this.impl.isBound());
    }

    @Override
    public final boolean isConnected() {
        return this.impl.getFD().valid() && (super.isConnected() || this.impl.isConnected());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void connect(SocketAddress endpoint) throws IOException {
        void var1_1;
        this.connect((SocketAddress)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void connect(SocketAddress endpoint, int timeout) throws IOException {
        void var2_2;
        void var1_1;
        this.connect0((SocketAddress)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private AFSocketAddress preprocessSocketAddress(SocketAddress endpoint) throws SocketException {
        void var1_1;
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint is null");
        }
        if (endpoint instanceof SentinelSocketAddress) {
            return (AFSocketAddress)endpoint;
        }
        return AFSocketAddress.preprocessSocketAddress(this.socketAddressClass(), (SocketAddress)var1_1, this.afh);
    }

    /*
     * WARNING - void declaration
     */
    final boolean connect0(SocketAddress endpoint, int timeout) throws IOException {
        void var2_3;
        int port;
        AFSocket aFSocket;
        boolean success;
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.connectFilter != null) {
            endpoint = this.connectFilter.apply(endpoint);
        }
        AFSocketAddress address = this.preprocessSocketAddress(endpoint);
        if (!this.isBound()) {
            this.internalDummyBind();
        }
        if ((success = (aFSocket = this).getAFImpl(true).connect0(address, timeout)) && (port = address.getPort()) > 0) {
            void var1_2;
            aFSocket = this;
            aFSocket.getAFImpl(true).updatePorts(this.getLocalPort(), (int)var1_2);
        }
        this.internalDummyConnect();
        return (boolean)var2_3;
    }

    private void internalDummyConnect() throws IOException {
        if (!this.isConnected()) {
            super.connect(AFSocketAddress.INTERNAL_DUMMY_CONNECT, 0);
        }
    }

    private void internalDummyBind() throws IOException {
        if (!this.isBound()) {
            super.bind(AFSocketAddress.INTERNAL_DUMMY_BIND);
        }
    }

    @Override
    public final String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + this.toStringSuffix();
    }

    final String toStringSuffix() {
        if (this.impl.getFD().valid()) {
            return "[local=" + this.getLocalSocketAddress() + ";remote=" + this.getRemoteSocketAddress() + "]";
        }
        return "[invalid]";
    }

    @Override
    public final boolean isClosed() {
        return super.isClosed() || this.isConnected() && !this.impl.getFD().valid() || this.impl.isClosed();
    }

    private static synchronized int capabilities() {
        if (capabilitiesValue == null) {
            int n;
            if (!NativeUnixSocket.isLoaded()) {
                n = 0;
            } else {
                int n2 = NativeUnixSocket.capabilities();
                if (System.getProperty("osv.version") != null) {
                    n2 &= ~AFSocketCapability.CAPABILITY_FD_AS_REDIRECT.getBitmask();
                }
                for (AFSocketCapability aFSocketCapability : AFSocketCapability.values()) {
                    AFSocketCapability aFSocketCapability2 = aFSocketCapability;
                    if (!Boolean.parseBoolean(System.getProperty("org.newsclub.net.unix.library.disable." + aFSocketCapability2.name(), "false"))) continue;
                    n2 &= ~aFSocketCapability.getBitmask();
                }
                n = n2;
            }
            capabilitiesValue = n;
        }
        return capabilitiesValue;
    }

    public static final boolean supports(AFSocketCapability capability) {
        AFSocketCapability aFSocketCapability;
        return (AFSocket.capabilities() & aFSocketCapability.getBitmask()) != 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void close() throws IOException {
        void var1_1;
        IOException superException = null;
        try {
            super.close();
        }
        catch (IOException iOException) {
            superException = iOException;
            superException = iOException;
        }
        this.closeables.close((IOException)var1_1);
    }

    final AFSocketImpl<A> getAFImpl(boolean createSocket) {
        if (createSocket && this.created.compareAndSet(false, true)) {
            try {
                this.getSoTimeout();
            }
            catch (SocketException socketException) {}
        }
        return this.impl;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AFSocketChannel<A> getChannel() {
        return this.channel;
    }

    public final synchronized A getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return this.impl.getRemoteSocketAddress();
    }

    public final A getLocalSocketAddress() {
        if (this.isClosed()) {
            return null;
        }
        return this.impl.getLocalSocketAddress();
    }

    public final FileDescriptor getFileDescriptor() throws IOException {
        return this.impl.getFileDescriptor();
    }

    @Override
    public final AFInputStream getInputStream() throws IOException {
        AFSocket aFSocket = this;
        return aFSocket.getAFImpl(true).getInputStream();
    }

    @Override
    public final AFOutputStream getOutputStream() throws IOException {
        AFSocket aFSocket = this;
        return aFSocket.getAFImpl(true).getOutputStream();
    }

    public final AFSocket<A> forceConnectAddress(SocketAddress endpoint) {
        AFSocket aFSocket;
        AFSocket$$Lambda$1 aFSocket$$Lambda$1 = AFSocket$$Lambda$1.lambdaFactory$$7152148c((SocketAddress)((Object)aFSocket));
        aFSocket = this;
        this.connectFilter = aFSocket$$Lambda$1;
        return aFSocket;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkConnectionClosed() throws IOException {
        if (!this.isConnected()) {
            return true;
        }
        try {
            if (!AFSocket.supports(AFSocketCapability.CAPABILITY_ZERO_LENGTH_SEND)) {
                return false;
            }
            this.getOutputStream().write(ZERO_BYTES);
            return false;
        }
        catch (SocketClosedException socketClosedException) {
            return true;
        }
        catch (IOException e) {
            void var1_1;
            if (!this.isConnected()) {
                return true;
            }
            throw var1_1;
        }
    }

    static /* synthetic */ SocketAddress lambda$forceConnectAddress$0(SocketAddress endpoint, SocketAddress orig) throws IOException {
        SocketAddress socketAddress;
        if (orig == null) {
            return null;
        }
        return socketAddress;
    }

    static {
        capabilitiesValue = null;
    }

    @FunctionalInterface
    public static interface Constructor<A extends AFSocketAddress> {
        public @NonNull AFSocket<A> newInstance(FileDescriptor var1, AFSocketFactory<A> var2) throws SocketException;
    }
}

