/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.ProtocolFamily;
import java.net.StandardProtocolFamily;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Objects;
import org.newsclub.net.unix.AFDatagramChannel;
import org.newsclub.net.unix.AFPipe;
import org.newsclub.net.unix.AFProtocolFamily;
import org.newsclub.net.unix.AFSelector;
import org.newsclub.net.unix.AFServerSocketChannel;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketChannel;
import org.newsclub.net.unix.SelectorProviderShim;

public abstract class AFSelectorProvider<A extends AFSocketAddress>
extends SelectorProviderShim {
    private static final SelectorProvider AF_PROVIDER = new SelectorProviderShim(){

        @Override
        public SocketChannel openSocketChannel() throws IOException {
            throw new UnsupportedOperationException("Use openSocketChannel(ProtocolFamily) or a specific AFSelectorProvider subclass");
        }

        @Override
        public ServerSocketChannel openServerSocketChannel() throws IOException {
            throw new UnsupportedOperationException("Use openServerSocketChannel(ProtocolFamily) or a specific AFSelectorProvider subclass");
        }

        @Override
        public DatagramChannel openDatagramChannel() throws IOException {
            throw new UnsupportedOperationException("Use openDatagramChannel(ProtocolFamily) or a specific AFSelectorProvider subclass");
        }

        @Override
        public AbstractSelector openSelector() throws IOException {
            throw new UnsupportedOperationException("Use a specific AFSelectorProvider subclass");
        }

        @Override
        public Pipe openPipe() throws IOException {
            throw new UnsupportedOperationException("Use a specific AFSelectorProvider subclass");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public DatagramChannel openDatagramChannel(ProtocolFamily family) throws IOException {
            Objects.requireNonNull(family);
            if (family instanceof AFProtocolFamily) {
                void var1_1;
                return ((AFProtocolFamily)var1_1).openDatagramChannel$13a8aedd();
            }
            throw new UnsupportedOperationException("Unsupported protocol family");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SocketChannel openSocketChannel(ProtocolFamily family) throws IOException {
            Objects.requireNonNull(family);
            if (family instanceof AFProtocolFamily) {
                void var1_1;
                return ((AFProtocolFamily)var1_1).openSocketChannel$68d663eb();
            }
            throw new UnsupportedOperationException("Unsupported protocol family");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ServerSocketChannel openServerSocketChannel(ProtocolFamily family) throws IOException {
            Objects.requireNonNull(family);
            if (family instanceof AFProtocolFamily) {
                void var1_1;
                return ((AFProtocolFamily)var1_1).openServerSocketChannel$19a60eb8();
            }
            throw new UnsupportedOperationException("Unsupported protocol family");
        }
    };

    protected AFSelectorProvider() {
    }

    /*
     * WARNING - void declaration
     */
    private AFPipe newPipe(boolean selectable) throws IOException {
        void var1_1;
        return new AFPipe(this, (boolean)var1_1);
    }

    protected abstract AFSocket<A> newSocket() throws IOException;

    protected abstract ProtocolFamily protocolFamily();

    @Override
    public abstract AFDatagramChannel<A> openDatagramChannel() throws IOException;

    final AFPipe openSelectablePipe() throws IOException {
        return this.newPipe(true);
    }

    @Override
    public final AbstractSelector openSelector() throws IOException {
        return new AFSelector(this);
    }

    @Override
    public abstract AFServerSocketChannel<A> openServerSocketChannel() throws IOException;

    @Override
    public AFSocketChannel<A> openSocketChannel() throws IOException {
        return this.newSocket().getChannel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AFDatagramChannel<A> openDatagramChannel(ProtocolFamily family) throws IOException {
        void var1_1;
        Objects.requireNonNull(family);
        if (this.protocolFamily().equals(family) || family instanceof StandardProtocolFamily && this.protocolFamily().name().equals(var1_1.name())) {
            return this.openDatagramChannel();
        }
        throw new UnsupportedOperationException("Protocol family not supported");
    }
}

