/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.newsclub.net.unix.AFPipe;
import org.newsclub.net.unix.AFSelectionKey;
import org.newsclub.net.unix.AFSelector$$Lambda$1;
import org.newsclub.net.unix.AFSelector$$Lambda$2;
import org.newsclub.net.unix.AFSelectorProvider;
import org.newsclub.net.unix.AFUNIXSelectorProvider;
import org.newsclub.net.unix.MapValueSet;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.StackTraceUtil;
import org.newsclub.net.unix.ThreadUtil;
import org.newsclub.net.unix.UngrowableSet;
import org.newsclub.net.unix.VirtualThreadPoller;

final class AFSelector
extends AbstractSelector {
    private final AFPipe selectorPipe;
    private final PollFd selectorPipePollFd;
    private final ByteBuffer pipeMsgWakeUp = ByteBuffer.allocate(1);
    private final ByteBuffer pipeMsgReceiveBuffer = ByteBuffer.allocateDirect(256);
    private final Map<AFSelectionKey, Integer> keysRegistered = new ConcurrentHashMap<AFSelectionKey, Integer>();
    private final Set<AFSelectionKey> keysRegisteredKeySet = this.keysRegistered.keySet();
    private final Set<SelectionKey> keysRegisteredPublic = Collections.unmodifiableSet(this.keysRegisteredKeySet);
    private final AtomicInteger selectCount;
    private final MapValueSet<SelectionKey, Integer> selectedKeysSet;
    private final Set<SelectionKey> selectedKeysPublic;
    private PollFd pollFd;

    /*
     * WARNING - void declaration
     */
    AFSelector(AFSelectorProvider<?> provider) throws IOException {
        super((SelectorProvider)var1_1);
        void var1_1;
        AtomicInteger atomicInteger = this.selectCount = new AtomicInteger(0);
        Objects.requireNonNull(atomicInteger);
        this.selectedKeysSet = new MapValueSet<AFSelectionKey, Integer>(this.keysRegistered, AFSelector$$Lambda$1.lambdaFactory$$37a956d6(atomicInteger), 0);
        this.selectedKeysPublic = new UngrowableSet<SelectionKey>(this.selectedKeysSet);
        this.pollFd = null;
        this.selectorPipe = AFUNIXSelectorProvider.getInstance().openSelectablePipe();
        this.selectorPipePollFd = new PollFd(this.selectorPipe.sourceFD());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        void var1_1;
        void var3_5;
        void var2_3;
        AFSelectionKey key = new AFSelectionKey(this, ch, (int)var2_3, var3_5);
        AFSelector aFSelector = this;
        synchronized (aFSelector) {
            this.pollFd = null;
            this.selectedKeysSet.markRemoved(key);
        }
        return var1_1;
    }

    @Override
    public final Set<SelectionKey> keys() {
        return this.keysRegisteredPublic;
    }

    @Override
    public final Set<SelectionKey> selectedKeys() {
        return this.selectedKeysPublic;
    }

    @Override
    public final int selectNow() throws IOException {
        return this.select0(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int select(long timeout) throws IOException {
        void var1_1;
        if (timeout > Integer.MAX_VALUE) {
            timeout = Integer.MAX_VALUE;
        } else if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        return this.select0((int)var1_1);
    }

    @Override
    public final int select() throws IOException {
        try {
            return this.select0(-1);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int select0(int timeout) throws IOException {
        int num;
        PollFd pfd;
        AFSelector aFSelector = this;
        int n = aFSelector.selectCount.incrementAndGet();
        if (n == 0) {
            aFSelector.selectedKeysSet.markAllRemoved();
            n = aFSelector.selectCount.incrementAndGet();
        }
        AFSelector aFSelector2 = this;
        synchronized (aFSelector2) {
            if (!this.isOpen()) {
                throw new ClosedSelectorException();
            }
            pfd = this.pollFd = this.initPollFd(this.pollFd);
        }
        try {
            void var1_1;
            this.begin();
            num = NativeUnixSocket.poll(pfd, (int)var1_1);
        }
        finally {
            this.end();
        }
        AFSelector aFSelector3 = this;
        synchronized (aFSelector3) {
            int n2;
            pfd = this.pollFd;
            if (pfd != null) {
                AFSelectionKey[] keys = pfd.keys;
                if (pfd.keys != null) {
                    AFSelectionKey[] aFSelectionKeyArray = keys;
                    n2 = keys.length;
                    for (int i = 0; i < n2; ++i) {
                        SelectableChannel ch;
                        AFSelectionKey key = aFSelectionKeyArray[i];
                        if (key == null || !key.hasOpInvalid() || (ch = key.channel()) == null || !ch.isOpen()) continue;
                        ch.close();
                    }
                }
            }
            if (num > 0) {
                this.consumeAllBytesAfterPoll();
                int n3 = n;
                AFSelector aFSelector4 = aFSelector;
                aFSelector = this;
                if (aFSelector4 != null) {
                    for (int i = 1; i < ((PollFd)((Object)aFSelector4)).rops.length; ++i) {
                        n2 = ((PollFd)((Object)aFSelector4)).rops[i];
                        AFSelectionKey aFSelectionKey = ((PollFd)((Object)aFSelector4)).keys[i];
                        aFSelectionKey.setOpsReady(n2);
                        if (n2 == 0 || !aFSelector.keysRegistered.containsKey(aFSelectionKey)) continue;
                        aFSelector.keysRegistered.put(aFSelectionKey, n3);
                    }
                }
            }
            return this.selectedKeysSet.size();
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void consumeAllBytesAfterPoll() throws IOException {
        void var2_6;
        int maxReceive;
        if (this.pollFd == null) {
            return;
        }
        if ((this.pollFd.rops[0] & 1) == 0) {
            return;
        }
        int options = this.selectorPipe.getOptions();
        ByteBuffer byteBuffer = this.pipeMsgReceiveBuffer;
        synchronized (byteBuffer) {
            this.pipeMsgReceiveBuffer.clear();
            maxReceive = this.pipeMsgReceiveBuffer.remaining();
            int bytesReceived = this.receive(maxReceive, options);
        }
        if (var2_6 == maxReceive && maxReceive > 0) {
            int read;
            do {
                if ((read = NativeUnixSocket.poll(this.selectorPipePollFd, 0)) <= 0) continue;
                ByteBuffer byteBuffer2 = this.pipeMsgReceiveBuffer;
                synchronized (byteBuffer2) {
                    this.pipeMsgReceiveBuffer.clear();
                    read = this.receive(maxReceive, options);
                }
            } while (read == maxReceive && read > 0);
        }
    }

    private int receive(int maxReceive, int options) throws IOException {
        int count;
        long now;
        boolean virtualBlocking = ThreadUtil.isVirtualThread();
        if (virtualBlocking) {
            now = System.currentTimeMillis();
            options |= 4;
        } else {
            now = 0L;
        }
        FileDescriptor fdesc = this.selectorPipePollFd.fds[0];
        boolean park = false;
        while (true) {
            if (virtualBlocking) {
                if (park) {
                    VirtualThreadPoller.INSTANCE.parkThreadUntilReady(fdesc, 4, now, AFPipe.DUMMY_TIMEOUT, AFSelector$$Lambda$2.lambdaFactory$$63df8621(this));
                }
                NativeUnixSocket.configureBlocking(fdesc, false);
            }
            try {
                count = NativeUnixSocket.receive(fdesc, this.pipeMsgReceiveBuffer, 0, maxReceive, null, options, null, 1);
                if (count != 0 || !virtualBlocking) break;
                count = 1;
                continue;
            }
            catch (SocketTimeoutException e2) {
                if (virtualBlocking) {
                    boolean e2 = true;
                    continue;
                }
                throw e2;
            }
            finally {
                if (!virtualBlocking) continue;
                NativeUnixSocket.configureBlocking(fdesc, true);
                continue;
            }
            break;
        }
        return count;
    }

    /*
     * WARNING - void declaration
     */
    private PollFd initPollFd(PollFd existingPollFd) throws IOException {
        AFSelector aFSelector = this;
        synchronized (aFSelector) {
            void var1_1;
            Iterator<AFSelectionKey> it = this.keysRegisteredKeySet.iterator();
            while (it.hasNext()) {
                AFSelectionKey key = it.next();
                if (!key.getAFCore().fd.valid() || !key.isValid()) {
                    key.cancelNoRemove();
                    it.remove();
                    existingPollFd = null;
                    continue;
                }
                key.setOpsReady(0);
            }
            if (existingPollFd != null && existingPollFd.keys != null && existingPollFd.keys.length - 1 == this.keysRegistered.size()) {
                boolean needsUpdate = false;
                int i = 1;
                for (AFSelectionKey key : this.keysRegisteredKeySet) {
                    if (existingPollFd.keys[i] != key || !key.isValid()) {
                        needsUpdate = true;
                        break;
                    }
                    existingPollFd.ops[i] = key.interestOps();
                    ++i;
                }
                if (!needsUpdate) {
                    return existingPollFd;
                }
            }
            int keysToPoll = this.keysRegistered.size();
            for (AFSelectionKey aFSelectionKey : this.keysRegisteredKeySet) {
                if (aFSelectionKey.isValid()) continue;
                --keysToPoll;
            }
            int size = keysToPoll + 1;
            FileDescriptor[] fileDescriptorArray = new FileDescriptor[size];
            int[] ops = new int[size];
            AFSelectionKey[] keys = new AFSelectionKey[size];
            fileDescriptorArray[0] = this.selectorPipe.sourceFD();
            ops[0] = 1;
            int i = 1;
            for (AFSelectionKey key : this.keysRegisteredKeySet) {
                if (!key.isValid()) continue;
                keys[i] = key;
                fileDescriptorArray[i] = key.getAFCore().fd;
                ops[i] = key.interestOps();
                ++i;
            }
            return new PollFd((AFSelectionKey[])var1_1, fileDescriptorArray, ops);
        }
    }

    @Override
    protected final void implCloseSelector() throws IOException {
        SelectionKey selectionKey;
        this.wakeup();
        Object object = this;
        synchronized (object) {
            Set<SelectionKey> keys = this.keys();
            this.keysRegistered.clear();
        }
        object = selectionKey.iterator();
        while (object.hasNext()) {
            selectionKey = (SelectionKey)object.next();
            ((AFSelectionKey)selectionKey).cancelNoRemove();
        }
        this.selectorPipe.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Selector wakeup() {
        if (this.isOpen()) {
            try {
                ByteBuffer byteBuffer = this.pipeMsgWakeUp;
                synchronized (byteBuffer) {
                    block8: {
                        this.pipeMsgWakeUp.clear();
                        try {
                            this.selectorPipe.sink().write(this.pipeMsgWakeUp);
                        }
                        catch (SocketException e) {
                            void var2_3;
                            if (!this.selectorPipe.sinkFD().valid()) break block8;
                            throw var2_3;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                StackTraceUtil.printStackTrace(iOException);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    final synchronized void remove(AFSelectionKey key) {
        this.selectedKeysSet.remove(key);
        try {
            void var1_1;
            NativeUnixSocket.deregisterSelectionKey((AbstractSelectableChannel)var1_1.channel(), (SelectionKey)var1_1);
        }
        catch (ClassCastException classCastException) {}
        this.pollFd = null;
    }

    static final class PollFd {
        final FileDescriptor[] fds;
        final int[] ops;
        final int[] rops;
        final AFSelectionKey[] keys;

        /*
         * WARNING - void declaration
         */
        PollFd(FileDescriptor pipeSourceFd) {
            this((FileDescriptor)var1_1, 1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private PollFd(FileDescriptor pipeSourceFd, int op) {
            void var1_1;
            this.fds = new FileDescriptor[]{var1_1};
            this.ops = new int[]{1};
            this.rops = new int[1];
            this.keys = null;
        }

        /*
         * WARNING - void declaration
         */
        PollFd(FileDescriptor[] fds, int[] ops) {
            this(null, (FileDescriptor[])var1_1, (int[])var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        PollFd(AFSelectionKey[] keys, FileDescriptor[] fds, int[] ops) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.keys = var1_1;
            if (fds.length != ops.length) {
                throw new IllegalStateException();
            }
            this.fds = var2_2;
            this.ops = ops;
            this.rops = new int[((void)var3_3).length];
        }
    }
}

