/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFDatagramSocketImpl$$Lambda$1;
import org.newsclub.net.unix.AFDatagramSocketImpl$$Lambda$2;
import org.newsclub.net.unix.AFDatagramSocketImpl$$Lambda$3;
import org.newsclub.net.unix.AFDatagramSocketImpl$$Lambda$4;
import org.newsclub.net.unix.AFDatagramSocketImpl$$Lambda$5;
import org.newsclub.net.unix.AFDatagramSocketImpl$$Lambda$6;
import org.newsclub.net.unix.AFDatagramSocketImpl$$Lambda$7;
import org.newsclub.net.unix.AFDatagramSocketImpl$$Lambda$8;
import org.newsclub.net.unix.AFInetAddress;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketCore;
import org.newsclub.net.unix.AFSocketImpl;
import org.newsclub.net.unix.AFSocketImplExtensions;
import org.newsclub.net.unix.AFSocketType;
import org.newsclub.net.unix.AncillaryDataSupport;
import org.newsclub.net.unix.DatagramSocketImplShim;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.SocketClosedException;
import org.newsclub.net.unix.StackTraceUtil;
import org.newsclub.net.unix.ThreadUtil;
import org.newsclub.net.unix.VirtualThreadPoller;
import org.newsclub.net.unix.pool.MutableHolder;
import org.newsclub.net.unix.pool.ObjectPool;

public abstract class AFDatagramSocketImpl<A extends AFSocketAddress>
extends DatagramSocketImplShim {
    private final AFSocketType socketType;
    private final AFSocketCore core;
    final AncillaryDataSupport ancillaryDataSupport = new AncillaryDataSupport();
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final AtomicBoolean bound = new AtomicBoolean(false);
    private final AtomicInteger socketTimeout = new AtomicInteger(0);
    private int localPort;
    private int remotePort = 0;
    private final AFAddressFamily<@NonNull A> addressFamily;
    private AFSocketImplExtensions<A> implExtensions = null;

    /*
     * WARNING - void declaration
     */
    protected AFDatagramSocketImpl(AFAddressFamily<@NonNull A> addressFamily, FileDescriptor fd, AFSocketType socketType) {
        void var2_2;
        void var3_3;
        AFDatagramSocketImpl aFDatagramSocketImpl;
        this.addressFamily = aFDatagramSocketImpl;
        this.socketType = var3_3;
        aFDatagramSocketImpl = this;
        this.core = new AFSocketCore(this, (FileDescriptor)var2_2, this.ancillaryDataSupport, aFDatagramSocketImpl.addressFamily, true);
        this.fd = this.core.fd;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void create() throws SocketException {
        Object object = this;
        if (((AFDatagramSocketImpl)object).core.isClosed()) {
            throw new SocketException("Already closed");
        }
        if (this.fd.valid()) {
            return;
        }
        try {
            object = this;
            NativeUnixSocket.createSocket(this.fd, ((AFDatagramSocketImpl)object).addressFamily.getDomain(), this.socketType.getId());
            return;
        }
        catch (SocketException socketException) {
            object = socketException;
            throw socketException;
        }
        catch (IOException e) {
            void var1_2;
            throw (SocketException)new SocketException(e.getMessage()).initCause((Throwable)var1_2);
        }
    }

    @Override
    protected final void close() {
        this.core.runCleaner();
    }

    @Override
    protected final void connect(InetAddress address, int port) throws SocketException {
    }

    /*
     * WARNING - void declaration
     */
    final void connect(AFSocketAddress socketAddress2) throws IOException {
        void var1_1;
        if (socketAddress2 == AFSocketAddress.INTERNAL_DUMMY_CONNECT) {
            return;
        }
        ObjectPool.Lease<ByteBuffer> abLease = socketAddress2.getNativeAddressDirectBuffer();
        try {
            void var3_4;
            ByteBuffer ab = abLease.get();
            NativeUnixSocket.connect(ab, var3_4.limit(), this.fd, -1L);
            if (abLease != null) {
                abLease.close();
            }
        }
        catch (Throwable throwable) {
            if (abLease != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable socketAddress2) {
                    throwable.addSuppressed(socketAddress2);
                }
            }
            throw throwable;
        }
        this.remotePort = var1_1.getPort();
    }

    @Override
    protected final void disconnect() {
        try {
            NativeUnixSocket.disconnect(this.fd);
            this.connected.set(false);
            this.remotePort = 0;
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            StackTraceUtil.printStackTrace(iOException);
            return;
        }
    }

    final AFSocketCore getCore() {
        return this.core;
    }

    @Override
    protected final FileDescriptor getFileDescriptor() {
        return this.core.fd;
    }

    final boolean isClosed() {
        return this.core.isClosed();
    }

    @Override
    protected final void bind(int lport, InetAddress laddr) throws SocketException {
    }

    /*
     * WARNING - void declaration
     */
    final void bind(AFSocketAddress socketAddress) throws SocketException {
        block12: {
            if (socketAddress == AFSocketAddress.INTERNAL_DUMMY_BIND) {
                return;
            }
            try {
                block11: {
                    ObjectPool.Lease<ByteBuffer> abLease = socketAddress == null ? AFSocketAddress.getNativeAddressDirectBuffer(0) : socketAddress.getNativeAddressDirectBuffer();
                    try {
                        void var3_6;
                        ByteBuffer ab = abLease.get();
                        NativeUnixSocket.bind(ab, var3_6.limit(), this.fd, 16);
                        if (socketAddress == null) {
                            this.localPort = 0;
                            this.bound.set(false);
                        } else {
                            void var1_1;
                            this.localPort = var1_1.getPort();
                        }
                        if (abLease == null) break block11;
                        abLease.close();
                        break block12;
                    }
                    catch (Throwable throwable) {
                        if (abLease != null) {
                            try {
                                abLease.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                return;
            }
            catch (SocketException socketException) {
                SocketException abLease = socketException;
                throw socketException;
            }
            catch (IOException e) {
                void var2_5;
                throw (SocketException)new SocketException(e.getMessage()).initCause((Throwable)var2_5);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void receive(DatagramPacket p) throws IOException {
        void var1_1;
        this.recv((DatagramPacket)var1_1, 0);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void recv(DatagramPacket p, int options) throws IOException {
        block29: {
            len = p.getLength();
            fdesc = this.core.validFdOrException();
            virtualBlocking = ThreadUtil.isVirtualThread() != false && this.core.isBlocking() != false || this.core.isVirtualBlocking() != false;
            now = virtualBlocking != false ? System.currentTimeMillis() : 0L;
            if (virtualBlocking || !this.core.isBlocking()) {
                options |= 4;
            }
            park = false;
            while (true) {
                if (virtualBlocking) {
                    if (park) {
                        v0 = this.socketTimeout;
                        Objects.requireNonNull(v0);
                        VirtualThreadPoller.INSTANCE.parkThreadUntilReady(fdesc, 4, now, AFDatagramSocketImpl$$Lambda$1.lambdaFactory$$4a6b66ab(v0), AFDatagramSocketImpl$$Lambda$2.lambdaFactory$$72902ccc(this));
                    }
                    this.core.configureVirtualBlocking(true);
                }
                try {
                    lease = AFSocketCore.getPrivateDirectByteBuffer(len);
                    socketAddressBufferLease = AFSocketAddress.SOCKETADDRESS_BUFFER_TL.take();
                    datagramPacketBuffer = Objects.requireNonNull(lease.get().get());
                    len = Math.min(len, datagramPacketBuffer.capacity());
                    socketAddressBuffer = socketAddressBufferLease.get();
                    count = NativeUnixSocket.receive(fdesc, (ByteBuffer)datagramPacketBuffer, 0, len, socketAddressBuffer, options, this.ancillaryDataSupport, this.socketTimeout.get());
                    if (count != 0 || !virtualBlocking) break;
                    datagramPacketBuffer = true;
                    if (socketAddressBufferLease != null) {
                        socketAddressBufferLease.close();
                    }
                    if (lease != null) {
                        lease.close();
                    }
                    if (!virtualBlocking) continue;
                }
                catch (SocketTimeoutException e) {
                    if (virtualBlocking) {
                        var8_8 = true;
                        if (!virtualBlocking) continue;
                        this.core.configureVirtualBlocking(false);
                        continue;
                    }
                    try {
                        throw e;
                    }
                    catch (Throwable var1_2) {
                        if (virtualBlocking == false) throw var1_2;
                        this.core.configureVirtualBlocking(false);
                        throw var1_2;
                    }
                }
                this.core.configureVirtualBlocking(false);
            }
            ** try [egrp 5[TRYBLOCK] [1 : 275->440)] { 
lbl54:
            // 1 sources

            if (count > len) {
                throw new IllegalStateException("count > len: " + count + " > " + len);
            }
            if (count == -1) {
                throw new SocketTimeoutException();
            }
            if (count < 0) {
                throw new IllegalStateException("count: " + count + " < 0");
            }
            break block29;
lbl61:
            // 1 sources

            finally {
                if (socketAddressBufferLease != null) {
                    socketAddressBufferLease.close();
                }
            }
        }
        datagramPacketBuffer.limit(count);
        datagramPacketBuffer.rewind();
        datagramPacketBuffer.get(p.getData(), p.getOffset(), count);
        p.setLength(count);
        datagramPacketBuffer = this;
        addr = AFSocketAddress.ofInternal(socketAddressBuffer, datagramPacketBuffer.addressFamily);
        p.setAddress(addr == null ? null : addr.getInetAddress());
        p.setPort(this.remotePort);
        if (virtualBlocking == false) return;
        this.core.configureVirtualBlocking(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    protected final void send(DatagramPacket p) throws IOException {
        ObjectPool.Lease<MutableHolder<ByteBuffer>> lease;
        int opt;
        long now;
        byte[] addrBytes;
        AFDatagramSocketImpl aFDatagramSocketImpl;
        InetAddress addr = p.getAddress();
        ByteBuffer sendToBuf = null;
        int sendToBufLen = 0;
        if (addr != null) {
            aFDatagramSocketImpl = this;
            addrBytes = AFInetAddress.unwrapAddress(addr, aFDatagramSocketImpl.addressFamily);
        } else {
            addrBytes = null;
        }
        try (ObjectPool.Lease<ByteBuffer> sendToBufLease = addrBytes == null ? null : AFSocketAddress.SOCKETADDRESS_BUFFER_TL.take();){
            if (sendToBufLease != null) {
                sendToBuf = sendToBufLease.get();
                aFDatagramSocketImpl = this;
                sendToBufLen = NativeUnixSocket.bytesToSockAddr(aFDatagramSocketImpl.addressFamily.getDomain(), sendToBuf, addrBytes);
                sendToBuf.position(0);
                if (sendToBufLen == -1) {
                    throw new SocketException("Unsupported domain");
                }
            }
        }
        FileDescriptor fdesc = this.core.validFdOrException();
        int len = p.getLength();
        boolean virtualBlocking = ThreadUtil.isVirtualThread() && this.core.isBlocking() || this.core.isVirtualBlocking();
        if (virtualBlocking) {
            now = System.currentTimeMillis();
            opt = 20;
        } else {
            now = 0L;
            opt = 16;
        }
        boolean park = false;
        while (true) {
            boolean bl;
            if (virtualBlocking) {
                if (park) {
                    AtomicInteger atomicInteger = this.socketTimeout;
                    Objects.requireNonNull(atomicInteger);
                    VirtualThreadPoller.INSTANCE.parkThreadUntilReady(fdesc, 4, now, AFDatagramSocketImpl$$Lambda$3.lambdaFactory$$4a6b66ab(atomicInteger), AFDatagramSocketImpl$$Lambda$4.lambdaFactory$$72902ccc(this));
                }
                this.core.configureVirtualBlocking(true);
            }
            try {
                lease = AFSocketCore.getPrivateDirectByteBuffer(len);
                try {
                    ByteBuffer datagramPacketBuffer = Objects.requireNonNull(lease.get().get());
                    datagramPacketBuffer.clear();
                    datagramPacketBuffer.put(p.getData(), p.getOffset(), p.getLength());
                    datagramPacketBuffer.flip();
                    int n = NativeUnixSocket.send(fdesc, datagramPacketBuffer, 0, len, sendToBuf, sendToBufLen, opt, this.ancillaryDataSupport);
                    if (n != 0 || !virtualBlocking) break;
                    bl = true;
                    if (lease != null) {
                        lease.close();
                    }
                    if (!virtualBlocking) continue;
                }
                catch (Throwable throwable) {
                    if (lease == null) throw throwable;
                    try {
                        lease.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SocketTimeoutException e) {
                if (virtualBlocking) {
                    bl = true;
                    if (!virtualBlocking) continue;
                    this.core.configureVirtualBlocking(false);
                    continue;
                }
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (!virtualBlocking) throw throwable;
                    this.core.configureVirtualBlocking(false);
                    throw throwable;
                }
            }
            this.core.configureVirtualBlocking(false);
        }
        if (lease != null) {
            lease.close();
        }
        if (!virtualBlocking) return;
        this.core.configureVirtualBlocking(false);
    }

    @Override
    protected final int peek(InetAddress i) throws IOException {
        throw new SocketException("Unsupported operation");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int peekData(DatagramPacket p) throws IOException {
        void var1_1;
        this.recv((DatagramPacket)var1_1, 2);
        return 0;
    }

    @Override
    @Deprecated
    protected final byte getTTL() throws IOException {
        return (byte)(this.getTimeToLive() & 0xFF);
    }

    @Override
    @Deprecated
    protected final void setTTL(byte ttl) throws IOException {
    }

    @Override
    protected final int getTimeToLive() throws IOException {
        return 0;
    }

    @Override
    protected final void setTimeToLive(int ttl) throws IOException {
    }

    @Override
    protected final void join(InetAddress inetaddr) throws IOException {
        throw new SocketException("Unsupported");
    }

    @Override
    protected final void leave(InetAddress inetaddr) throws IOException {
        throw new SocketException("Unsupported");
    }

    @Override
    protected final void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        throw new SocketException("Unsupported");
    }

    @Override
    protected final void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        throw new SocketException("Unsupported");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getOption(int optID) throws SocketException {
        void var1_1;
        Object object = this;
        if (((AFDatagramSocketImpl)object).core.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        FileDescriptor fileDescriptor = this.core.validFdOrException();
        object = fileDescriptor;
        object = this;
        return AFSocketImpl.getOptionDefault(fileDescriptor, (int)var1_1, this.socketTimeout, ((AFDatagramSocketImpl)object).addressFamily);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setOption(int optID, Object value) throws SocketException {
        void var2_2;
        void var1_1;
        Object object = this;
        if (((AFDatagramSocketImpl)object).core.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        object = this.core.validFdOrException();
        AFSocketImpl.setOptionDefault((FileDescriptor)object, (int)var1_1, var2_2, this.socketTimeout);
    }

    /*
     * WARNING - void declaration
     */
    final A receive(ByteBuffer dst) throws IOException {
        try {
            AtomicInteger atomicInteger = this.socketTimeout;
            Objects.requireNonNull(atomicInteger);
            return (A)this.core.receive(dst, AFDatagramSocketImpl$$Lambda$5.lambdaFactory$$4a6b66ab(atomicInteger));
        }
        catch (SocketClosedException e) {
            void var1_2;
            throw (ClosedChannelException)new ClosedChannelException().initCause((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    final int send(ByteBuffer src, SocketAddress target) throws IOException {
        try {
            void var2_3;
            AtomicInteger atomicInteger = this.socketTimeout;
            Objects.requireNonNull(atomicInteger);
            return this.core.write(src, AFDatagramSocketImpl$$Lambda$6.lambdaFactory$$4a6b66ab(atomicInteger), (SocketAddress)var2_3, 0);
        }
        catch (SocketClosedException e) {
            void var1_2;
            throw (ClosedChannelException)new ClosedChannelException().initCause((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    final int read(ByteBuffer dst, ByteBuffer socketAddressBuffer) throws IOException {
        try {
            AtomicInteger atomicInteger = this.socketTimeout;
            Objects.requireNonNull(atomicInteger);
            return this.core.read(dst, AFDatagramSocketImpl$$Lambda$7.lambdaFactory$$4a6b66ab(atomicInteger), null, 0);
        }
        catch (SocketClosedException e) {
            void var1_2;
            throw (ClosedChannelException)new ClosedChannelException().initCause((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    final int write(ByteBuffer src) throws IOException {
        try {
            AtomicInteger atomicInteger = this.socketTimeout;
            Objects.requireNonNull(atomicInteger);
            return this.core.write(src, AFDatagramSocketImpl$$Lambda$8.lambdaFactory$$4a6b66ab(atomicInteger));
        }
        catch (SocketClosedException e) {
            void var1_2;
            throw (ClosedChannelException)new ClosedChannelException().initCause((Throwable)var1_2);
        }
    }

    final boolean isConnected() {
        if (this.connected.get()) {
            return true;
        }
        AFDatagramSocketImpl aFDatagramSocketImpl = this;
        if (aFDatagramSocketImpl.core.isClosed()) {
            return false;
        }
        if (this.core.isConnected(false)) {
            this.connected.set(true);
            return true;
        }
        return false;
    }

    final boolean isBound() {
        if (this.bound.get()) {
            return true;
        }
        AFDatagramSocketImpl aFDatagramSocketImpl = this;
        if (aFDatagramSocketImpl.core.isClosed()) {
            return false;
        }
        if (this.core.isConnected(true)) {
            this.bound.set(true);
            return true;
        }
        return false;
    }

    final @Nullable A getLocalSocketAddress() {
        AFDatagramSocketImpl aFDatagramSocketImpl = this;
        return AFSocketAddress.getSocketAddress(this.getFileDescriptor(), false, this.localPort, aFDatagramSocketImpl.addressFamily);
    }

    final @Nullable A getRemoteSocketAddress() {
        AFDatagramSocketImpl aFDatagramSocketImpl = this;
        return AFSocketAddress.getSocketAddress(this.getFileDescriptor(), true, this.remotePort, aFDatagramSocketImpl.addressFamily);
    }

    protected final AFAddressFamily<@NonNull A> getAddressFamily() {
        return this.addressFamily;
    }
}

