/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.AFCore$$Lambda$1;
import org.newsclub.net.unix.AFCore$$Lambda$2;
import org.newsclub.net.unix.AFCore$$Lambda$3;
import org.newsclub.net.unix.AFCore$$Lambda$4;
import org.newsclub.net.unix.AFPipe;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSupplier;
import org.newsclub.net.unix.AncillaryDataSupport;
import org.newsclub.net.unix.CleanableState;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.SocketClosedException;
import org.newsclub.net.unix.ThreadUtil;
import org.newsclub.net.unix.VirtualThreadPoller;
import org.newsclub.net.unix.pool.MutableHolder;
import org.newsclub.net.unix.pool.ObjectPool;
import org.newsclub.net.unix.pool.ObjectPool$;

class AFCore
extends CleanableState {
    private static final ObjectPool<MutableHolder<ByteBuffer>> TL_BUFFER = ObjectPool$.newThreadLocalPool(AFCore$$Lambda$3.lambdaFactory$$2debf86b(), AFCore$$Lambda$4.lambdaFactory$$594992b4());
    private static final int TL_BUFFER_MAX_CAPACITY = Integer.parseInt(System.getProperty("org.newsclub.net.unix.thread-local-buffer.max-capacity", Integer.toString(0x100000)));
    private final AtomicBoolean closed = new AtomicBoolean(false);
    final FileDescriptor fd;
    final AncillaryDataSupport ancillaryDataSupport;
    private final boolean datagramMode;
    private final AtomicInteger virtualBlockingLeases = new AtomicInteger(0);
    private volatile boolean blocking = true;
    private boolean cleanFd = true;

    /*
     * WARNING - void declaration
     */
    AFCore(Object observed, FileDescriptor fd, AncillaryDataSupport ancillaryDataSupport, boolean datagramMode) {
        void var2_2;
        void var3_3;
        this.datagramMode = datagramMode;
        this.ancillaryDataSupport = var3_3;
        this.fd = fd == null ? new FileDescriptor() : var2_2;
    }

    /*
     * WARNING - void declaration
     */
    AFCore(AFPipe observed, FileDescriptor fd) {
        this(var1_1, (FileDescriptor)var2_2, null, false);
        void var2_2;
        void var1_1;
    }

    @Override
    protected final void doClean() {
        if (this.fd != null && this.fd.valid() && this.cleanFd) {
            try {
                this.doClose();
            }
            catch (IOException iOException) {}
        }
        if (this.ancillaryDataSupport != null) {
            this.ancillaryDataSupport.close();
        }
    }

    final boolean isClosed() {
        return this.closed.get();
    }

    void doClose() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            NativeUnixSocket.close(this.fd);
        }
    }

    /*
     * WARNING - void declaration
     */
    final FileDescriptor validFdOrException() throws SocketException {
        void var1_1;
        FileDescriptor fdesc = this.validFd();
        if (fdesc == null) {
            this.closed.set(true);
            throw new SocketClosedException("Not open");
        }
        return var1_1;
    }

    final synchronized FileDescriptor validFd() {
        AFCore aFCore = this;
        if (aFCore.closed.get()) {
            return null;
        }
        FileDescriptor descriptor = this.fd;
        if (descriptor != null && descriptor.valid()) {
            return aFCore;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    final int read(ByteBuffer dst, AFSupplier<Integer> timeout, ByteBuffer socketAddressBuffer, int options) throws IOException {
        block33: {
            remaining = dst.remaining();
            if (remaining == 0) {
                return 0;
            }
            fdesc = this.validFdOrException();
            dstPos = dst.position();
            direct = dst.isDirect();
            if (!ThreadUtil.isVirtualThread()) break block33;
            var8_12 = this;
            if (var8_12.blocking) ** GOTO lbl-1000
        }
        if (this.isVirtualBlocking()) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        virtualBlocking = v0;
        now = v0 != false ? System.currentTimeMillis() : 0L;
        if (virtualBlocking || !this.blocking) {
            options |= 4;
        }
        park = false;
        while (true) {
            if (virtualBlocking) {
                if (park) {
                    VirtualThreadPoller.INSTANCE.parkThreadUntilReady(fdesc, 4, now, timeout, AFCore$$Lambda$1.lambdaFactory$$5243771f(this));
                }
                this.configureVirtualBlocking(true);
            }
            lease = direct != false ? null : AFCore.getPrivateDirectByteBuffer(remaining);
            if (direct) {
                buf = dst;
                pos = dstPos;
            } else {
                buf = Objects.requireNonNull(Objects.requireNonNull(lease).get().get());
                remaining = Math.min(remaining, buf.remaining());
                pos = buf.position();
                buf.limit(pos + remaining);
            }
            try {
                count = NativeUnixSocket.receive(fdesc, (ByteBuffer)buf, pos, remaining, socketAddressBuffer, options, this.ancillaryDataSupport, 0);
                if (count != 0 || !virtualBlocking) break;
                buf = true;
                if (lease != null) {
                    lease.close();
                }
                if (!virtualBlocking) continue;
            }
            catch (AsynchronousCloseException v1) {
                pos = v1;
                throw v1;
            }
            catch (ClosedChannelException e) {
                buf = this;
                if (buf.closed.get()) {
                    throw e;
                }
                if (Thread.currentThread().isInterrupted() == false) throw (AsynchronousCloseException)new AsynchronousCloseException().initCause(e);
                throw (ClosedByInterruptException)new ClosedByInterruptException().initCause(e);
            }
            catch (SocketTimeoutException e) {
                if (virtualBlocking == false) throw e;
                buf = true;
                continue;
            }
            this.configureVirtualBlocking(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    final int write(ByteBuffer src, AFSupplier<Integer> timeout) throws IOException {
        void var2_2;
        void var1_1;
        return this.write((ByteBuffer)var1_1, (AFSupplier<Integer>)var2_2, null, 0);
    }

    /*
     * Unable to fully structure code
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    final int write(ByteBuffer src, AFSupplier<Integer> timeout, SocketAddress target, int options) throws IOException {
        remaining = src.remaining();
        if (remaining == 0) {
            return 0;
        }
        fdesc = this.validFdOrException();
        addressToLease = target == null ? null : AFSocketAddress.SOCKETADDRESS_BUFFER_TL.take();
        try {
            block31: {
                if (addressToLease == null) {
                    addressTo = null;
                    addressToLen = 0;
                } else {
                    addressTo = addressToLease.get();
                    addressToLen = AFSocketAddress.unwrapAddressDirectBufferInternal(addressTo, (SocketAddress)addressToLen);
                }
                pos = src.position();
                isDirect = src.isDirect();
                if (!ThreadUtil.isVirtualThread()) break block31;
                var11_15 = this;
                if (var11_15.blocking) ** GOTO lbl-1000
            }
            if (this.isVirtualBlocking()) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            virtualBlocking = v0;
            now = v0 != false ? System.currentTimeMillis() : 0L;
            if (virtualBlocking || !this.blocking) {
                options |= 4;
            }
            if (this.datagramMode) {
                options |= 16;
            }
            park = false;
            while (true) {
                if (virtualBlocking) {
                    if (park) {
                        VirtualThreadPoller.INSTANCE.parkThreadUntilReady(fdesc, 4, now, timeout, AFCore$$Lambda$2.lambdaFactory$$5243771f(this));
                    }
                    this.configureVirtualBlocking(true);
                }
                try {
                    lease = isDirect != false ? null : AFCore.getPrivateDirectByteBuffer(remaining);
                    try {
                        if (isDirect) {
                            buf = src;
                            bufPos = pos;
                        } else {
                            buf = Objects.requireNonNull(Objects.requireNonNull(lease).get().get());
                            remaining = Math.min(remaining, buf.remaining());
                            bufPos = buf.position();
                            while (src.hasRemaining() && buf.hasRemaining()) {
                                buf.put(src);
                            }
                            buf.position(bufPos);
                        }
                        written = NativeUnixSocket.send(fdesc, buf, bufPos, remaining, addressTo, addressToLen, options, this.ancillaryDataSupport);
                        if (written != 0 || !virtualBlocking) break;
                        written = 1;
                        continue;
                    }
                    finally {
                        if (lease == null) continue;
                        lease.close();
                        continue;
                    }
                }
                catch (SocketTimeoutException e) {
                    if (virtualBlocking) {
                        written = 1;
                        continue;
                    }
                    throw e;
                }
                finally {
                    if (!virtualBlocking) continue;
                    this.configureVirtualBlocking(false);
                    continue;
                }
                break;
            }
            var1_1.position(pos + written);
            var14_25 = written;
            return var14_25;
        }
        finally {
            if (addressToLease != null) {
                addressToLease.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static ObjectPool.Lease<MutableHolder<@NonNull ByteBuffer>> getPrivateDirectByteBuffer(int capacity) {
        void var1_1;
        void var3_3;
        ObjectPool.Lease<MutableHolder<ByteBuffer>> lease;
        MutableHolder<ByteBuffer> holder;
        ByteBuffer buffer;
        if (capacity > TL_BUFFER_MAX_CAPACITY && TL_BUFFER_MAX_CAPACITY > 0) {
            return ObjectPool$.unpooledLease$76b6208(new MutableHolder<ByteBuffer>(ByteBuffer.allocateDirect(capacity)));
        }
        if (capacity < 8192) {
            capacity = 8192;
        }
        if ((buffer = (holder = (lease = TL_BUFFER.take()).get()).get()) == null || capacity > buffer.capacity()) {
            void var2_2;
            int n;
            buffer = ByteBuffer.allocateDirect(n);
            var2_2.set(buffer);
        }
        var3_3.clear();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void implConfigureBlocking(boolean block) throws IOException {
        this.blocking = block;
        if (!block || !this.isVirtualBlocking()) {
            void var1_1;
            NativeUnixSocket.configureBlocking(this.validFdOrException(), (boolean)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    final void configureVirtualBlocking(boolean enabled) throws SocketException, IOException {
        int v;
        if (enabled) {
            v = this.virtualBlockingLeases.incrementAndGet();
            if (v > 0 && this.blocking) {
                NativeUnixSocket.configureBlocking(this.validFdOrException(), false);
            }
            if (v >= Integer.MAX_VALUE) {
                throw new IOException("blocking overflow");
            }
        } else {
            void var1_1;
            v = this.virtualBlockingLeases.decrementAndGet();
            if (v == 0 && this.blocking) {
                NativeUnixSocket.configureBlocking(this.validFdOrException(), true);
            }
            if (var1_1 < 0) {
                throw new IOException("blocking underflow");
            }
        }
    }

    final boolean isVirtualBlocking() {
        return this.virtualBlockingLeases.get() > 0;
    }

    final boolean isBlocking() {
        return this.blocking;
    }

    static /* synthetic */ boolean lambda$static$1(MutableHolder o) {
        ByteBuffer bb = (ByteBuffer)o.get();
        if (bb != null) {
            ByteBuffer byteBuffer;
            byteBuffer.clear();
        }
        return true;
    }

    static /* synthetic */ MutableHolder lambda$static$0() {
        return new MutableHolder<Object>(null);
    }
}

