/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.TLSRecordType;
import io.ktor.network.tls.cipher.CipherKt;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a?\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a?\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\r"}, d2={"Lio/ktor/network/tls/CipherSuite;", "suite", "", "keyMaterial", "Lio/ktor/network/tls/TLSRecordType;", "recordType", "", "recordLength", "", "recordIv", "recordId", "Ljavax/crypto/Cipher;", "gcmEncryptCipher", "(Lio/ktor/network/tls/CipherSuite;[BLio/ktor/network/tls/TLSRecordType;IJJ)Ljavax/crypto/Cipher;", "gcmDecryptCipher"})
@SourceDebugExtension(value={"SMAP\nGCMCipher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCMCipher.kt\nio/ktor/network/tls/cipher/GCMCipherKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class GCMCipherKt {
    /*
     * WARNING - void declaration
     */
    private static final Cipher gcmEncryptCipher(CipherSuite suite, byte[] keyMaterial, TLSRecordType recordType, int recordLength, long recordIv, long recordId) {
        Object object;
        void var3_3;
        void var1_1;
        void var2_2;
        Cipher cipher = Cipher.getInstance(suite.getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher);
        Cipher cipher2 = cipher;
        SecretKeySpec key = KeysKt.clientKey(keyMaterial, suite);
        keyMaterial = KeysKt.clientIV(keyMaterial, suite);
        byte[] byArray = Arrays.copyOf(keyMaterial, suite.getIvLength());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        byte[] iv = byArray;
        CipherKt.set(byArray, suite.getFixedIvLength(), recordIv);
        Object gcmSpec = new GCMParameterSpec(suite.getCipherTagSizeInBytes() * 8, iv);
        cipher2.init(1, (Key)key, (AlgorithmParameterSpec)gcmSpec);
        byte[] byArray2 = new byte[13];
        gcmSpec = byArray2;
        byte[] it = byArray2;
        CipherKt.set(byArray2, 0, recordId);
        it[8] = (byte)var2_2.getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set((byte[])var1_1, 11, (short)var3_3);
        cipher2.updateAAD((byte[])object);
        return cipher2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Cipher gcmDecryptCipher(CipherSuite suite, byte[] keyMaterial, TLSRecordType recordType, int recordLength, long recordIv, long recordId) {
        void var0_2;
        void var3_6;
        void var2_4;
        Object object;
        Cipher cipher = Cipher.getInstance(suite.getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher);
        Cipher cipher2 = cipher;
        SecretKeySpec key = KeysKt.serverKey(keyMaterial, suite);
        keyMaterial = KeysKt.serverIV(keyMaterial, suite);
        byte[] byArray = Arrays.copyOf(keyMaterial, suite.getIvLength());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        byte[] iv = byArray;
        CipherKt.set(byArray, suite.getFixedIvLength(), recordIv);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(suite.getCipherTagSizeInBytes() * 8, iv);
        cipher2.init(2, (Key)key, (AlgorithmParameterSpec)object);
        int contentSize = recordLength - (suite.getIvLength() - suite.getFixedIvLength()) - suite.getCipherTagSizeInBytes();
        if (!(contentSize < 65536)) {
            object = "Content size should fit in 2 bytes, actual: " + contentSize;
            throw new IllegalStateException(object.toString());
        }
        object = new byte[13];
        byte[] it = object;
        CipherKt.set((byte[])object, 0, recordId);
        it[8] = (byte)var2_4.getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set((byte[])var3_6, 11, (short)contentSize);
        Object aad = object;
        cipher2.updateAAD((byte[])var0_2);
        return cipher2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Cipher access$gcmEncryptCipher(CipherSuite suite, byte[] keyMaterial, TLSRecordType recordType, int recordLength, long recordIv, long recordId) {
        void var3_3;
        void var2_2;
        void var1_1;
        return GCMCipherKt.gcmEncryptCipher(suite, (byte[])var1_1, (TLSRecordType)var2_2, (int)var3_3, recordIv, recordId);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Cipher access$gcmDecryptCipher(CipherSuite suite, byte[] keyMaterial, TLSRecordType recordType, int recordLength, long recordIv, long recordId) {
        void var3_3;
        void var2_2;
        void var1_1;
        return GCMCipherKt.gcmDecryptCipher(suite, (byte[])var1_1, (TLSRecordType)var2_2, (int)var3_3, recordIv, recordId);
    }
}

