/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.cipher.CipherKt;
import io.ktor.network.util.PoolsKt;
import io.ktor.utils.io.core.BytePacketBuilderExtensions_jvmKt;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import io.ktor.utils.io.core.ByteReadPacketExtensions_jvmKt;
import io.ktor.utils.io.pool.ByteBufferPool;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Sink;
import kotlinx.io.Source;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a6\u0010\b\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0019\b\u0002\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0000\u00a2\u0006\u0004\b\b\u0010\t\" \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f"}, d2={"Lkotlinx/io/Source;", "Ljavax/crypto/Cipher;", "cipher", "Lkotlin/Function1;", "Lkotlinx/io/Sink;", "", "Lkotlin/ExtensionFunctionType;", "header", "cipherLoop", "(Lkotlinx/io/Source;Ljavax/crypto/Cipher;Lkotlin/jvm/functions/Function1;)Lkotlinx/io/Source;", "Lio/ktor/utils/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "CryptoBufferPool", "Lio/ktor/utils/io/pool/ObjectPool;", "getCryptoBufferPool", "()Lio/ktor/utils/io/pool/ObjectPool;"})
@SourceDebugExtension(value={"SMAP\nCipherUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CipherUtils.kt\nio/ktor/network/tls/cipher/CipherUtilsKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n19#2,2:77\n21#2:80\n1#3:79\n*S KotlinDebug\n*F\n+ 1 CipherUtils.kt\nio/ktor/network/tls/cipher/CipherUtilsKt\n*L\n22#1:77,2\n22#1:80\n*E\n"})
public final class CipherUtilsKt {
    private static final ObjectPool<ByteBuffer> CryptoBufferPool = (ObjectPool)new ByteBufferPool(128, 65536);

    public static final ObjectPool<ByteBuffer> getCryptoBufferPool() {
        return CryptoBufferPool;
    }

    /*
     * WARNING - void declaration
     */
    public static final Source cipherLoop(Source $this$cipherLoop, Cipher cipher, Function1<? super Sink, Unit> header) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$cipherLoop, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"cipher");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        ByteBuffer srcBuffer = (ByteBuffer)PoolsKt.getDefaultByteBufferPool().borrow();
        Object dstBuffer = CryptoBufferPool.borrow();
        boolean dstBufferFromPool = true;
        try {
            int rc;
            Buffer builder$iv = new Buffer();
            Sink $this$cipherLoop_u24lambda_u243 = (Sink)builder$iv;
            srcBuffer.clear();
            header.invoke((Object)$this$cipherLoop_u24lambda_u243);
            while (true) {
                rc = srcBuffer.hasRemaining() ? ByteReadPacketExtensions_jvmKt.readAvailable((Source)$this$cipherLoop, (ByteBuffer)srcBuffer) : 0;
                srcBuffer.flip();
                if (!srcBuffer.hasRemaining() && (rc == -1 || $this$cipherLoop.exhausted())) break;
                ((ByteBuffer)dstBuffer).clear();
                if (cipher.getOutputSize(srcBuffer.remaining()) > ((ByteBuffer)dstBuffer).remaining()) {
                    if (dstBufferFromPool) {
                        CryptoBufferPool.recycle(dstBuffer);
                    }
                    dstBuffer = ByteBuffer.allocate(cipher.getOutputSize(srcBuffer.remaining()));
                    dstBufferFromPool = false;
                }
                cipher.update(srcBuffer, (ByteBuffer)dstBuffer);
                ((ByteBuffer)dstBuffer).flip();
                BytePacketBuilderExtensions_jvmKt.writeFully((Sink)$this$cipherLoop_u24lambda_u243, (ByteBuffer)((ByteBuffer)dstBuffer));
                srcBuffer.compact();
            }
            int n = rc = !srcBuffer.hasRemaining() ? 1 : 0;
            if (_Assertions.ENABLED && rc == 0) {
                object = "Cipher loop completed too early: there are unprocessed bytes";
                throw new AssertionError(object);
            }
            int n2 = rc = !((ByteBuffer)dstBuffer).hasRemaining() ? 1 : 0;
            if (_Assertions.ENABLED && rc == 0) {
                object = "Not all bytes were appended to the packet";
                throw new AssertionError(object);
            }
            int requiredBufferSize = cipher.getOutputSize(0);
            if (requiredBufferSize != 0) {
                void var2_3;
                if (var2_3 > ((ByteBuffer)dstBuffer).capacity()) {
                    byte[] byArray = cipher.doFinal();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
                    BytePacketBuilderKt.writeFully$default((Sink)$this$cipherLoop_u24lambda_u243, (byte[])byArray, (int)0, (int)0, (int)6, null);
                } else {
                    ((ByteBuffer)dstBuffer).clear();
                    cipher.doFinal(CipherKt.getEmptyByteBuffer(), (ByteBuffer)dstBuffer);
                    ((ByteBuffer)dstBuffer).flip();
                    if (!((ByteBuffer)dstBuffer).hasRemaining()) {
                        void var1_1;
                        byte[] byArray = var1_1.doFinal();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
                        BytePacketBuilderKt.writeFully$default((Sink)$this$cipherLoop_u24lambda_u243, (byte[])byArray, (int)0, (int)0, (int)6, null);
                    } else {
                        BytePacketBuilderExtensions_jvmKt.writeFully((Sink)$this$cipherLoop_u24lambda_u243, (ByteBuffer)((ByteBuffer)dstBuffer));
                    }
                }
            }
            object = (Source)builder$iv;
        }
        catch (Throwable throwable) {
            void var3_4;
            PoolsKt.getDefaultByteBufferPool().recycle((Object)var3_4);
            if (dstBufferFromPool) {
                CryptoBufferPool.recycle(dstBuffer);
            }
            throw throwable;
        }
        PoolsKt.getDefaultByteBufferPool().recycle((Object)srcBuffer);
        if (dstBufferFromPool) {
            CryptoBufferPool.recycle(dstBuffer);
        }
        return object;
    }

    public static /* synthetic */ Source cipherLoop$default(Source source, Cipher cipher, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = CipherUtilsKt::cipherLoop$lambda$0;
        }
        return CipherUtilsKt.cipherLoop(source, cipher, (Function1<? super Sink, Unit>)function1);
    }

    private static final Unit cipherLoop$lambda$0(Sink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"<this>");
        return Unit.INSTANCE;
    }
}

