/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.http.IpParserKt;
import io.ktor.network.tls.TLSException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u001f\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001f\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\b\u0010\u0006\u001a\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\r*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00000\r*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000f\"\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\"\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013"}, d2={"", "serverName", "Ljava/security/cert/X509Certificate;", "certificate", "", "verifyHostnameInCertificate", "(Ljava/lang/String;Ljava/security/cert/X509Certificate;)V", "ipString", "verifyIpInCertificate", "certificateHost", "", "matchHostnameWithCertificate", "(Ljava/lang/String;Ljava/lang/String;)Z", "", "hosts", "(Ljava/security/cert/X509Certificate;)Ljava/util/List;", "ips", "", "DNS_NAME_TYPE", "I", "IP_ADDRESS_TYPE"})
@SourceDebugExtension(value={"SMAP\nHostnameUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostnameUtils.kt\nio/ktor/network/tls/HostnameUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1755#2,3:104\n774#2:107\n865#2,2:108\n1557#2:110\n1628#2,3:111\n1755#2,3:114\n774#2:117\n865#2,2:118\n1557#2:120\n1628#2,3:121\n774#2:124\n865#2,2:125\n1557#2:127\n1628#2,3:128\n*S KotlinDebug\n*F\n+ 1 HostnameUtils.kt\nio/ktor/network/tls/HostnameUtilsKt\n*L\n21#1:104,3\n31#1:107\n31#1:108,2\n32#1:110\n32#1:111,3\n35#1:114,3\n95#1:117\n95#1:118,2\n96#1:120\n96#1:121,3\n100#1:124\n100#1:125,2\n101#1:127\n101#1:128,3\n*E\n"})
public final class HostnameUtilsKt {
    private static final int DNS_NAME_TYPE = 2;
    private static final int IP_ADDRESS_TYPE = 7;

    /*
     * WARNING - void declaration
     */
    public static final void verifyHostnameInCertificate(String serverName, X509Certificate certificate) {
        void var1_1;
        String string;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        if (IpParserKt.hostIsIp((String)serverName)) {
            HostnameUtilsKt.verifyIpInCertificate(serverName, certificate);
            return;
        }
        List<String> hosts = HostnameUtilsKt.hosts(certificate);
        if (hosts.isEmpty()) {
            return;
        }
        Iterable $this$any$iv = hosts;
        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                String it = (String)t;
                if (!HostnameUtilsKt.matchHostnameWithCertificate(serverName, t)) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            return;
        }
        throw new TLSException("No server host: " + string + " in the server certificate. Provided in certificate: " + CollectionsKt.joinToString$default((Iterable)((Iterable)var1_1), null, null, null, (int)0, null, null, (int)63, null), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void verifyIpInCertificate(String ipString, X509Certificate certificate) {
        void var1_1;
        String string;
        boolean bl;
        Collection destination$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)ipString, (String)"ipString");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Iterator iterator = certificate.getSubjectAlternativeNames();
        if (iterator != null) {
            List $this$mapTo$iv$iv;
            Collection<String> collection;
            void $this$filterTo$iv$iv;
            iterator = (Iterable)((Object)iterator);
            object = iterator;
            Iterable destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                collection = (List)element$iv$iv;
                Object e = collection.get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Int");
                if (!((Integer)e == 7)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv2;
            destination$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                $this$mapTo$iv$iv = (List)item$iv$iv;
                collection = destination$iv$iv;
                Object e = it.get(1);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
                collection.add((String)e);
            }
        } else {
            return;
        }
        List ips = (List)destination$iv$iv;
        if (ips.isEmpty()) {
            return;
        }
        Iterable $this$any$iv = ips;
        if (!((Collection)$this$any$iv).isEmpty()) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!Intrinsics.areEqual((Object)(object = (String)object), (Object)ipString)) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            return;
        }
        throw new TLSException("No server host: " + string + " in the server certificate. The certificate was issued for: " + CollectionsKt.joinToString$default((Iterable)((Iterable)var1_1), null, null, null, (int)0, null, null, (int)63, null) + '.', null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean matchHostnameWithCertificate(String serverName, String certificateHost) {
        void var3_4;
        List list;
        void var1_2;
        boolean wildcardUsedCorrect;
        Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
        Intrinsics.checkNotNullParameter((Object)certificateHost, (String)"certificateHost");
        if (StringsKt.equals((String)serverName, (String)certificateHost, (boolean)true)) {
            return true;
        }
        char[] cArray = new char[1];
        char[] cArray2 = cArray;
        cArray[0] = 46;
        List nameChunks = CollectionsKt.asReversed((List)StringsKt.split$default((CharSequence)serverName, (char[])cArray2, (boolean)false, (int)0, (int)6, null));
        CharSequence charSequence = (CharSequence)certificateHost;
        char[] cArray3 = new char[1];
        certificateHost = cArray3;
        cArray3[0] = 46;
        List certificateChunks = CollectionsKt.asReversed((List)StringsKt.split$default((CharSequence)charSequence, (char[])certificateHost, (boolean)false, (int)0, (int)6, null));
        int nameIndex = 0;
        int certificateIndex = 0;
        boolean wildcardFound = false;
        int labels = 0;
        while (nameIndex < nameChunks.size() && certificateIndex < certificateChunks.size()) {
            String nameChunk = (String)nameChunks.get(nameIndex);
            if (nameIndex == 0 && ((CharSequence)nameChunk).length() == 0) {
                ++nameIndex;
                continue;
            }
            String certificateChunk = (String)certificateChunks.get(certificateIndex);
            if (certificateIndex == 0 && ((CharSequence)certificateChunk).length() == 0) {
                ++certificateIndex;
                continue;
            }
            if (!wildcardFound && StringsKt.equals((String)nameChunk, (String)certificateChunk, (boolean)true)) {
                ++labels;
                ++nameIndex;
                ++certificateIndex;
                continue;
            }
            if (Intrinsics.areEqual((Object)certificateChunk, (Object)"*")) {
                wildcardFound = true;
                ++nameIndex;
                ++certificateIndex;
                continue;
            }
            return false;
        }
        boolean bl = wildcardUsedCorrect = !wildcardFound || labels >= 2;
        return var1_2 == list.size() && var3_4 == cArray2.size() && wildcardUsedCorrect;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> hosts(X509Certificate $this$hosts) {
        if (($this$hosts = ((X509Certificate)$this$hosts).getSubjectAlternativeNames()) != null) {
            Collection collection;
            void $this$mapTo$iv$iv;
            Object object;
            Collection $this$filterTo$iv$iv;
            $this$hosts = (Iterable)$this$hosts;
            Iterable destination$iv$iv = new ArrayList();
            $this$filterTo$iv$iv = $this$filterTo$iv$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Iterator iterator;
                Object element$iv$iv = $this$filterTo$iv$iv.next();
                object = (List)element$iv$iv;
                Object e = object.get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Int");
                if (!((Integer)e == 2)) continue;
                destination$iv$iv.add(iterator);
            }
            Collection $this$map$iv = (List)destination$iv$iv;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void var1_1;
                List it = object;
                object = destination$iv$iv2;
                Object e = var1_1.get(1);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
                object.add((String)e);
            }
            return (List)collection;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> ips(X509Certificate $this$ips) {
        if (($this$ips = ((X509Certificate)$this$ips).getSubjectAlternativeNames()) != null) {
            Collection collection;
            void $this$mapTo$iv$iv;
            Object object;
            Collection $this$filterTo$iv$iv;
            $this$ips = (Iterable)$this$ips;
            Iterable destination$iv$iv = new ArrayList();
            $this$filterTo$iv$iv = $this$filterTo$iv$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Iterator iterator;
                Object element$iv$iv = $this$filterTo$iv$iv.next();
                object = (List)element$iv$iv;
                Object e = object.get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Int");
                if (!((Integer)e == 7)) continue;
                destination$iv$iv.add(iterator);
            }
            Collection $this$map$iv = (List)destination$iv$iv;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void var1_1;
                List it = object;
                object = destination$iv$iv2;
                Object e = var1_1.get(1);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
                object.add((String)e);
            }
            return (List)collection;
        }
        return CollectionsKt.emptyList();
    }
}

