/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.io._UtilKt;
import kotlinx.io.internal._Utf8Kt;
import kotlinx.io.unsafe.SegmentWriteContext;
import kotlinx.io.unsafe.UnsafeBufferOperationsKt;

@SourceDebugExtension(value={"SMAP\nUtf8.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utf8.kt\nkotlinx/io/Utf8Kt\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 Sinks.kt\nkotlinx/io/SinksKt\n+ 4 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperationsKt\n*L\n1#1,624:1\n471#1,7:631\n478#1,15:640\n496#1,57:674\n471#1,7:735\n478#1,15:744\n496#1,57:778\n38#2:625\n38#2:629\n38#2:733\n97#2:838\n97#2:839\n97#2:840\n97#2:841\n97#2:842\n97#2:843\n97#2:844\n97#2:845\n97#2:846\n97#2:847\n374#3,3:626\n374#3:630\n375#3,2:731\n374#3:734\n375#3,2:835\n262#4,2:638\n266#4,19:655\n262#4,2:742\n266#4,19:759\n262#4,23:848\n262#4,23:871\n262#4,23:894\n262#4,23:917\n262#4,23:940\n262#4,23:963\n262#4,23:986\n378#4,3:1009\n381#4,3:1013\n1#5:837\n434#6:1012\n*S KotlinDebug\n*F\n+ 1 Utf8.kt\nkotlinx/io/Utf8Kt\n*L\n173#1:631,7\n173#1:640,15\n173#1:674,57\n194#1:735,7\n194#1:744,15\n194#1:778,57\n89#1:625\n171#1:629\n192#1:733\n395#1:838\n397#1:839\n402#1:840\n404#1:841\n409#1:842\n411#1:843\n416#1:844\n418#1:845\n439#1:846\n442#1:847\n153#1:626,3\n173#1:630\n173#1:731,2\n194#1:734\n194#1:835,2\n173#1:638,2\n173#1:655,19\n194#1:742,2\n194#1:759,19\n477#1:848,23\n498#1:871,23\n511#1:894,23\n538#1:917,23\n570#1:940,23\n584#1:963,23\n594#1:986,23\n610#1:1009,3\n610#1:1013,3\n613#1:1012\n*E\n"})
public final class Utf8Kt {
    /*
     * WARNING - void declaration
     */
    public static final void writeCodePointValue(Sink $this$writeCodePointValue, int codePoint) {
        Segment segment;
        void var1_1;
        Sink sink;
        Intrinsics.checkNotNullParameter((Object)$this$writeCodePointValue, (String)"<this>");
        sink = sink.getBuffer();
        if (var1_1 < 0 || var1_1 > 0x10FFFF) {
            throw new IllegalArgumentException("Code point value is out of Unicode codespace 0..0x10ffff: 0x" + _UtilKt.toHexString((int)var1_1) + " (" + (int)var1_1 + ')');
        }
        if (var1_1 < 128) {
            ((Buffer)sink).writeByte((byte)var1_1);
            return;
        }
        if (var1_1 < 2048) {
            Segment segment2;
            Segment segment3 = segment2 = ((Buffer)sink).writableSegment(2);
            SegmentWriteContext segmentWriteContext = UnsafeBufferOperationsKt.getSegmentWriteContextImpl();
            segmentWriteContext.setUnchecked(segment3, 0, (byte)(var1_1 >> 6 | 0xC0));
            segmentWriteContext.setUnchecked(segment3, 1, (byte)(var1_1 & 0x3F | 0x80));
            Segment segment4 = segment2;
            segment4.setLimit(segment4.getLimit() + 2);
            Sink sink2 = sink;
            ((Buffer)sink2).setSizeMut(((Buffer)sink2).getSizeMut() + 2L);
            return;
        }
        boolean bl = 55296 <= var1_1 ? var1_1 < 57344 : false;
        if (bl) {
            ((Buffer)sink).writeByte((byte)63);
            return;
        }
        if (var1_1 < 65536) {
            Segment segment5;
            Segment segment6 = segment5 = ((Buffer)sink).writableSegment(3);
            SegmentWriteContext segmentWriteContext = UnsafeBufferOperationsKt.getSegmentWriteContextImpl();
            segmentWriteContext.setUnchecked(segment6, 0, (byte)(var1_1 >> 12 | 0xE0));
            segmentWriteContext.setUnchecked(segment6, 1, (byte)(var1_1 >> 6 & 0x3F | 0x80));
            segmentWriteContext.setUnchecked(segment6, 2, (byte)(var1_1 & 0x3F | 0x80));
            Segment segment7 = segment5;
            segment7.setLimit(segment7.getLimit() + 3);
            Sink sink3 = sink;
            ((Buffer)sink3).setSizeMut(((Buffer)sink3).getSizeMut() + 3L);
            return;
        }
        Segment segment8 = segment = ((Buffer)sink).writableSegment(4);
        SegmentWriteContext segmentWriteContext = UnsafeBufferOperationsKt.getSegmentWriteContextImpl();
        segmentWriteContext.setUnchecked(segment8, 0, (byte)(var1_1 >> 18 | 0xF0));
        segmentWriteContext.setUnchecked(segment8, 1, (byte)(var1_1 >> 12 & 0x3F | 0x80));
        segmentWriteContext.setUnchecked(segment8, 2, (byte)(var1_1 >> 6 & 0x3F | 0x80));
        segmentWriteContext.setUnchecked(segment8, 3, (byte)(var1_1 & 0x3F | 0x80));
        Segment segment9 = segment;
        segment9.setLimit(segment9.getLimit() + 4);
        Sink sink4 = sink;
        ((Buffer)sink4).setSizeMut(((Buffer)sink4).getSizeMut() + 4L);
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeString(Sink $this$writeString, String string, int startIndex, int endIndex) {
        void i$iv;
        Intrinsics.checkNotNullParameter((Object)$this$writeString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int n = string.length();
        _UtilKt.checkBounds(n, startIndex, endIndex);
        Sink sink = $this$writeString;
        Object $this$commonWriteUtf8$iv = sink.getBuffer();
        while (i$iv < endIndex) {
            void segment$iv;
            Segment tail$iv$iv;
            char low$iv22;
            void bytesWritten$iv$iv2;
            block14: {
                block13: {
                    char c;
                    Segment segment$iv2;
                    SegmentWriteContext ctx$iv;
                    Segment tail$iv$iv2;
                    void p0;
                    Ref.IntRef c$iv = new Ref.IntRef();
                    void var5_10 = i$iv;
                    Ref.IntRef intRef = c$iv;
                    intRef.element = Character.valueOf(string.charAt((int)p0)).charValue();
                    if (c$iv.element < 128) {
                        void bytesWritten$iv$iv2;
                        Segment segment = tail$iv$iv2 = ((Buffer)$this$commonWriteUtf8$iv).writableSegment(1);
                        ctx$iv = UnsafeBufferOperationsKt.getSegmentWriteContextImpl();
                        void segmentOffset$iv = -i$iv;
                        int runLimit$iv = Math.min(endIndex, (int)(i$iv + segment$iv2.getRemainingCapacity()));
                        p0 = i$iv;
                        i$iv = p0 + true;
                        ctx$iv.setUnchecked(segment$iv2, (int)(segmentOffset$iv + p0), (byte)c$iv.element);
                        while (i$iv < runLimit$iv) {
                            p0 = i$iv;
                            intRef = c$iv;
                            intRef.element = Character.valueOf(string.charAt((int)p0)).charValue();
                            if (c$iv.element >= 128) break;
                            p0 = i$iv;
                            i$iv = p0 + true;
                            ctx$iv.setUnchecked(segment$iv2, (int)(segmentOffset$iv + p0), (byte)c$iv.element);
                        }
                        if ((bytesWritten$iv$iv2 = i$iv + segmentOffset$iv) == true) {
                            Segment segment2 = tail$iv$iv2;
                            segment2.setLimit(segment2.getLimit() + bytesWritten$iv$iv2);
                            Sink sink2 = $this$commonWriteUtf8$iv;
                            ((Buffer)sink2).setSizeMut(((Buffer)sink2).getSizeMut() + (long)bytesWritten$iv$iv2);
                            continue;
                        }
                        if (!(bytesWritten$iv$iv2 >= 0 ? bytesWritten$iv$iv2 <= tail$iv$iv2.getRemainingCapacity() : false)) {
                            $this$commonWriteUtf8$iv = "Invalid number of bytes written: " + (int)bytesWritten$iv$iv2 + ". Should be in 0.." + tail$iv$iv2.getRemainingCapacity();
                            throw new IllegalStateException($this$commonWriteUtf8$iv.toString());
                        }
                        if (bytesWritten$iv$iv2 != false) {
                            Segment segment3 = tail$iv$iv2;
                            segment3.setLimit(segment3.getLimit() + bytesWritten$iv$iv2);
                            Sink sink3 = $this$commonWriteUtf8$iv;
                            ((Buffer)sink3).setSizeMut(((Buffer)sink3).getSizeMut() + (long)bytesWritten$iv$iv2);
                            continue;
                        }
                        if (!SegmentKt.isEmpty(tail$iv$iv2)) continue;
                        ((Buffer)$this$commonWriteUtf8$iv).recycleTail();
                        continue;
                    }
                    if (bytesWritten$iv$iv2.element < 2048) {
                        segment$iv2 = tail$iv$iv2 = ((Buffer)$this$commonWriteUtf8$iv).writableSegment(2);
                        ctx$iv = UnsafeBufferOperationsKt.getSegmentWriteContextImpl();
                        ctx$iv.setUnchecked(segment$iv2, 0, (byte)(bytesWritten$iv$iv2.element >> 6 | 0xC0), (byte)(bytesWritten$iv$iv2.element & 0x3F | 0x80));
                        Segment segment = tail$iv$iv2;
                        segment.setLimit(segment.getLimit() + 2);
                        Sink sink4 = $this$commonWriteUtf8$iv;
                        ((Buffer)sink4).setSizeMut(((Buffer)sink4).getSizeMut() + 2L);
                        p0 = i$iv;
                        i$iv = p0 + true;
                        continue;
                    }
                    if (bytesWritten$iv$iv2.element < 55296 || bytesWritten$iv$iv2.element > 57343) {
                        segment$iv2 = tail$iv$iv2 = ((Buffer)$this$commonWriteUtf8$iv).writableSegment(3);
                        ctx$iv = UnsafeBufferOperationsKt.getSegmentWriteContextImpl();
                        ctx$iv.setUnchecked(segment$iv2, 0, (byte)(bytesWritten$iv$iv2.element >> 12 | 0xE0), (byte)(bytesWritten$iv$iv2.element >> 6 & 0x3F | 0x80), (byte)(bytesWritten$iv$iv2.element & 0x3F | 0x80));
                        Segment segment = tail$iv$iv2;
                        segment.setLimit(segment.getLimit() + 3);
                        Sink sink5 = $this$commonWriteUtf8$iv;
                        ((Buffer)sink5).setSizeMut(((Buffer)sink5).getSizeMut() + 3L);
                        p0 = i$iv;
                        i$iv = p0 + true;
                        continue;
                    }
                    if (i$iv + true < endIndex) {
                        p0 = i$iv + true;
                        c = string.charAt((int)p0);
                    } else {
                        c = low$iv22 = '\u0000';
                    }
                    if (bytesWritten$iv$iv2.element > 56319) break block13;
                    if ('\udc00' <= low$iv22 ? low$iv22 < '\ue000' : false) break block14;
                }
                ((Buffer)$this$commonWriteUtf8$iv).writeByte((byte)63);
                void bytesWritten$iv$iv2 = i$iv;
                i$iv = bytesWritten$iv$iv2 + true;
                continue;
            }
            int codePoint$iv = 65536 + ((bytesWritten$iv$iv2.element & 0x3FF) << 10 | low$iv22 & 0x3FF);
            Segment low$iv22 = tail$iv$iv = ((Buffer)$this$commonWriteUtf8$iv).writableSegment(4);
            SegmentWriteContext segmentWriteContext = UnsafeBufferOperationsKt.getSegmentWriteContextImpl();
            segmentWriteContext.setUnchecked((Segment)segment$iv, 0, (byte)(codePoint$iv >> 18 | 0xF0), (byte)(codePoint$iv >> 12 & 0x3F | 0x80), (byte)(codePoint$iv >> 6 & 0x3F | 0x80), (byte)(codePoint$iv & 0x3F | 0x80));
            Segment segment = tail$iv$iv;
            segment.setLimit(segment.getLimit() + 4);
            Object object = $this$commonWriteUtf8$iv;
            ((Buffer)object).setSizeMut(((Buffer)object).getSizeMut() + 4L);
            i$iv += 2;
        }
    }

    public static /* synthetic */ void writeString$default$7c23624d(Sink sink, String string, int n, int n2, int n3) {
        n2 = string.length();
        Utf8Kt.writeString(sink, string, 0, n2);
    }

    public static final String readString(Source $this$readString) {
        Source source;
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        $this$readString.request(Long.MAX_VALUE);
        return Utf8Kt.commonReadUtf8($this$readString.getBuffer(), source.getBuffer().getSize());
    }

    public static final String readString(Buffer $this$readString) {
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        Buffer buffer2 = buffer;
        return Utf8Kt.commonReadUtf8(buffer2, buffer2.getSize());
    }

    /*
     * WARNING - void declaration
     */
    public static final String readString(Source $this$readString, long byteCount) {
        void var1_1;
        Source source;
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        $this$readString.require(byteCount);
        return Utf8Kt.commonReadUtf8(source.getBuffer(), (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final int readCodePointValue(Source $this$readCodePointValue) {
        Source source;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$readCodePointValue, (String)"<this>");
        if ($this$readCodePointValue instanceof Buffer) {
            return Utf8Kt.commonReadUtf8CodePoint((Buffer)$this$readCodePointValue);
        }
        $this$readCodePointValue.require(1L);
        byte b0 = $this$readCodePointValue.getBuffer().get(0L);
        if ((b0 & 0xE0) == 192) {
            $this$readCodePointValue.require(2L);
        } else if ((b0 & 0xF0) == 224) {
            $this$readCodePointValue.require(3L);
        } else if ((var1_1 & 0xF8) == 240) {
            $this$readCodePointValue.require(4L);
        }
        return Utf8Kt.commonReadUtf8CodePoint(source.getBuffer());
    }

    /*
     * WARNING - void declaration
     */
    private static final int commonReadUtf8CodePoint(Buffer $this$commonReadUtf8CodePoint) {
        void var2_3;
        void var3_4;
        Buffer buffer;
        int min;
        int byteCount;
        int codePoint;
        byte b0;
        $this$commonReadUtf8CodePoint.require(1L);
        byte by = b0 = $this$commonReadUtf8CodePoint.get(0L);
        if ((b0 & 0x80) == 0) {
            by = b0;
            codePoint = by & 0x7F;
            byteCount = 1;
            min = 0;
        } else {
            by = b0;
            if ((by & 0xE0) == 192) {
                by = b0;
                codePoint = by & 0x1F;
                byteCount = 2;
                min = 128;
            } else {
                by = b0;
                if ((by & 0xF0) == 224) {
                    by = b0;
                    codePoint = by & 0xF;
                    byteCount = 3;
                    min = 2048;
                } else {
                    by = b0;
                    if ((by & 0xF8) == 240) {
                        by = b0;
                        codePoint = by & 7;
                        byteCount = 4;
                        min = 65536;
                    } else {
                        $this$commonReadUtf8CodePoint.skip(1L);
                        return 65533;
                    }
                }
            }
        }
        if ($this$commonReadUtf8CodePoint.getSize() < (long)byteCount) {
            throw new EOFException("size < " + byteCount + ": " + $this$commonReadUtf8CodePoint.getSize() + " (to read code point prefixed 0x" + _UtilKt.toHexString(b0) + ')');
        }
        for (int i = 1; i < byteCount; ++i) {
            byte b;
            byte by2 = b = $this$commonReadUtf8CodePoint.get(i);
            if ((b & 0xC0) == 128) {
                void var1_1;
                codePoint <<= 6;
                by2 = var1_1;
                codePoint |= by2 & 0x3F;
                continue;
            }
            $this$commonReadUtf8CodePoint.skip(i);
            return 65533;
        }
        buffer.skip((long)var3_4);
        if (codePoint > 0x10FFFF) {
            return 65533;
        }
        boolean bl = 55296 <= codePoint ? codePoint < 57344 : false;
        if (bl) {
            return 65533;
        }
        if (codePoint < min) {
            return 65533;
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final String commonReadUtf8(Buffer $this$commonReadUtf8, long byteCount) {
        if (byteCount == 0L) {
            return "";
        }
        Segment curr$iv = $this$commonReadUtf8.getHead();
        if (curr$iv != null) {
            void var1_1;
            Buffer buffer;
            UnsafeBufferOperationsKt.getSegmentReadContextImpl();
            Segment segment2 = curr$iv;
            if ((long)segment2.getSize() >= byteCount) {
                void var3_4;
                void limit;
                void pos;
                int segment2 = segment2.getLimit();
                int n = segment2.getPos();
                byte[] byArray = segment2.dataAsByteArray$25d3abe();
                String result = _Utf8Kt.commonToUtf8String(byArray, (int)pos, Math.min((int)limit, (int)(pos + (int)byteCount)));
                $this$commonReadUtf8.skip(byteCount);
                return var3_4;
            }
            return _Utf8Kt.commonToUtf8String$default$2d34d743(SourcesKt.readByteArray(buffer, (int)var1_1), 0, 0, 3);
        }
        throw new IllegalStateException("Unreacheable".toString());
    }
}

