/*
 * Decompiled with CFR 0.152.
 */
package shared.system.files;

import java.io.Closeable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import shared.system.files.ApplicationDirectories;
import shared.system.files.HasLocalInstallationDirectory;
import shared.system.files.OkioUtils_jvmKt;
import shared.system.files.SystemFileSystem_jvmKt;
import shared.system.os.DesktopOS;
import shared.system.os.DesktopOSKt;

public final class DesktopApplicationDirectories
extends ApplicationDirectories
implements HasLocalInstallationDirectory {
    private final String applicationName;
    private final Path localInstallationDirectory;
    private final Path userDir;
    private final Lazy configurationDirectory$delegate;
    private final Lazy dataDirectory$delegate;
    private final Lazy logDirectory$delegate;
    private final Lazy cacheDirectory$delegate;
    private final Lazy temporaryDirectory$delegate;

    /*
     * WARNING - void declaration
     */
    public DesktopApplicationDirectories(String applicationName, Path localInstallationDirectory) {
        void var2_2;
        String string;
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)localInstallationDirectory, (String)"localInstallationDirectory");
        this.applicationName = string;
        this.localInstallationDirectory = var2_2;
        String string2 = System.getenv("USERPROFILE");
        if (string2 == null) {
            string2 = System.getProperty("user.home");
        }
        string = string2;
        Intrinsics.checkNotNull((Object)string2);
        this.userDir = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null);
        this.configurationDirectory$delegate = LazyKt.lazy(() -> DesktopApplicationDirectories.configurationDirectory_delegate$lambda$0(this));
        this.dataDirectory$delegate = LazyKt.lazy(() -> DesktopApplicationDirectories.dataDirectory_delegate$lambda$1(this));
        this.logDirectory$delegate = LazyKt.lazy(() -> DesktopApplicationDirectories.logDirectory_delegate$lambda$2(this));
        this.cacheDirectory$delegate = LazyKt.lazy(() -> DesktopApplicationDirectories.cacheDirectory_delegate$lambda$3(this));
        this.temporaryDirectory$delegate = LazyKt.lazy(() -> DesktopApplicationDirectories.temporaryDirectory_delegate$lambda$4(this));
    }

    @Override
    public final Path getLocalInstallationDirectory() {
        return this.localInstallationDirectory;
    }

    @Override
    public final Path getConfigurationDirectory() {
        Lazy lazy = this.configurationDirectory$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    public final Path getDataDirectory() {
        Lazy lazy = this.dataDirectory$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    public final Path getLogDirectory() {
        Lazy lazy = this.logDirectory$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    public final Path getCacheDirectory() {
        Lazy lazy = this.cacheDirectory$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    public final Path getTemporaryDirectory() {
        Lazy lazy = this.temporaryDirectory$delegate;
        return (Path)lazy.getValue();
    }

    private final Path persistentDir(String dirName) {
        return DesktopApplicationDirectories.probed(switch (WhenMappings.$EnumSwitchMapping$0[DesktopOSKt.getCurrentDesktopOS().ordinal()]) {
            case 1 -> Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)this.userDir, (String)".local", (boolean)false, (int)2, null), (String)"share", (boolean)false, (int)2, null), (String)this.applicationName, (boolean)false, (int)2, null), (String)dirName, (boolean)false, (int)2, null);
            case 2 -> Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)this.userDir, (String)"Library", (boolean)false, (int)2, null), (String)"Application Support", (boolean)false, (int)2, null), (String)this.applicationName, (boolean)false, (int)2, null), (String)dirName, (boolean)false, (int)2, null);
            case 3 -> {
                void var1_1;
                yield Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)this.userDir, (String)"AppData", (boolean)false, (int)2, null), (String)"Roaming", (boolean)false, (int)2, null), (String)this.applicationName, (boolean)false, (int)2, null), (String)var1_1, (boolean)false, (int)2, null);
            }
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    private final Path transientDir(String dirName) {
        return DesktopApplicationDirectories.probed(switch (WhenMappings.$EnumSwitchMapping$0[DesktopOSKt.getCurrentDesktopOS().ordinal()]) {
            case 1 -> Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)this.userDir, (String)".cache", (boolean)false, (int)2, null), (String)this.applicationName, (boolean)false, (int)2, null), (String)dirName, (boolean)false, (int)2, null);
            case 2 -> Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)this.userDir, (String)"Library", (boolean)false, (int)2, null), (String)"Caches", (boolean)false, (int)2, null), (String)this.applicationName, (boolean)false, (int)2, null), (String)dirName, (boolean)false, (int)2, null);
            case 3 -> {
                void var1_1;
                yield Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)this.userDir, (String)"AppData", (boolean)false, (int)2, null), (String)"LocalLow", (boolean)false, (int)2, null), (String)this.applicationName, (boolean)false, (int)2, null), (String)var1_1, (boolean)false, (int)2, null);
            }
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    /*
     * WARNING - void declaration
     */
    private static Path probed(Path $this$probed) {
        void var1_3;
        void var2_4;
        Object object;
        Object object2 = $this$probed;
        Path dir = object2;
        FileSystem $this$probed_u24lambda_u248_u24lambda_u247 = SystemFileSystem_jvmKt.getSystemFileSystem();
        $this$probed_u24lambda_u248_u24lambda_u247.createDirectories(dir);
        boolean bl = true;
        bl = false;
        Path path = dir;
        OkioUtils_jvmKt.withOwnerOnlyPermissions(path, false);
        Path probe = Path.resolve$default((Path)dir, (String)"write.probe", (boolean)false, (int)2, null);
        String ack = "ACK";
        Closeable closeable = (Closeable)Okio.buffer((Sink)$this$probed_u24lambda_u248_u24lambda_u247.sink(probe));
        Throwable throwable = null;
        try {
            object = (BufferedSink)closeable;
            object.writeUtf8(ack);
        }
        catch (Throwable throwable2) {
            try {
                object2 = throwable2;
                throwable = throwable2;
                throw object2;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, null);
        closeable = (Closeable)Okio.buffer((Source)$this$probed_u24lambda_u248_u24lambda_u247.source(probe));
        throwable = null;
        try {
            object = (BufferedSource)closeable;
            object = object.readUtf8();
            if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString(), (Object)path)) {
                object2 = "Failed requirement.";
                throw new IllegalArgumentException(object2.toString());
            }
        }
        catch (Throwable throwable4) {
            try {
                object2 = throwable4;
                throwable = throwable4;
                throw object2;
            }
            catch (Throwable throwable5) {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                throw throwable5;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, null);
        var2_4.delete((Path)var1_3);
        return object2;
    }

    private static final Path configurationDirectory_delegate$lambda$0(DesktopApplicationDirectories this$0) {
        return this$0.persistentDir("conf");
    }

    private static final Path dataDirectory_delegate$lambda$1(DesktopApplicationDirectories this$0) {
        return this$0.persistentDir("data");
    }

    private static final Path logDirectory_delegate$lambda$2(DesktopApplicationDirectories this$0) {
        return this$0.transientDir("log");
    }

    private static final Path cacheDirectory_delegate$lambda$3(DesktopApplicationDirectories this$0) {
        return this$0.transientDir("cache");
    }

    private static final Path temporaryDirectory_delegate$lambda$4(DesktopApplicationDirectories this$0) {
        return this$0.transientDir("tmp");
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DesktopOS.values().length];
            try {
                nArray[DesktopOS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

