/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.MonthKt;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.LocalDateFormat;
import kotlinx.datetime.internal.MathKt;
import kotlinx.datetime.serializers.LocalDateIso8601Serializer;
import kotlinx.serialization.Serializable;

@Serializable(with=LocalDateIso8601Serializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002&'B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nB\u000f\b\u0000\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u001f\u001a\u00020 2\b\u0010\u001e\u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u0003H\u0016J\u0006\u0010#\u001a\u00020\u0003J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0010\u001a\u00060\u0011j\u0002`\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u0015\u0010\u0007\u001a\u00060\bj\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000f\u00a8\u0006("}, d2={"Lkotlinx/datetime/LocalDate;", "", "year", "", "monthNumber", "dayOfMonth", "(III)V", "month", "Ljava/time/Month;", "Lkotlinx/datetime/Month;", "(ILjava/time/Month;I)V", "value", "Ljava/time/LocalDate;", "(Ljava/time/LocalDate;)V", "getDayOfMonth", "()I", "dayOfWeek", "Ljava/time/DayOfWeek;", "Lkotlinx/datetime/DayOfWeek;", "getDayOfWeek", "()Ljava/time/DayOfWeek;", "dayOfYear", "getDayOfYear", "getMonth", "()Ljava/time/Month;", "getMonthNumber", "getValue$kotlinx_datetime", "()Ljava/time/LocalDate;", "getYear", "compareTo", "other", "equals", "", "", "hashCode", "toEpochDays", "toString", "", "Companion", "Formats", "kotlinx-datetime"})
public final class LocalDate
implements Comparable<LocalDate> {
    public static final Companion Companion = new Companion(null);
    private final java.time.LocalDate value;
    private static final LocalDate MIN;
    private static final LocalDate MAX;

    /*
     * WARNING - void declaration
     */
    public LocalDate(java.time.LocalDate value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = var1_1;
    }

    public final java.time.LocalDate getValue$kotlinx_datetime() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public LocalDate(int year22, int monthNumber2, int dayOfMonth2) {
        void var1_2;
        LocalDate localDate;
        LocalDate localDate2 = this;
        try {
            void var3_5;
            void var2_4;
            localDate = localDate2;
            java.time.LocalDate year22 = java.time.LocalDate.of(year22, (int)var2_4, (int)var3_5);
        }
        catch (DateTimeException e) {
            void var1_3;
            throw new IllegalArgumentException((Throwable)var1_3);
        }
        Intrinsics.checkNotNull((Object)var1_2);
        localDate((java.time.LocalDate)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public LocalDate(int year2, Month month2, int dayOfMonth2) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)month2, (String)"month");
        this((int)var1_1, MonthKt.getNumber((Month)var2_2), (int)var3_3);
    }

    public final int getYear() {
        return this.value.getYear();
    }

    public final int getMonthNumber() {
        return this.value.getMonthValue();
    }

    public final Month getMonth() {
        Month month2 = this.value.getMonth();
        Intrinsics.checkNotNullExpressionValue((Object)month2, (String)"getMonth(...)");
        return month2;
    }

    public final int getDayOfMonth() {
        return this.value.getDayOfMonth();
    }

    public final DayOfWeek getDayOfWeek() {
        DayOfWeek dayOfWeek = this.value.getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"getDayOfWeek(...)");
        return dayOfWeek;
    }

    public final int getDayOfYear() {
        return this.value.getDayOfYear();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return this == other || other instanceof LocalDate && Intrinsics.areEqual((Object)this.value, (Object)((LocalDate)var1_1).value);
    }

    public final int hashCode() {
        return this.value.hashCode();
    }

    public final String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(LocalDate other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(var1_1.value);
    }

    public final int toEpochDays() {
        return MathKt.clampToInt(this.value.toEpochDay());
    }

    static {
        java.time.LocalDate localDate = java.time.LocalDate.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"MIN");
        MIN = new LocalDate(localDate);
        java.time.LocalDate localDate2 = java.time.LocalDate.MAX;
        Intrinsics.checkNotNullExpressionValue((Object)localDate2, (String)"MAX");
        MAX = new LocalDate(localDate2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\nJ\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aH\u00c6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lkotlinx/datetime/LocalDate$Companion;", "", "()V", "MAX", "Lkotlinx/datetime/LocalDate;", "getMAX$kotlinx_datetime", "()Lkotlinx/datetime/LocalDate;", "MIN", "getMIN$kotlinx_datetime", "Format", "Lkotlinx/datetime/format/DateTimeFormat;", "block", "Lkotlin/Function1;", "Lkotlinx/datetime/format/DateTimeFormatBuilder$WithDate;", "", "Lkotlin/ExtensionFunctionType;", "fromEpochDays", "epochDays", "", "parse", "input", "", "format", "isoString", "", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlinx-datetime"})
    @SourceDebugExtension(value={"SMAP\nLocalDate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDate.kt\nkotlinx/datetime/LocalDate$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private static LocalDate parse(CharSequence input, DateTimeFormat<LocalDate> format) {
            void var1_2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter(format, (String)"format");
            if (format == Formats.INSTANCE.getISO()) {
                try {
                    Object p0 = java.time.LocalDate.parse(input);
                    p0 = new LocalDate((java.time.LocalDate)p0);
                }
                catch (DateTimeParseException e) {
                    void var0_1;
                    throw new DateTimeFormatException((Throwable)var0_1);
                }
                return object;
            }
            return (LocalDate)var1_2.parse((CharSequence)object);
        }

        public static /* synthetic */ LocalDate parse$default$1ae73c53(Companion companion, CharSequence charSequence, DateTimeFormat dateTimeFormat, int n) {
            dateTimeFormat = Formats.INSTANCE.getISO();
            return kotlinx.datetime.LocalDate$Companion.parse(charSequence, dateTimeFormat);
        }

        public final LocalDate getMIN$kotlinx_datetime() {
            return MIN;
        }

        public final LocalDate getMAX$kotlinx_datetime() {
            return MAX;
        }

        public static DateTimeFormat<LocalDate> Format(Function1<? super DateTimeFormatBuilder.WithDate, Unit> block) {
            Function1<? super DateTimeFormatBuilder.WithDate, Unit> function1;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return LocalDateFormat.Companion.build(function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

